/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.event.SMUtilEvent;
import sweetmagic.api.iblock.ISMNeedItem;
import sweetmagic.init.tile.sm.TileAbstractMagicianLectern;

@Mod.EventBusSubscriber(modid="sweetmagic", value={Dist.CLIENT})
public class MagicianLecternViewEvent
extends SMUtilEvent {
    private static final ResourceLocation TEX = SweetMagicCore.getSRC("textures/gui/gui_usergage.png");
    private static List<ItemStack> stackList = new ArrayList<ItemStack>();
    private static boolean isHard = false;
    public static int tickTime = 0;
    public static int renderTick = 0;

    @SubscribeEvent
    public static void onWandRenderEvent(RenderGuiOverlayEvent.Post event) {
        if (!event.getOverlay().id().equals((Object)VanillaGuiOverlay.HOTBAR.id())) {
            return;
        }
        if (!stackList.isEmpty()) {
            int height = event.getWindow().m_85446_();
            int weight = event.getWindow().m_85445_();
            int addX = (int)(25.0f - 10.0f * MagicianLecternViewEvent.getProgress(20));
            int addY = -10;
            MagicianLecternViewEvent.renderStart(TEX);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)MagicianLecternViewEvent.getProgress(10));
            GuiGraphics gra = event.getGuiGraphics();
            PoseStack pose = gra.m_280168_();
            Matrix4f mat = pose.m_85850_().m_252922_();
            MagicianLecternViewEvent.drawTextured(mat, weight - 200 + addX, height - 186 + addY, 90, 144, 46, 97);
            MagicianLecternViewEvent.drawTextured(mat, weight - 200 + addX, height - 202 + addY, 145, 179, 104, 24);
            Minecraft mc = Minecraft.m_91087_();
            Font font = mc.f_91062_;
            float maxSize = 100.0f;
            for (int i = 0; i < 2; ++i) {
                MutableComponent tip = MagicianLecternViewEvent.getText("needitem_" + i);
                if (isHard) {
                    tip.m_7220_((Component)MagicianLecternViewEvent.getText("ishard").m_130940_(ChatFormatting.RED));
                }
                pose.m_85836_();
                int spSize = font.m_92895_(tip.getString());
                pose.m_85841_((float)spSize < maxSize ? 1.0f : maxSize / (float)spSize, 1.0f, 1.0f);
                float addX2 = (float)spSize < maxSize ? 1.0f : (float)spSize / maxSize;
                gra.drawString(font, tip.getString(), (float)(weight - 198 + addX) * addX2, (float)(height - 210 + i * 10), 16365640, true);
                pose.m_85849_();
            }
            List<ItemStack> stackList = MagicianLecternViewEvent.stackList;
            for (int i = 0; i < stackList.size(); ++i) {
                ItemStack stack = stackList.get(i);
                if (stack.m_41619_()) continue;
                gra.m_280480_(stack, weight - 195 + addX, height - 166 + addY + i * 18);
                gra.m_280370_(font, stack, weight - 195 + addX, height - 166 + addY + i * 18);
            }
            ++renderTick;
            if (++tickTime % 5 == 0) {
                tickTime = 0;
                MagicianLecternViewEvent.stackList.clear();
            }
        } else {
            renderTick = 0;
        }
    }

    @SubscribeEvent
    public static void highlightBlockEvent(RenderHighlightEvent.Block event) {
        Camera camera = event.getCamera();
        Entity entity = camera.m_90592_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Level world = player.m_9236_();
        BlockPos pos = event.getTarget().m_82425_();
        Block block = world.m_8055_(pos).m_60734_();
        stackList.clear();
        isHard = false;
        if (block instanceof ISMNeedItem) {
            ISMNeedItem needBlock = (ISMNeedItem)block;
            TileAbstractMagicianLectern tile = (TileAbstractMagicianLectern)world.m_7702_(pos);
            if (tile.summonType.is(TileAbstractMagicianLectern.SummonType.START) || tile.summonType.is(TileAbstractMagicianLectern.SummonType.END)) {
                isHard = needBlock.isHard(player);
                stackList = isHard ? needBlock.getNeedHardItemList() : needBlock.getNeedItemList();
            }
        }
    }

    public static float getProgress(int maxTime) {
        return Math.min(1.0f, (float)renderTick / (float)maxTime);
    }
}

