/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init;

import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.registries.DeferredRegister;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ItemInit;

public class TabInit {
    public static final ResourceKey<CreativeModeTab> SMTAB_KEY = TabInit.createKey("0.sweetmagic_tab");
    public static final ResourceKey<CreativeModeTab> SMMAGICTAB_KEY = TabInit.createKey("1.sweetmagic_magic_tab");
    public static final ResourceKey<CreativeModeTab> SMFOODTAB_KEY = TabInit.createKey("2.sweetmagic_food_tab");
    public static final DeferredRegister<CreativeModeTab> REGISTRY = DeferredRegister.create((ResourceLocation)Registries.f_279569_.m_135782_(), (String)"sweetmagic");
    public static final CreativeModeTab smTab = TabInit.register("0.sweetmagic_tab", () -> new ItemStack((ItemLike)BlockInit.antique_brick_0));
    public static final CreativeModeTab smMagicTab = TabInit.register("1.sweetmagic_magic_tab", () -> new ItemStack((ItemLike)ItemInit.aether_wand));
    public static final CreativeModeTab smFoodTab = TabInit.register("2.sweetmagic_food_tab", () -> new ItemStack((ItemLike)ItemInit.strawberry));

    public static CreativeModeTab register(String name, Supplier<ItemStack> stack) {
        CreativeModeTab tab = CreativeModeTab.builder().m_257737_(stack).m_257941_((Component)Component.m_237115_((String)("itemGroup." + name))).m_257652_();
        REGISTRY.register(name, () -> tab);
        return tab;
    }

    private static ResourceKey<CreativeModeTab> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)SweetMagicCore.getSRC(name));
    }

    public static void registerTabItems(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == SMTAB_KEY) {
            BlockInit.blockMap.keySet().stream().filter(i -> i.tab() == smTab).forEach(i -> event.m_246326_((ItemLike)i.block()));
            ItemInit.itemMap.keySet().stream().filter(i -> i.tab() == smTab).forEach(i -> event.m_246326_((ItemLike)i.item()));
        } else if (event.getTabKey() == SMMAGICTAB_KEY) {
            BlockInit.blockMap.keySet().stream().filter(i -> i.tab() == smMagicTab).forEach(i -> event.m_246326_((ItemLike)i.block()));
            ItemInit.itemMap.keySet().stream().filter(i -> i.tab() == smMagicTab).forEach(i -> event.m_246326_((ItemLike)i.item()));
        } else if (event.getTabKey() == SMFOODTAB_KEY) {
            BlockInit.blockMap.keySet().stream().filter(i -> i.tab() == smFoodTab).forEach(i -> event.m_246326_((ItemLike)i.block()));
            ItemInit.itemMap.keySet().stream().filter(i -> i.tab() == smFoodTab).forEach(i -> event.m_246326_((ItemLike)i.item()));
        } else if (event.getTabKey() == CreativeModeTabs.f_256731_) {
            EntityInit.eggList.forEach(i -> event.m_246326_((ItemLike)i));
        }
    }
}

