/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.crop;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.config.SMConfig;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.block.base.BaseSMBlock;
import sweetmagic.init.item.sm.SMSickle;

public class SweetCrops_STAGE3
extends BushBlock
implements ISMCrop,
BonemealableBlock {
    private int chance;
    private final int data;
    private final boolean isFarm;
    private static final VoxelShape[] CROP_VEXE = new VoxelShape[]{Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)1.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)5.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)7.0, (double)14.4), Block.m_49796_((double)1.6, (double)0.0, (double)1.6, (double)14.4, (double)10.0, (double)14.4)};

    public SweetCrops_STAGE3(String name, int data, int chance, boolean isFarm) {
        super(BaseSMBlock.setProSol(SoundType.f_56740_, 0.0f, 8192.0f, (Boolean)SMConfig.glowFlowerluminescen.get() != false && data == 5 ? 15 : 0).m_60910_().m_60977_());
        this.data = data;
        this.chance = chance;
        this.isFarm = isFarm;
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(0)));
        BlockInit.BlockInfo.create((Block)this, null, name);
    }

    @Override
    public ItemLike getCrop() {
        return switch (this.data) {
            case 1 -> ItemInit.fire_nasturtium_petal;
            case 2 -> ItemInit.dm_flower;
            case 3 -> ItemInit.clero_petal;
            case 4 -> ItemInit.cotton;
            case 5 -> Items.f_42525_;
            case 6 -> ItemInit.sweetpotato;
            case 7 -> ItemInit.strawberry;
            case 8 -> ItemInit.cabbage;
            case 9 -> ItemInit.lettuce;
            case 10 -> ItemInit.spinach;
            case 11 -> ItemInit.paper_mint;
            case 12 -> ItemInit.greenpepper;
            case 13 -> ItemInit.j_radish;
            default -> ItemInit.sugarbell;
        };
    }

    @Override
    public ItemLike getSeed() {
        return switch (this.data) {
            case 1 -> ItemInit.fire_nasturtium_seed;
            case 2 -> ItemInit.drizzly_mysotis_seed;
            case 3 -> ItemInit.clerodendrum_seed;
            case 4 -> ItemInit.cotton_seed;
            case 5 -> ItemInit.glowflower_seed;
            case 6 -> ItemInit.sweetpotato;
            case 7 -> ItemInit.strawberry;
            case 8 -> ItemInit.cabbage_seed;
            case 9 -> ItemInit.lettuce_seed;
            case 10 -> ItemInit.spinach_seed;
            case 11 -> ItemInit.paper_mint_seed;
            case 12 -> ItemInit.greenpepper_seed;
            case 13 -> ItemInit.j_radish_seed;
            default -> ItemInit.sugarbell_seed;
        };
    }

    @Override
    public int getMaxBlockState() {
        return 3;
    }

    @Override
    public IntegerProperty getSMMaxAge() {
        return ISMCrop.AGE3;
    }

    @Override
    public void setGlowChance(int chance) {
        this.chance = chance;
    }

    @Override
    public int getGlowChange() {
        return this.chance;
    }

    @Override
    public int RCSetState() {
        return 1;
    }

    @Override
    public BlockState getDefault() {
        return this.m_49966_();
    }

    @Override
    public int getDropValue(RandomSource rand, int fortune) {
        return Math.max(1, rand.m_188503_(3) + 1);
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return new ItemStack(this.getCrop());
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return CROP_VEXE[this.getNowState(state)];
    }

    public boolean m_6724_(BlockState state) {
        return !this.isMaxAge(state);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!this.isMaxAge(state) && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (boolean)this.isGlowChange(rand))) {
            BlockState glowState = (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.getNowState(state) + 1));
            world.m_7731_(pos, glowState, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)glowState));
            ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof SMSickle) {
            SMSickle sickle = (SMSickle)item;
            sickle.getPickPlant(world, player, pos, stack);
            return InteractionResult.SUCCESS;
        }
        if (!this.isMaxAge(state)) {
            return stack.m_150930_(Items.f_42499_) ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        this.onRicghtClick(world, player, state, pos, stack);
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    @Override
    public void onRicghtClick(Level world, Player player, BlockState state, BlockPos pos, ItemStack stack) {
        RandomSource rand = world.m_213780_();
        ItemEntity drop = this.getDropItem(world, player, stack, this.getCrop(), this.getDropValue(rand, 0));
        world.m_7967_((Entity)drop);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.RCSetState())), 2);
        this.playCropSound(world, rand, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{this.getSMMaxAge()});
    }

    public boolean m_7370_(LevelReader get, BlockPos pos, BlockState state, boolean falg) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(Level world, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        this.growCrops((Level)world, pos, state);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder build) {
        return this.getDropList(state, build);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos underPos = pos.m_7495_();
        return this.m_6266_(world.m_8055_(underPos), (BlockGetter)world, underPos);
    }

    protected boolean m_6266_(BlockState state, BlockGetter get, BlockPos pos) {
        return this.checkPlace(state, get, pos);
    }

    @Override
    public boolean isOnlyFarm() {
        return this.isFarm;
    }

    public PlantType getPlantType(BlockGetter get, BlockPos pos) {
        return PlantType.CROP;
    }
}

