/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidUtil;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseMFBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileAquariumPot;

public class AquariumPot
extends BaseMFBlock {
    public final int data;
    public final int tier;
    private final Block block;
    private static final VoxelShape AABB = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public AquariumPot(String name, Block block, int data, int tier) {
        super(name);
        this.data = data;
        this.tier = tier;
        this.block = block;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return AABB;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        TileAbstractSM tile = this.getTile(world, pos);
        if (this.data == 10 && FluidUtil.getFluidHandler((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND)).isPresent()) {
            FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)player.m_7655_(), (Level)world, (BlockPos)pos, null);
            tile.sendPKT();
        } else {
            this.openGUI(world, pos, player, tile);
        }
        return true;
    }

    public int getData() {
        return this.data;
    }

    @Override
    public int getMaxMF() {
        return 500000;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    public ItemStack getStack() {
        return new ItemStack((ItemLike)this.block);
    }

    @Override
    public void addTip(List<Component> toolTip, ItemStack stack, CompoundTag tags) {
        switch (this.data) {
            case 0: {
                toolTip.add((Component)this.getTipArray(new Object[]{this.getText("drizzly_mysotis_pot"), GREEN}));
                toolTip.add((Component)this.getTipArray(new Object[]{this.getText(this.name + "_thunder"), GREEN}));
                break;
            }
            case 3: {
                toolTip.add((Component)this.getTipArray(new Object[]{this.getText(this.name), GREEN}));
                toolTip.add((Component)this.getTipArray(new Object[]{this.getText(this.name + "_level"), GREEN}));
                break;
            }
            case 4: {
                toolTip.add((Component)this.getTipArray(new Object[]{this.getText(this.name), GREEN}));
                toolTip.add((Component)this.getTipArray(new Object[]{this.getText(this.name + "_mf"), GREEN}));
                break;
            }
            case 5: {
                toolTip.add((Component)this.getTipArray(new Object[]{this.getText("solid_star_pot"), GREEN}));
                break;
            }
            case 6: {
                toolTip.add((Component)this.getTipArray(new Object[]{this.getText("zinnia_pot"), GREEN}));
                break;
            }
            case 10: {
                toolTip.add((Component)this.getTipArray(new Object[]{this.getText(this.name), GREEN}));
                toolTip.add((Component)this.getTipArray(new Object[]{this.getText(this.name + "_lava"), GREEN}));
                break;
            }
            default: {
                toolTip.add((Component)this.getTipArray(new Object[]{this.getText(this.name), GREEN}));
            }
        }
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("aquarium_pot", new Object[]{this.block.m_49954_().getString()}), GOLD}));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileAquariumPot(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, TileInit.aquariumpot);
    }
}

