/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemStackHandler;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseMFBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMFChanger;
import sweetmagic.init.tile.sm.TileMFChangerAdvanced;
import sweetmagic.init.tile.sm.TileMFChangerMaster;

public class MFChager
extends BaseMFBlock {
    private final int data;
    private static final VoxelShape AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public MFChager(String name, int data) {
        super(name);
        this.data = data;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return AABB;
    }

    @Override
    public int getMaxMF() {
        return switch (this.data) {
            case 1 -> 800000;
            case 2 -> 4000000;
            default -> 30000;
        };
    }

    @Override
    public int getTier() {
        return this.data + 1;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return false;
        }
        this.openGUI(world, pos, player, this.getTile(world, pos));
        return true;
    }

    @Override
    public boolean keepTileInfo() {
        return true;
    }

    @Override
    public ItemStack inheritingNBT(ItemStack oldStack, ItemStack newStack) {
        if (oldStack.m_41784_().m_128441_("BlockEntityTag")) {
            CompoundTag tags = oldStack.m_41737_("BlockEntityTag");
            int oldSlotSize = this.data == 0 ? 3 : 5;
            ItemStackHandler oldInputInv = new ItemStackHandler(oldSlotSize);
            oldInputInv.deserializeNBT(tags.m_128469_("inputInv"));
            int newSlotSize = this.data == 0 ? 5 : 10;
            ItemStackHandler newInputInv = new ItemStackHandler(newSlotSize);
            for (int i = 0; i < oldSlotSize; ++i) {
                newInputInv.setStackInSlot(i, oldInputInv.getStackInSlot(i));
            }
            tags.m_128473_("inputInv");
            tags.m_128365_("inputInv", (Tag)newInputInv.serializeNBT());
            CompoundTag newTags = new CompoundTag();
            newTags.m_128365_("BlockEntityTag", (Tag)tags);
            newTags.m_128405_("mf", oldStack.m_41783_().m_128451_("mf"));
            newStack.m_41751_(newTags);
        }
        return newStack;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.data) {
            case 1 -> new TileMFChangerAdvanced(pos, state);
            case 2 -> new TileMFChangerMaster(pos, state);
            default -> new TileMFChanger(pos, state);
        };
    }

    @Override
    public BlockEntityType<? extends TileAbstractSM> getTileType() {
        return switch (this.data) {
            case 1 -> TileInit.changerAdavance;
            case 2 -> TileInit.changerMaster;
            default -> TileInit.changer;
        };
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, this.getTileType());
    }

    @Override
    public boolean isRSStop() {
        return true;
    }

    @Override
    public void addTip(List<Component> toolTip, ItemStack stack, CompoundTag tags) {
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("mfchanger"), GREEN}));
    }
}

