/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.magic;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.init.ItemInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseMFBlock;
import sweetmagic.init.tile.sm.TileMFFisher;

public class MFFisher
extends BaseMFBlock {
    private final int data;
    private static final VoxelShape AABB = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);

    public MFFisher(String name, int data) {
        super(name);
        this.data = data;
    }

    @Override
    public int getMaxMF() {
        return switch (this.data) {
            case 3 -> 40000;
            case 4 -> 400000;
            default -> 10000;
        };
    }

    @Override
    public int getTier() {
        return switch (this.data) {
            case 4 -> 2;
            default -> 1;
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext col) {
        return this.data == 3 || this.data == 4 ? AABB : super.m_5940_(state, get, pos, col);
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        this.openGUI(world, pos, player, this.getTile(world, pos));
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileMFFisher(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, TileInit.mfFisher);
    }

    public int getData() {
        return this.data;
    }

    @Override
    public void addTip(List<Component> toolTip, ItemStack stack, CompoundTag tags) {
        if (this.data == 3 || this.data == 4) {
            toolTip.add((Component)this.getText("aehter_furnace").m_130940_(GREEN));
            toolTip.add(this.data == 3 ? new ItemStack((ItemLike)ItemInit.aether_crystal).m_41611_() : new ItemStack((ItemLike)ItemInit.divine_crystal).m_41611_());
            return;
        }
        toolTip.add((Component)this.getText(this.name).m_130940_(GREEN));
        if (this.data == 2 || this.data == 6) {
            toolTip.add((Component)this.getText("mf_squeezer_mf").m_130940_(GREEN));
        }
    }

    @Override
    public boolean isRSStop() {
        return true;
    }
}

