/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileAlternativeTank;
import sweetmagic.init.tile.sm.TileCosmosLightTank;

public class AlternativeTank
extends BaseFaceBlock
implements EntityBlock {
    private final int data;

    public AlternativeTank(String name, int data) {
        super(name, AlternativeTank.setPro(SoundType.f_56743_, 0.5f, 8192.0f));
        this.data = data;
        BlockInit.BlockInfo.create(this, TabInit.smTab, name);
    }

    @Override
    protected boolean isDrop() {
        return false;
    }

    @Override
    public boolean isKeepTile() {
        return true;
    }

    public int getMaxFluidValue() {
        return switch (this.data) {
            case 1 -> 25600000;
            default -> 256000;
        };
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        TileAlternativeTank tile = (TileAlternativeTank)this.getTile(world, pos);
        if (FluidUtil.getFluidHandler((ItemStack)player.m_21120_(InteractionHand.MAIN_HAND)).isPresent()) {
            FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)player.m_7655_(), (Level)world, (BlockPos)pos, null);
            tile.sendPKT();
        } else {
            this.openGUI(world, pos, player, tile);
        }
        return true;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, (BlockEntityType<? extends TileAbstractSM>)(this.data == 1 ? TileInit.cosmosLightTank : TileInit.alternativeTank));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return switch (this.data) {
            case 1 -> new TileCosmosLightTank(pos, state);
            default -> new TileAlternativeTank(pos, state);
        };
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter get, List<Component> toolTip, TooltipFlag flag) {
        toolTip.add((Component)this.tierTip(this.data + 1));
        toolTip.add((Component)this.getText("keep_tank").m_130940_(GREEN));
        toolTip.add((Component)this.getTipArray(new Object[]{this.getText("max_value"), ": ", this.getLabel(String.format("%,.1f", Float.valueOf((float)this.getMaxFluidValue() * 0.001f)) + "B", GREEN)}));
        if (!stack.m_41784_().m_128441_("BlockEntityTag")) {
            return;
        }
        CompoundTag tags = stack.m_41737_("BlockEntityTag");
        if (tags == null) {
            return;
        }
        FluidStack fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)tags.m_128469_("fluid"));
        toolTip.add((Component)this.getTipArray(new Object[]{fluid.getDisplayName().getString(), ": ", this.getLabel(String.format("%,.1f", Float.valueOf((float)fluid.getAmount() * 0.001f)) + "B", GREEN)}));
    }
}

