/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import sweetmagic.api.iblock.IFoodExpBlock;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.block.sm.CounterTableSink;
import sweetmagic.init.block.sm.Oven;
import sweetmagic.init.block.sm.Stove;
import sweetmagic.init.block.sm.WoodChest;

public class CounterTable
extends BaseFaceBlock
implements IFoodExpBlock {
    public static final IntegerProperty CENTER = IntegerProperty.m_61631_((String)"center", (int)0, (int)4);

    public CounterTable(String name) {
        super(name, CounterTable.setPro(SoundType.f_56742_, 0.5f, 8192.0f));
        this.m_49959_((BlockState)this.setState().m_61124_((Property)CENTER, (Comparable)Integer.valueOf(0)));
        BlockInit.BlockInfo.create(this, TabInit.smTab, name);
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext con) {
        return this.setVertical(super.m_5573_(con), (LevelAccessor)con.m_43725_(), con.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction face, BlockState state2, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        return this.setVertical(super.m_7417_(state, face, state2, world, pos1, pos2), world, pos1);
    }

    public BlockState setVertical(BlockState state, LevelAccessor world, BlockPos pos) {
        return (BlockState)state.m_61124_((Property)CENTER, (Comparable)Integer.valueOf(this.checkCenter(world, state, pos)));
    }

    public int checkCenter(LevelAccessor world, BlockState state, BlockPos pos) {
        Direction face = (Direction)state.m_61143_((Property)FACING);
        BlockState north = world.m_8055_(pos.m_122012_());
        BlockState south = world.m_8055_(pos.m_122019_());
        BlockState west = world.m_8055_(pos.m_122024_());
        BlockState east = world.m_8055_(pos.m_122029_());
        switch (face) {
            case NORTH: {
                return this.getConnect(north, south, face);
            }
            case SOUTH: {
                return this.getConnect(south, north, face);
            }
            case WEST: {
                return this.getConnect(west, east, face);
            }
            case EAST: {
                return this.getConnect(east, west, face);
            }
        }
        return 0;
    }

    public int getConnect(BlockState block1, BlockState block2, Direction face) {
        if (this.canConnectBlock(block2, face.m_122427_())) {
            return 3;
        }
        if (this.canConnectBlock(block2, face.m_122428_())) {
            return 4;
        }
        if (this.canConnectBlock(block1, face.m_122427_())) {
            return 1;
        }
        if (this.canConnectBlock(block1, face.m_122428_())) {
            return 2;
        }
        return 0;
    }

    public boolean canConnectBlock(BlockState state, Direction face) {
        return this.isCounter(state) && face == state.m_61143_((Property)FACING);
    }

    public boolean isCounter(BlockState state) {
        Block block = state.m_60734_();
        return block instanceof CounterTable || block instanceof CounterTableSink || block instanceof Oven || block instanceof Stove || block instanceof WoodChest;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{CENTER, FACING});
    }
}

