/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import sweetmagic.api.iblock.IFoodExpBlock;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.item.sm.SMBucket;
import sweetmagic.init.tile.sm.TileSink;

public class CounterTableSink
extends BaseFaceBlock
implements IFoodExpBlock,
EntityBlock {
    public CounterTableSink(String name) {
        super(name, CounterTableSink.setPro(SoundType.f_56736_, 0.5f, 8192.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        BlockInit.BlockInfo.create(this, TabInit.smTab, name);
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        this.playerSound(world, pos, SoundEvents.f_11781_, 0.2f, world.m_213780_().m_188501_() * 0.1f + 1.4f);
        if (stack.m_150930_(Items.f_42446_)) {
            stack.m_41774_(1);
            this.spawnItemList(world, player.m_20183_(), Arrays.asList(new ItemStack((ItemLike)Items.f_42447_)));
        } else {
            Item item = stack.m_41720_();
            if (item instanceof SMBucket) {
                SMBucket bucket = (SMBucket)item;
                this.fillBucket(world, player, stack, bucket);
            } else {
                this.spawnItemList(world, player.m_20183_(), Arrays.asList(new ItemStack((ItemLike)ItemInit.watercup, 16)));
            }
        }
        return true;
    }

    public void fillBucket(Level world, Player player, ItemStack stack, SMBucket bucket) {
        FluidStack fluid = new FluidStack((Fluid)Fluids.f_76193_, 1000);
        if (stack.m_150930_(ItemInit.alt_bucket)) {
            stack.m_41774_(1);
            ItemStack newBucket = new ItemStack((ItemLike)ItemInit.alt_bucket_water);
            fluid = new FluidStack((Fluid)Fluids.f_76193_, 1000);
            bucket.saveFluid(newBucket, fluid);
            this.spawnItemList(world, player.m_20183_(), Arrays.asList(newBucket));
        } else {
            fluid = bucket.getFluidStack(stack);
            int amount = 1000;
            if (fluid.isEmpty()) {
                fluid = new FluidStack((Fluid)Fluids.f_76193_, amount);
            } else {
                fluid.grow(amount);
            }
        }
        bucket.saveFluid(stack, fluid);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, TileInit.sink);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileSink(pos, state);
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("couter_table_sink_bucket").m_130940_(GOLD));
        toolTip.add((Component)this.getText("couter_table_sink").m_130940_(GOLD));
    }
}

