/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.block.base.BaseSMBlock;
import sweetmagic.init.item.sm.SMSickle;

public class FruitLeaves
extends BushBlock
implements ISMCrop,
BonemealableBlock {
    private final int data;
    private int chance;
    public static final BooleanProperty NOGLOW = BooleanProperty.m_61465_((String)"noglow");
    private static final BlockBehaviour.StatePredicate never = (a, b, c) -> false;
    private static final BlockBehaviour.StateArgumentPredicate<EntityType<?>> checkMob = (s, g, p, e) -> e == EntityType.f_20505_ || e == EntityType.f_20508_;

    public FruitLeaves(String name, int data, int chance) {
        super(BaseSMBlock.setPro(SoundType.f_56740_, 0.0f, 8192.0f, data == 5 ? 15 : 0).m_60977_().m_60922_(checkMob).m_60960_(never).m_60971_(never));
        this.data = data;
        this.chance = chance;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(0))).m_61124_((Property)NOGLOW, (Comparable)Boolean.valueOf(false)));
        BlockInit.BlockInfo.create((Block)this, TabInit.smTab, name);
    }

    @Override
    public ItemLike getCrop() {
        return switch (this.data) {
            case 0 -> ItemInit.lemon;
            case 1 -> ItemInit.orange;
            case 2 -> ItemInit.estor_apple;
            case 3 -> ItemInit.peach;
            default -> ItemInit.lemon;
        };
    }

    @Override
    public ItemLike getSeed() {
        return switch (this.data) {
            case 0 -> BlockInit.lemon_sapling;
            case 1 -> BlockInit.orange_sapling;
            case 2 -> BlockInit.estor_sapling;
            case 3 -> BlockInit.peach_sapling;
            default -> BlockInit.lemon_sapling;
        };
    }

    @Override
    public int getMaxBlockState() {
        return 2;
    }

    @Override
    public IntegerProperty getSMMaxAge() {
        return ISMCrop.AGE2;
    }

    @Override
    public void setGlowChance(int chance) {
        this.chance = chance;
    }

    @Override
    public int getGlowChange() {
        return this.chance;
    }

    @Override
    public int RCSetState() {
        return 0;
    }

    @Override
    public BlockState getDefault() {
        return this.m_49966_();
    }

    @Override
    public int getDropValue(RandomSource rand, int fortune) {
        return Math.max(1, rand.m_188503_(2) + 1);
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return new ItemStack(this.getCrop());
    }

    public boolean m_6724_(BlockState state) {
        return !this.isMaxAge(state);
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!this.isMaxAge(state) && !((Boolean)state.m_61143_((Property)NOGLOW)).booleanValue() && ForgeHooks.onCropsGrowPre((Level)world, (BlockPos)pos, (BlockState)state, (boolean)this.isGlowChange(rand))) {
            int nowAge = this.getNowState(state);
            BlockState glowState = (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(nowAge + 1));
            world.m_7731_(pos, glowState, 2);
            world.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)glowState));
            ForgeHooks.onCropsGrowPost((Level)world, (BlockPos)pos, (BlockState)state);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof SMSickle) {
            SMSickle sickle = (SMSickle)item;
            sickle.getPickPlant(world, player, pos, stack);
            return InteractionResult.SUCCESS;
        }
        if (!this.isMaxAge(state)) {
            if (stack.m_150930_(Items.f_42499_)) {
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS;
        }
        this.onRicghtClick(world, player, state, pos, stack);
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    @Override
    public void onRicghtClick(Level world, Player player, BlockState state, BlockPos pos, ItemStack stack) {
        RandomSource rand = world.m_213780_();
        ItemEntity drop = this.getDropItem(world, player, stack, this.getCrop(), this.getDropValue(rand, 0));
        world.m_7967_((Entity)drop);
        world.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getSMMaxAge(), (Comparable)Integer.valueOf(this.RCSetState())), 2);
        this.playCropSound(world, rand, pos);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> bui) {
        bui.m_61104_(new Property[]{this.getSMMaxAge(), NOGLOW});
    }

    public boolean m_7370_(LevelReader get, BlockPos pos, BlockState state, boolean falg) {
        return !this.isMaxAge(state);
    }

    public boolean m_214167_(Level world, RandomSource rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel world, RandomSource rand, BlockPos pos, BlockState state) {
        this.growCrops((Level)world, pos, state);
    }

    @Override
    public int getBonemealAgeIncrease(Level world) {
        return Mth.m_216271_((RandomSource)world.m_213780_(), (int)0, (int)1);
    }

    public ItemStack getSilkDrop() {
        return new ItemStack((ItemLike)this);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder build) {
        ServerLevel world = build.m_287258_();
        RandomSource rand = world.m_213780_();
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack stack = (ItemStack)build.m_287159_(LootContextParams.f_81463_);
        if (!stack.m_41619_() && (stack.getEnchantmentLevel(Enchantments.f_44985_) > 0 || stack.m_41720_() instanceof ShearsItem)) {
            stackList.add(this.getSilkDrop());
            return stackList;
        }
        int level = !stack.m_41619_() ? stack.getEnchantmentLevel(Enchantments.f_44987_) : 0;
        float chance = 0.1f + 0.1f * (float)level;
        if (chance >= rand.m_188501_()) {
            stackList.add(new ItemStack(this.getSeed()));
        }
        stackList.addAll(this.getDropList(state, build));
        return stackList;
    }

    @Override
    public List<ItemStack> getDropList(BlockState state, LootParams.Builder build) {
        ArrayList stackList = Lists.newArrayList();
        RandomSource rand = build.m_287258_().m_213780_();
        if (this.isMaxAge(state)) {
            stackList.add(new ItemStack(this.getCrop(), rand.m_188503_(this.getMaxBlockState()) + 1));
        }
        return stackList;
    }

    public boolean m_7898_(BlockState state, LevelReader render, BlockPos pos) {
        BlockPos underpos = pos.m_7495_();
        return this.m_6266_(render.m_8055_(underpos), (BlockGetter)render, underpos);
    }

    protected boolean m_6266_(BlockState state, BlockGetter get, BlockPos pos) {
        return true;
    }
}

