/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseFaceBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMagiaStorage;
import sweetmagic.util.RenderUtil;

public class MagiaStorage
extends BaseFaceBlock
implements EntityBlock {
    private final int data;
    private static final VoxelShape AABB = Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public MagiaStorage(String name, int data) {
        super(name, MagiaStorage.setPro(SoundType.f_56744_, 0.5f, 8192.0f));
        this.m_49959_(this.setState());
        this.data = data;
        BlockInit.BlockInfo.create(this, TabInit.smTab, name);
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        TileAbstractSM tile = this.getTile(world, pos);
        tile.sendPKT();
        this.openGUI(world, pos, player, tile);
        this.playerSound(world, pos, SoundInit.STORAGE, 0.125f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return AABB;
    }

    @Override
    protected boolean isDrop() {
        return false;
    }

    @Override
    public boolean isKeepTile() {
        return true;
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("sm_chest").m_130940_(GREEN));
        toolTip.add((Component)this.getText("magia_storage", new Object[]{this.format(this.getMaxStackSize())}).m_130940_(GREEN));
        super.addBlockTip(toolTip);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileMagiaStorage(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, TileInit.magiaStorage);
    }

    public int getMaxStackSize() {
        return switch (this.getData()) {
            case 1 -> 1280;
            case 2 -> 5120;
            case 3 -> 25600;
            case 4 -> Integer.MAX_VALUE;
            default -> 256;
        };
    }

    public int getData() {
        return this.data;
    }

    @Override
    public float getEnchantPower() {
        return this.getData() + 1;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        ArrayList<RenderUtil.RGBColor> rgbList = new ArrayList<RenderUtil.RGBColor>();
        switch (this.getData()) {
            case 4: {
                rgbList.add(new RenderUtil.RGBColor(255, 65, 91));
            }
            case 3: {
                rgbList.add(new RenderUtil.RGBColor(116, 185, 255));
            }
            case 2: {
                rgbList.add(new RenderUtil.RGBColor(254, 204, 40));
            }
            case 1: {
                rgbList.add(new RenderUtil.RGBColor(0, 255, 255));
            }
            case 0: {
                rgbList.add(new RenderUtil.RGBColor(0, 128, 255));
            }
        }
        SimpleParticleType par = ParticleInit.STORAGE;
        for (RenderUtil.RGBColor rgb : rgbList) {
            float randX = (rand.m_188501_() - rand.m_188501_()) * 0.1f;
            float randY = (rand.m_188501_() - rand.m_188501_()) * 0.1f;
            float randZ = (rand.m_188501_() - rand.m_188501_()) * 0.1f;
            float x = (float)pos.m_123341_() + 0.5f + randX;
            float y = (float)pos.m_123342_() + 0.5f + randY;
            float z = (float)pos.m_123343_() + 0.5f + randZ;
            world.m_7106_((ParticleOptions)par, (double)x, (double)y, (double)z, (double)rgb.red(), (double)rgb.green(), (double)rgb.blue());
        }
    }
}

