/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import sweetmagic.api.iblock.ISMCookBlock;
import sweetmagic.api.iblock.ISMCraftBlock;
import sweetmagic.init.TabInit;
import sweetmagic.init.TileInit;
import sweetmagic.init.block.base.BaseCookBlock;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMill;
import sweetmagic.recipe.base.AbstractRecipe;
import sweetmagic.recipe.mill.MillRecipe;
import sweetmagic.util.ItemHelper;

public class Mill
extends BaseCookBlock
implements ISMCraftBlock,
ISMCookBlock {
    private final int data;
    private static final VoxelShape AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    private static final VoxelShape MIXER = Block.m_49796_((double)4.5, (double)0.0, (double)4.5, (double)11.5, (double)15.5, (double)11.5);

    public Mill(String name) {
        super(name);
        this.data = 0;
    }

    public Mill(String name, int data) {
        super(name, TabInit.smTab);
        this.data = data;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return switch (this.data) {
            case 1 -> MIXER;
            default -> AABB;
        };
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        BlockState state = world.m_8055_(pos);
        int cookState = this.getState(state);
        if (cookState == 0) {
            this.getRecipeMill(world, pos, player, stack);
        } else if (cookState == 2) {
            TileMill tile = (TileMill)this.getTile(TileMill::new, world, pos);
            this.spawnItemList(world, player.m_20183_(), tile.getOutPutList());
            this.setState(world, pos, 0);
            tile.outPutClear();
        }
        return true;
    }

    public void getRecipeMill(Level world, BlockPos pos, Player player, ItemStack stack) {
        List<ItemStack> stackList = Arrays.asList(stack);
        Optional<MillRecipe> recipe = MillRecipe.getRecipe(world, stackList);
        if (recipe.isEmpty()) {
            return;
        }
        List<ItemStack> requestList = recipe.get().getRequestList();
        ItemStack hasndStack = stackList.get(0);
        int requestAmount = requestList.get(0).m_41613_();
        int amount = hasndStack.m_41613_() / requestAmount;
        int shrinkAmount = requestAmount * amount;
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(shrinkAmount);
        stack.m_41774_(shrinkAmount);
        TileMill tile = (TileMill)this.getTile(TileMill::new, world, pos);
        ItemHelper.insertStack(tile.getHand(), copy, false);
        tile.craftStart();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileMill(pos, state);
    }

    @Override
    public BlockEntityType<? extends TileAbstractSM> getTileType() {
        return TileInit.mill;
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return this.createMailBoxTicker(world, type, this.getTileType());
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("mill").m_130940_(GREEN));
        if (this.data != 0) {
            toolTip.add((Component)this.getText("mill_use").m_130940_(GOLD));
        }
    }

    @Override
    public boolean notNullRecipe(Level world, List<ItemStack> stackList) {
        return !MillRecipe.getRecipe(world, stackList).isEmpty();
    }

    @Override
    public AbstractRecipe getRecipe(Level world, List<ItemStack> stackList) {
        return MillRecipe.getRecipe(world, stackList).get();
    }

    @Override
    public boolean isView() {
        return false;
    }
}

