/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import sweetmagic.api.util.EnumVertical;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.block.base.BaseModelBlock;

public class ModenLamp
extends BaseModelBlock {
    private final int data;
    private static final VoxelShape AABB = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final EnumProperty<EnumVertical> VERTICAL = EnumProperty.m_61587_((String)"vertical", EnumVertical.class);

    public ModenLamp(String name, int data) {
        super(name, ModenLamp.setPro(SoundType.f_56743_, 0.5f, 8192.0f, 15));
        this.m_49959_((BlockState)this.m_49966_().m_61124_(VERTICAL, (Comparable)((Object)EnumVertical.NOR)));
        this.data = data;
        BlockInit.BlockInfo.create(this, data == 2 ? null : TabInit.smTab, name);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return AABB;
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return true;
    }

    @Override
    public InteractionResult onUse(Level world, BlockPos pos, Player player, InteractionHand hand) {
        BlockItem item;
        Item item2;
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && (item2 = stack.m_41720_()) instanceof BlockItem && (item = (BlockItem)item2).m_40614_() instanceof ModenLamp) {
            this.actionBlock(world, pos, player, stack);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        if (player.m_6144_() && (this.data == 1 || this.data == 2)) {
            Block block = this.data == 1 ? BlockInit.wall_lamp_long : BlockInit.wall_lamp;
            world.m_7731_(pos, (BlockState)block.m_49966_().m_61124_(VERTICAL, (Comparable)((Object)((EnumVertical)((Object)world.m_8055_(pos).m_61143_(VERTICAL))))), 3);
            this.playerSound(world, pos, (SoundEvent)SoundEvents.f_12490_.get(), 0.25f, world.f_46441_.m_188501_() * 0.1f + 1.2f);
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        if (world.m_5776_()) {
            return true;
        }
        Block block = this.getBlock(stack);
        if (block != this) {
            return false;
        }
        for (int i = 1; i < 11; ++i) {
            BlockPos targetPos = pos.m_6625_(i);
            BlockState state = world.m_8055_(targetPos);
            Block targetBlock = state.m_60734_();
            if (!state.m_60795_() && !(targetBlock instanceof ModenLamp)) {
                return false;
            }
            if (!state.m_60795_()) continue;
            world.m_7731_(targetPos, block.m_49966_(), 3);
            this.blockSound(world, block, targetPos, player);
            if (player.m_7500_()) break;
            stack.m_41774_(1);
            break;
        }
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{VERTICAL});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext con) {
        return this.setVertical((LevelAccessor)con.m_43725_(), con.m_8083_());
    }

    public BlockState setVertical(LevelAccessor world, BlockPos pos) {
        boolean bot = this.getBlock(world, pos.m_7495_()) instanceof ModenLamp;
        boolean top = this.getBlock(world, pos.m_7494_()) instanceof ModenLamp;
        return (BlockState)this.m_49966_().m_61124_(VERTICAL, (Comparable)((Object)EnumVertical.getVertical(bot, top)));
    }

    public BlockState m_7417_(BlockState state, Direction face, BlockState state2, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        return this.setVertical(world, pos1);
    }

    @Override
    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder build) {
        if (this.data == 0) {
            return super.m_49635_(state, build);
        }
        return Arrays.asList(new ItemStack((ItemLike)BlockInit.wall_lamp));
    }

    public ItemStack m_7397_(BlockGetter get, BlockPos pos, BlockState state) {
        return this.data == 0 ? new ItemStack((ItemLike)this) : new ItemStack((ItemLike)BlockInit.wall_lamp);
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("is_vertical").m_130940_(GOLD));
        if (this.data == 2 || this.data == 3) {
            toolTip.add((Component)this.getText("shift_change").m_130940_(GREEN));
        }
    }
}

