/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import sweetmagic.init.TabInit;
import sweetmagic.init.block.base.BaseModelBlock;
import sweetmagic.init.block.crop.MagiaFlower;

public class PottingSoil
extends BaseModelBlock {
    private int chance;

    public PottingSoil(String name, int chance) {
        super(name, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50493_).m_60977_(), TabInit.smTab);
        this.chance = chance;
    }

    public void m_213898_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!this.isGlowChange(rand)) {
            return;
        }
        BlockPos upPos = pos.m_7494_();
        BlockState upState = world.m_8055_(upPos);
        Block upBlock = upState.m_60734_();
        if (upBlock instanceof BonemealableBlock) {
            BonemealableBlock crop = (BonemealableBlock)upBlock;
            crop.m_214148_(world, rand, upPos, upState);
        } else if (upBlock instanceof MagiaFlower) {
            MagiaFlower flower = (MagiaFlower)upBlock;
            if (flower.isMaxAge(upState) || !flower.canGlow((Level)world, world.m_46468_() % 24000L < 12000L)) {
                return;
            }
            flower.glowUp((Level)world, upState, upPos);
        }
    }

    public boolean isGlowChange(RandomSource rand) {
        return rand.m_188503_(this.chance) == 0;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction face, IPlantable plant) {
        PlantType plantType = plant.getPlantType(world, pos.m_121945_(face));
        return plantType != PlantType.NETHER && plantType != PlantType.WATER;
    }

    @Override
    public void addBlockTip(List<Component> toolTip) {
        toolTip.add((Component)this.getText("potting_soil").m_130940_(GOLD));
    }
}

