/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.block.sm;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import sweetmagic.init.BlockInit;
import sweetmagic.init.TabInit;
import sweetmagic.init.block.base.BaseModelBlock;
import sweetmagic.init.block.sm.AwningTent;

public class WoodPole
extends BaseModelBlock {
    private static final VoxelShape AABB = Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5);
    public static final IntegerProperty ISTENT = IntegerProperty.m_61631_((String)"istent", (int)0, (int)2);

    public WoodPole(String name, int data) {
        super(name, WoodPole.setPro(data == 1 ? SoundType.f_56743_ : SoundType.f_56736_, 0.35f, 8192.0f));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)ISTENT, (Comparable)Integer.valueOf(0)));
        BlockInit.BlockInfo.create(this, TabInit.smTab, name);
    }

    @Override
    public boolean canRightClick(Player player, ItemStack stack) {
        return !stack.m_41619_();
    }

    @Override
    public boolean actionBlock(Level world, BlockPos pos, Player player, ItemStack stack) {
        BlockItem bItem;
        Item item;
        if (world.m_5776_()) {
            return true;
        }
        if (stack.m_150930_(Items.f_42655_)) {
            LeadItem.m_42829_((Player)player, (Level)world, (BlockPos)pos);
        }
        if ((item = stack.m_41720_()) instanceof BlockItem && this.canSetBlock((bItem = (BlockItem)item).m_40614_())) {
            Block block = bItem.m_40614_();
            for (int i = 1; i < 11; ++i) {
                BlockPos targetPos = pos.m_6630_(i);
                BlockState state = world.m_8055_(targetPos);
                Block targetBlock = state.m_60734_();
                if (!state.m_60795_() && !this.canSetBlock(targetBlock)) {
                    return false;
                }
                if (!state.m_60795_()) continue;
                world.m_7731_(targetPos, this.setVertical(block.m_49966_(), (LevelAccessor)world, targetPos), 3);
                this.blockSound(world, block, targetPos, player);
                if (player.m_7500_()) break;
                stack.m_41774_(1);
                break;
            }
        }
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter get, BlockPos pos, CollisionContext con) {
        return AABB;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext con) {
        return this.setVertical(super.m_5573_(con), (LevelAccessor)con.m_43725_(), con.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction face, BlockState state2, LevelAccessor world, BlockPos pos1, BlockPos pos2) {
        return this.setVertical(super.m_7417_(state, face, state2, world, pos1, pos2), world, pos1);
    }

    public BlockState setVertical(BlockState state, LevelAccessor world, BlockPos pos) {
        BlockState upState = world.m_8055_(pos.m_7494_());
        if (upState.m_60734_() instanceof AwningTent) {
            return (BlockState)state.m_61124_((Property)ISTENT, (Comparable)Integer.valueOf((Integer)upState.m_61143_((Property)AwningTent.CENTER) == 5 ? 1 : 2));
        }
        return state.m_61138_((Property)ISTENT) ? (BlockState)state.m_61124_((Property)ISTENT, (Comparable)Integer.valueOf(0)) : state;
    }

    public boolean canSetBlock(Block block) {
        return block == this || block instanceof AwningTent;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> build) {
        build.m_61104_(new Property[]{ISTENT});
    }
}

