/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.capability.icap;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import sweetmagic.init.capability.BasicCapabilityResolver;
import sweetmagic.init.tile.slot.WrappedItemHandler;

public interface ICapabilityResolver<CAPABILITY>
extends ICapabilityProvider {
    @NotNull
    public Capability<CAPABILITY> getMatchingCapability();

    @NotNull
    public <T> LazyOptional<T> getCapabilityUnchecked(@NotNull Capability<T> var1, @Nullable Direction var2);

    @NotNull
    default public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == this.getMatchingCapability()) {
            return this.getCapabilityUnchecked(cap, side);
        }
        return LazyOptional.empty();
    }

    public void invalidate(@NotNull Capability<?> var1, @Nullable Direction var2);

    public void invalidateAll();

    default public NonNullLazy<IItemHandler> getHandler(IItemHandlerModifiable hand, WrappedItemHandler.WriteMode mode) {
        return () -> new WrappedItemHandler(hand, mode);
    }

    default public NonNullLazy<IItemHandler> getHandlerArray(IItemHandlerModifiable ... hand) {
        return () -> new CombinedInvWrapper(hand);
    }

    default public ICapabilityResolver<IItemHandler> getBasicResolver(NonNullSupplier<IItemHandler> sup) {
        return BasicCapabilityResolver.getBasicItemHandlerResolver(sup);
    }
}

