/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.animal;

import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.entity.monster.AbstractSMMob;
import sweetmagic.init.item.magic.EvilArrowItem;
import sweetmagic.init.item.sm.SMFood;
import sweetmagic.init.item.sm.SummonerWand;
import sweetmagic.util.PlayerHelper;
import sweetmagic.util.SMDamage;
import sweetmagic.util.WorldHelper;

public abstract class AbstractSummonMob
extends TamableAnimal {
    protected Random rand = new Random();
    private static final EntityDataAccessor<Float> RANGE = ISMMob.setData(AbstractSummonMob.class, ISMMob.FLOAT);
    private static final EntityDataAccessor<Float> HEALTH_ARMOR = ISMMob.setData(AbstractSummonMob.class, ISMMob.FLOAT);
    private static final EntityDataAccessor<Integer> SUMMON_TIME = ISMMob.setData(AbstractSummonMob.class, ISMMob.INT);
    private static final EntityDataAccessor<Integer> WAND_LEVEL = ISMMob.setData(AbstractSummonMob.class, ISMMob.INT);
    private static final EntityDataAccessor<Boolean> IS_SHIT = ISMMob.setData(AbstractSummonMob.class, ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ISALAY = ISMMob.setData(AbstractSummonMob.class, ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ISGOLEM = ISMMob.setData(AbstractSummonMob.class, ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ISFOX = ISMMob.setData(AbstractSummonMob.class, ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ISMASTER = ISMMob.setData(AbstractSummonMob.class, ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ISIFRIT = ISMMob.setData(AbstractSummonMob.class, ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> ISWINDINE = ISMMob.setData(AbstractSummonMob.class, ISMMob.BOOLEAN);

    public AbstractSummonMob(EntityType<? extends AbstractSummonMob> eType, Level world) {
        super(eType, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(SUMMON_TIME, 1200);
        this.define(WAND_LEVEL, 1);
        this.define(RANGE, Float.valueOf(0.0f));
        this.define(HEALTH_ARMOR, Float.valueOf(0.0f));
        this.define(IS_SHIT, false);
        this.define(ISALAY, false);
        this.define(ISGOLEM, false);
        this.define(ISFOX, false);
        this.define(ISMASTER, false);
        this.define(ISIFRIT, false);
        this.define(ISWINDINE, false);
    }

    public <T> T get(EntityDataAccessor<T> value) {
        return (T)this.m_20088_().m_135370_(value);
    }

    public <T> void set(EntityDataAccessor<T> value, T par) {
        this.m_20088_().m_135381_(value, par);
    }

    public <T> void define(EntityDataAccessor<T> value, T par) {
        this.m_20088_().m_135372_(value, par);
    }

    public void setMaxLifeTime(int maxLifeTime) {
        this.set(SUMMON_TIME, maxLifeTime);
    }

    public int getMaxLifeTime() {
        return this.get(SUMMON_TIME);
    }

    public void setWandLevel(int wandLevel) {
        this.set(WAND_LEVEL, wandLevel);
    }

    public int getWandLevel() {
        return this.get(WAND_LEVEL);
    }

    public void setShit(boolean isShit) {
        this.set(IS_SHIT, isShit);
    }

    public boolean getShit() {
        return this.get(IS_SHIT);
    }

    public void setRange(float range) {
        this.set(RANGE, Float.valueOf(range));
    }

    public float getRange() {
        return this.get(RANGE).floatValue();
    }

    public void setHealthArmor(float healthArmor) {
        this.set(HEALTH_ARMOR, Float.valueOf(healthArmor));
    }

    public float getHealthArmor() {
        return this.get(HEALTH_ARMOR).floatValue();
    }

    public void setAlay(boolean alay) {
        this.set(ISALAY, alay);
    }

    public boolean getAlay() {
        return this.get(ISALAY);
    }

    public void setGolem(boolean golem) {
        this.set(ISGOLEM, golem);
    }

    public boolean getGolem() {
        return this.get(ISGOLEM);
    }

    public void setFox(boolean fox) {
        this.set(ISFOX, fox);
    }

    public boolean getFox() {
        return this.get(ISFOX);
    }

    public void setMaster(boolean master) {
        this.set(ISMASTER, master);
    }

    public boolean getMaster() {
        return this.get(ISMASTER);
    }

    public void setIfrit(boolean ifrit) {
        this.set(ISIFRIT, ifrit);
    }

    public boolean getIfrit() {
        return this.get(ISIFRIT);
    }

    public void setWindine(boolean windine) {
        this.set(ISWINDINE, windine);
    }

    public boolean getWindine() {
        return this.get(ISWINDINE);
    }

    public boolean canAttack() {
        return false;
    }

    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("summonTime", this.getMaxLifeTime());
        tags.m_128405_("wandLevel", this.getWandLevel());
        tags.m_128405_("wandLevel", this.getWandLevel());
        tags.m_128350_("range", this.getRange());
        tags.m_128350_("healthArmor", this.getHealthArmor());
        tags.m_128379_("isShit", this.getShit());
        tags.m_128379_("isAlay", this.getAlay());
        tags.m_128379_("isGolem", this.getGolem());
        tags.m_128379_("isFox", this.getFox());
        tags.m_128379_("isMaster", this.getMaster());
        tags.m_128379_("isIfrit", this.getIfrit());
        tags.m_128379_("isWindine", this.getWindine());
    }

    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setMaxLifeTime(tags.m_128451_("summonTime"));
        this.setWandLevel(tags.m_128451_("wandLevel"));
        this.setRange(tags.m_128457_("range"));
        this.setHealthArmor(tags.m_128457_("healthArmor"));
        this.setShit(tags.m_128471_("isShit"));
        this.setAlay(tags.m_128471_("isAlay"));
        this.setGolem(tags.m_128471_("isGolem"));
        this.setFox(tags.m_128471_("isFox"));
        this.setMaster(tags.m_128471_("isMaster"));
        this.setIfrit(tags.m_128471_("isIfrit"));
        this.setWindine(tags.m_128471_("isWindine"));
    }

    public boolean m_6469_(DamageSource src, float amount) {
        float armor;
        Entity attacker = src.m_7639_();
        if (attacker == null || !(attacker instanceof Enemy)) {
            return false;
        }
        Entity entity = src.m_7640_();
        if (entity instanceof Warden) {
            Warden entity2 = (Warden)entity;
            entity2.m_6469_(SMDamage.getMagicDamage((Entity)this), amount);
            entity2.f_19802_ = 0;
            amount *= 0.1f;
        }
        if ((armor = this.getHealthArmor()) > 0.0f) {
            this.setHealthArmor(armor - amount);
            amount = 0.0f;
        }
        this.hurtAction(attacker, amount);
        return super.m_6469_(src, Math.min(20.0f, amount));
    }

    public boolean m_7327_(Entity entity) {
        if (this.getFox()) {
            List<LivingEntity> targetList = this.getEntityList(LivingEntity.class, this.isTarget(), 3.5 + (double)this.getRange());
            targetList.forEach(e -> this.attackTarget((Entity)e));
            return true;
        }
        return this.attackTarget(entity);
    }

    public boolean attackTarget(Entity entity) {
        float damage = (float)this.m_21133_(Attributes.f_22281_);
        DamageSource src = SMDamage.getMagicDamage((Entity)this, (Entity)this.m_269323_());
        if (entity instanceof Warden) {
            damage *= 4.0f;
        } else if (entity instanceof EnderMan || entity instanceof Witch) {
            src = SMDamage.getPlayerDamage((Entity)((Player)this.m_269323_()));
        } else if (this.isBoss(entity)) {
            damage *= 0.125f;
        }
        boolean flag = entity.m_6469_(src, damage);
        entity.f_19802_ = 0;
        if (flag) {
            this.m_19970_((LivingEntity)this, entity);
        }
        return flag;
    }

    public void hurtAction(Entity attacker, float amount) {
    }

    public float getDamageAmount(float amount) {
        return Math.min(20.0f, amount);
    }

    public void tamedState(WandInfo info) {
        int level = info.getLevel();
        double rate = Math.max(3.5, 1.0 + (double)(level - 1) * 0.075);
        this.setWandLevel(level);
        this.setState(rate);
    }

    public void setState(double rate) {
        this.setAttribute(Attributes.f_22276_, rate);
        this.setAttribute(Attributes.f_22281_, rate);
        this.setAttribute(Attributes.f_22279_, Math.min(2.0, rate));
        this.setAttribute(Attributes.f_22284_, rate);
        this.m_21153_(this.m_21233_());
    }

    public void setAttribute(Attribute att, double rate) {
        this.m_21051_(att).m_22100_(this.m_21133_(att) * rate);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        InteractionResult result = InteractionResult.PASS;
        return this.m_21830_((LivingEntity)player) ? this.mobClick(result, player, stack) : result;
    }

    public InteractionResult mobClick(InteractionResult result, Player player, ItemStack stack) {
        if (result.m_19077_() || !this.m_21830_((LivingEntity)player)) {
            return result;
        }
        Item item = stack.m_41720_();
        if (item.m_41472_() && item instanceof SMFood && this.m_21223_() < this.m_21233_()) {
            int foodValue = stack.getFoodProperties((LivingEntity)this).m_38744_();
            this.m_5634_(foodValue);
            this.m_146852_(GameEvent.f_157806_, (Entity)this);
            stack.m_41774_(1);
            this.m_5496_(SoundEvents.f_11912_, 0.25f, 0.9f + this.rand.nextFloat(0.2f));
            if (item instanceof SMFood) {
                SMFood food = (SMFood)item;
                food.onFoodEat(this.m_9236_(), (LivingEntity)this, stack);
                this.setMaxLifeTime(this.getMaxLifeTime() + foodValue * 50);
                if (this.isClient()) {
                    this.spawnParticles(this.m_9236_(), this.m_20183_().m_7494_());
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!(item instanceof IWand || item instanceof SummonerWand || item instanceof SummonerWand || item instanceof EvilArrowItem)) {
            if ((item.m_41472_() || !this.m_21205_().m_41619_()) && this.foodAction(player, stack)) {
                return InteractionResult.SUCCESS;
            }
            this.setShitMob(!this.m_21827_());
            return InteractionResult.SUCCESS;
        }
        return result;
    }

    public void setShitMob(boolean isShit) {
        this.m_21839_(isShit);
        this.setShit(this.m_21827_());
        this.m_21566_().m_6849_(0.0, 0.0, 0.0, 0.0);
    }

    public boolean foodAction(Player player, ItemStack stack) {
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        int maxLifeTime = this.getMaxLifeTime();
        if (maxLifeTime <= 0) {
            this.setMaxLifeTime(6000);
        }
        if (this.f_19797_ >= maxLifeTime) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                this.discordParticle(server);
            }
            this.discordAction();
            this.m_146870_();
        }
    }

    public void spawnParticles(Level world, BlockPos pos) {
        SimpleParticleType par = ParticleTypes.f_123750_;
        for (int i = 0; i < 6; ++i) {
            double d0 = this.rand.nextGaussian() * 0.02;
            double d1 = this.rand.nextGaussian() * 0.02;
            double d2 = this.rand.nextGaussian() * 0.02;
            world.m_7106_((ParticleOptions)par, this.m_20185_() + (double)this.getRand(1.5f), this.m_20186_() + (double)this.getRand(1.0f), this.m_20189_() + (double)this.getRand(1.5f), d0, d1, d2);
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null || this.f_19797_ % 20 != 0) {
            return;
        }
        if (!(target instanceof Enemy) || !target.m_6084_()) {
            this.m_6710_(null);
            this.m_21335_(null);
            this.m_6703_(null);
            return;
        }
        List<TamableAnimal> entityList = this.getEntityList(TamableAnimal.class, (T e) -> e.m_5448_() == null && !e.m_21827_(), 32.0);
        entityList.forEach(e -> e.m_6710_(target));
    }

    public void discordParticle(ServerLevel server) {
        this.m_5496_(SoundEvents.f_11775_, 0.4f, 2.0f);
        BlockPos pos = this.m_20183_().m_7494_();
        SimpleParticleType par = ParticleInit.NORMAL;
        for (int i = 0; i < 64; ++i) {
            double d0 = this.getRand(this.rand) * 0.3;
            double d1 = (double)this.rand.nextFloat() * 0.4;
            double d2 = this.getRand(this.rand) * 0.3;
            server.m_8767_((ParticleOptions)par, this.getRandomX(pos), this.m_20187_(), this.getRandomZ(pos), 0, d0, d1 + 0.1, d2, 1.0);
        }
    }

    public void discordAction() {
    }

    public double getRand(Random rand) {
        return rand.nextDouble() - rand.nextDouble();
    }

    public double getRandomX(BlockPos pos) {
        return (double)pos.m_123341_() + this.getRand(this.rand) * 0.25 + 0.5;
    }

    public double getRandomY(BlockPos pos) {
        return (double)pos.m_123342_() + this.getRand(this.rand) * 0.5 - 1.0;
    }

    public double getRandomZ(BlockPos pos) {
        return (double)pos.m_123343_() + this.getRand(this.rand) * 0.25 + 0.5;
    }

    public boolean m_142535_(float par1, float par2, DamageSource src) {
        return false;
    }

    public float getRand() {
        return this.rand.nextFloat();
    }

    public float getRand(float rate) {
        return (this.rand.nextFloat() - this.rand.nextFloat()) * rate;
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, double range) {
        return WorldHelper.getEntityList((Entity)this, enClass, this.getAABB(range));
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Predicate<T> filter, AABB aabb) {
        return WorldHelper.getEntityList((Entity)this, enClass, filter, aabb);
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Predicate<T> filter, double range) {
        return WorldHelper.getEntityList((Entity)this, enClass, filter, this.getAABB(range));
    }

    public AABB getAABB(double range) {
        return this.getAABB(range, range / 2.0, range);
    }

    public AABB getAABB(double x, double y, double z) {
        return this.m_20191_().m_82377_(x, y, z);
    }

    public AABB getAABB(BlockPos pos, double range) {
        return WorldHelper.getAABB(pos, range);
    }

    public <T extends LivingEntity> Predicate<T> isNotBlow() {
        return e -> e.m_6084_() && !e.m_21023_(PotionInit.resistance_blow) && this.canTargetEffect((LivingEntity)e, (Entity)this.m_269323_());
    }

    public <T extends LivingEntity> Predicate<T> isTarget() {
        return e -> e.m_6084_() && this.canTargetEffect((LivingEntity)e, (Entity)this.m_269323_());
    }

    public <T extends LivingEntity> Predicate<T> isBladTarget(double range) {
        return e -> e.m_6084_() && this.canTargetEffect((LivingEntity)e, (Entity)this.m_269323_()) && this.checkDistance(e.m_20183_(), range);
    }

    public boolean canTargetEffect(LivingEntity target, Entity owner) {
        return owner instanceof Player ? target instanceof Enemy : target instanceof Player;
    }

    public boolean checkDistance(BlockPos pos, double range) {
        return this.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) <= range;
    }

    protected void m_7840_(double par1, boolean par2, BlockState state, BlockPos pos) {
    }

    public void spawnParticleRing(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double addY, double ySpeed, double moveValue) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0 + addY;
        double z = (double)pos.m_123343_() + 0.5;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.25) {
            double rate = range * 0.75;
            server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, 0.0, ySpeed, 0.0, 1.0);
        }
    }

    public boolean isBoss(Entity entity) {
        LivingEntity liv;
        AbstractSMMob mob;
        return entity.m_6095_().m_204039_(TagInit.BOSS) || entity instanceof AbstractSMMob && !(mob = (AbstractSMMob)entity).isLowRank() || entity instanceof LivingEntity && (liv = (LivingEntity)entity).m_21023_(PotionInit.leader_flag);
    }

    public void addPotion(LivingEntity entity, MobEffect potion, int time, int level) {
        if (this.isBoss((Entity)entity)) {
            time /= 4;
            level = Math.min(0, level / 2);
            if (potion.equals(PotionInit.bubble)) {
                time = Math.min(10, time);
            }
        }
        PlayerHelper.setPotion(entity, potion, level, time);
    }

    public float getPower(float level) {
        return level * 0.2f + Math.min((level - 1.0f) * 0.255f, 5.0f) + Math.min(Math.max(6.0f * (1.0f - (level - 1.0f) * 0.0185f), 0.0f), 5.8f);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob mob) {
        return null;
    }

    public void teleportToOwner(LivingEntity owner) {
        BlockPos pos = owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int x = this.randInt(-3, 3);
            int y = this.randInt(-1, 1);
            int z = this.randInt(-3, 3);
            if (!this.maybeTeleport(owner, pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z)) continue;
            return;
        }
    }

    public boolean maybeTeleport(LivingEntity owner, int x, int y, int z) {
        if (Math.abs((double)x - owner.m_20185_()) < 2.0 && Math.abs((double)z - owner.m_20189_()) < 2.0) {
            return false;
        }
        this.m_7678_((double)x + 0.5, (double)y + 2.0, (double)z + 0.5, this.m_146908_(), this.m_146909_());
        return true;
    }

    public int randInt(int min, int max) {
        return this.rand.nextInt(max - min + 1) + min;
    }

    public boolean isClient() {
        return this.m_9236_().m_5776_();
    }

    public class RandomOwnerMoveGoal
    extends Goal {
        private final AbstractSummonMob mob;
        private final double addY;
        private int coolTime = 0;
        private double targetOldX = 0.0;
        private double targetOldZ = 0.0;

        public RandomOwnerMoveGoal(AbstractSummonMob mob, double addY) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.mob = mob;
            this.addY = addY;
        }

        public boolean m_8036_() {
            return !this.mob.m_21827_() && this.mob.m_269323_() != null;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8037_() {
            BlockPos pos = this.mob.m_20183_();
            LivingEntity owner = this.mob.m_269323_();
            double dis = this.mob.m_20270_((Entity)owner);
            boolean flag = owner.m_6084_() && dis > 4.0;
            MoveControl move = this.mob.m_21566_();
            if (dis > 8.0) {
                this.mob.teleportToOwner(owner);
                move.m_6849_(0.0, 0.0, 0.0, 0.0);
                this.targetOldX = move.m_25000_();
                this.targetOldZ = move.m_25002_();
                this.coolTime = 3;
                return;
            }
            if (this.coolTime-- > 0) {
                return;
            }
            for (int i = 0; i < 3; ++i) {
                BlockPos pos1;
                BlockPos blockPos = pos1 = flag ? owner.m_20183_().m_6630_(2) : WorldHelper.offset(pos, this.mob.randInt(7, 15), this.mob.randInt(5, 11), this.mob.randInt(7, 15));
                if (!this.mob.m_9236_().m_46859_(pos1)) continue;
                move.m_6849_((double)pos1.m_123341_() + 0.5, (double)pos1.m_123342_() + 0.5 + this.addY, (double)pos1.m_123343_() + 0.5, this.mob.m_21172_(Attributes.f_22280_));
                if (this.mob.m_5448_() == null) {
                    this.mob.m_21563_().m_24950_((double)pos1.m_123341_() + 0.5, (double)pos1.m_123342_() + 0.5, (double)pos1.m_123343_() + 0.5, 180.0f, 20.0f);
                }
                if (this.targetOldX == 0.0 && this.targetOldZ == 0.0) break;
                move.m_6849_(this.mob.f_19854_, this.mob.f_19855_ + 2.0, this.mob.f_19856_, this.mob.m_21172_(Attributes.f_22280_));
                this.targetOldX = 0.0;
                this.targetOldZ = 0.0;
                break;
            }
        }
    }

    public class SMOwnerHurtByTargetGoal
    extends OwnerHurtByTargetGoal {
        private final TamableAnimal mob;

        public SMOwnerHurtByTargetGoal(TamableAnimal mob) {
            super(mob);
            this.mob = mob;
        }

        public boolean m_8036_() {
            LivingEntity owner = this.mob.m_269323_();
            if (owner == null) {
                return super.m_8036_();
            }
            LivingEntity target = owner.m_21188_();
            return super.m_8036_() && target != null && target instanceof Enemy;
        }
    }

    public class SMOwnerHurtTargetGoal
    extends OwnerHurtTargetGoal {
        private final TamableAnimal mob;

        public SMOwnerHurtTargetGoal(TamableAnimal mob) {
            super(mob);
            this.mob = mob;
        }

        public boolean m_8036_() {
            LivingEntity owner = this.mob.m_269323_();
            if (owner == null) {
                return super.m_8036_();
            }
            LivingEntity target = owner.m_21188_();
            return super.m_8036_() && target != null && target instanceof Enemy;
        }
    }

    public class AttackTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        protected AbstractSummonMob attacker;

        public AttackTargetGoal(AbstractSummonMob mob, Class<T> entityClass, boolean flag) {
            this(mob, entityClass, 10, flag, false, null);
        }

        public AttackTargetGoal(AbstractSummonMob mob, Class<T> entityClass, boolean flag, Predicate<LivingEntity> entityPre) {
            this(mob, entityClass, 10, flag, false, entityPre);
        }

        public AttackTargetGoal(AbstractSummonMob mob, Class<T> entityClass, boolean flag1, boolean flag2) {
            this(mob, entityClass, 10, flag1, flag2, null);
        }

        public AttackTargetGoal(AbstractSummonMob mob, Class<T> entityClass, int par1, boolean flag1, @Nullable boolean flag2, Predicate<LivingEntity> entityPre) {
            super((Mob)mob, entityClass, par1, flag1, flag2, entityPre);
            this.attacker = mob;
        }

        public boolean m_8036_() {
            return this.attacker.m_21827_() ? false : super.m_8036_();
        }
    }

    public class NearestAttackSMMobGoal<T extends Monster>
    extends TargetGoal {
        @Nullable
        protected AbstractSummonMob attacker;
        protected LivingEntity target;
        protected final int randInterval;
        protected final Class<T> targetType;
        protected TargetingConditions targetConditions;

        public NearestAttackSMMobGoal(AbstractSummonMob mob, Class<T> entityClass, boolean flag) {
            this(mob, entityClass, 10, flag, false, null);
        }

        public NearestAttackSMMobGoal(AbstractSummonMob mob, Class<T> entityClass, boolean flag, Predicate<LivingEntity> entityPre) {
            this(mob, entityClass, 10, flag, false, entityPre);
        }

        public NearestAttackSMMobGoal(AbstractSummonMob mob, Class<T> entityClass, boolean flag1, boolean flag2) {
            this(mob, entityClass, 10, flag1, flag2, null);
        }

        public NearestAttackSMMobGoal(AbstractSummonMob mob, Class<T> entityClass, int par1, boolean flag1, @Nullable boolean flag2, Predicate<LivingEntity> entityPre) {
            super((Mob)mob, flag1, flag2);
            this.targetType = entityClass;
            this.randInterval = NearestAttackSMMobGoal.m_186073_((int)par1);
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
            this.targetConditions = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(entityPre);
            this.attacker = mob;
        }

        public boolean m_8036_() {
            if (this.attacker.m_21827_()) {
                return false;
            }
            if (this.randInterval > 0 && this.f_26135_.m_217043_().m_188503_(this.randInterval) != 0) {
                return false;
            }
            this.findTarget();
            return this.target != null;
        }

        protected AABB getTargetSearchArea(double par1) {
            return this.f_26135_.m_20191_().m_82377_(par1, 4.0, par1);
        }

        protected void findTarget() {
            List entityList = this.f_26135_.m_9236_().m_6443_(this.targetType, this.getTargetSearchArea(this.m_7623_()), e -> e.m_5448_() != null && e.m_5448_() instanceof Player);
            this.target = this.f_26135_.m_9236_().m_45982_(entityList, this.targetConditions, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_());
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.target);
            super.m_8056_();
        }

        public void setTarget(@Nullable LivingEntity entity) {
            this.target = entity;
        }
    }
}

