/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.animal;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.item.sm.SMFood;

public class WitchCat
extends AbstractSummonMob {
    protected int coolTime = 0;
    protected int recastTime = 0;

    public WitchCat(Level world) {
        super(EntityInit.witchCat, world);
    }

    public WitchCat(EntityType<? extends AbstractSummonMob> eType, Level world) {
        super(eType, world);
        this.f_21342_ = new ISMMob.SMMoveControl((Mob)this);
        this.m_20242_(true);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22280_, 0.2).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 0.15).m_22268_(Attributes.f_22277_, 48.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new AbstractSummonMob.RandomOwnerMoveGoal(this, 0.0));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public void setState(double rate) {
        super.setState(rate);
        this.setAttribute(Attributes.f_22280_, rate);
        this.setAttribute(Attributes.f_22278_, rate);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11785_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_11791_;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    @Override
    public float getDamageAmount(float amount) {
        this.m_5634_(amount * 0.1f);
        return Math.min(20.0f, amount * 0.5f);
    }

    @Override
    public void hurtAction(Entity attacker, float amount) {
        if (amount < 2.0f) {
            return;
        }
        this.m_5634_(amount * 0.1f);
    }

    @Override
    public boolean foodAction(Player player, ItemStack stack) {
        ItemStack foodStack = this.m_21205_();
        if (foodStack.m_41619_() && !stack.m_41619_()) {
            this.m_8061_(EquipmentSlot.MAINHAND, stack.m_41777_());
            stack.m_41774_(stack.m_41613_());
            this.m_5496_(SoundEvents.f_12019_, 0.67f, 1.0f);
        } else if (!foodStack.m_41619_()) {
            ItemStack copy = foodStack.m_41777_();
            if (!stack.m_41619_()) {
                this.m_8061_(EquipmentSlot.MAINHAND, stack.m_41777_());
                stack.m_41774_(stack.m_41613_());
            }
            foodStack.m_41774_(foodStack.m_41613_());
            this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), copy));
            this.m_5496_(SoundEvents.f_12019_, 0.67f, 1.0f);
        } else {
            return false;
        }
        return true;
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("coolTime", this.coolTime);
        tags.m_128405_("recastTime", this.recastTime);
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.coolTime = tags.m_128451_("coolTime");
        this.recastTime = tags.m_128451_("recastTime");
    }

    protected boolean m_213814_() {
        return false;
    }

    public void m_7023_(Vec3 vec) {
        if (this.m_21515_() || this.m_6109_()) {
            if (this.m_20069_()) {
                this.m_19920_(0.02f, vec);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_((double)0.8f));
            } else if (this.m_20077_()) {
                this.m_19920_(0.02f, vec);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.5));
            } else {
                this.m_19920_(this.m_6113_(), vec);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                this.m_20256_(this.m_20184_().m_82490_(0.9));
            }
        }
        this.m_267651_(false);
    }

    protected float m_6431_(Pose po, EntityDimensions dim) {
        return dim.f_20378_ * 0.6f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.addPotion();
    }

    public void addPotion() {
        if (this.isClient()) {
            return;
        }
        if (this.f_19797_ % 10 == 0 && this.recastTime-- <= 0) {
            this.recastTime = 10;
            ItemStack food = this.m_21205_();
            if (!food.m_41619_()) {
                this.eatFood(food);
            }
        }
        if (this.coolTime > 0) {
            int time = this.m_5448_() == null ? 1 : 3;
            this.coolTime -= time;
            if (this.coolTime > 0) {
                return;
            }
        }
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> e.m_6084_() && (e instanceof Player || e instanceof AbstractSummonMob), this.getRange() * 2.0f);
        for (LivingEntity entity : entityList) {
            float maxHealth = entity.m_21233_();
            boolean isPlayer = entity instanceof Player;
            if (entity.m_21223_() <= maxHealth / 2.0f) {
                float healRate = isPlayer ? 0.1f : 0.25f;
                entity.m_5634_(entity.m_21233_() * healRate);
                if (isPlayer) {
                    entity.m_5496_(SoundInit.HEAL, 0.0625f, 1.0f);
                }
                double pX = entity.m_20185_();
                double pY = entity.m_20186_();
                double pZ = entity.m_20189_();
                for (int i = 0; i < 3; ++i) {
                    this.spawnParticleRing(this.m_9236_(), (ParticleOptions)ParticleTypes.f_123748_, 1.0, pX, pY, pZ, 0.75 + (double)i * 0.5, 1.0, 1.0);
                }
                continue;
            }
            if (entity.m_21223_() >= maxHealth) {
                this.addPotion(entity, MobEffects.f_19600_, 1, 1200);
                if (!isPlayer) continue;
                entity.m_5496_(SoundEvents.f_11772_, 0.025f, 1.175f);
                continue;
            }
            this.addPotion(entity, PotionInit.aether_armor, 1, 1200);
            if (!isPlayer) continue;
            entity.m_5496_(SoundEvents.f_11887_, 0.025f, 1.175f);
        }
        this.coolTime = 1200;
    }

    public void eatFood(ItemStack stack) {
        Item item = stack.m_41720_();
        List<AbstractSummonMob> entityList = this.getEntityList(AbstractSummonMob.class, (T e) -> e.m_6084_() && e.m_21223_() <= e.m_21233_() * 0.33f, this.getRange() * 2.0f);
        for (AbstractSummonMob entity : entityList) {
            int foodValue = stack.getFoodProperties((LivingEntity)entity).m_38744_();
            entity.m_5634_(foodValue);
            entity.m_146852_(GameEvent.f_157806_, (Entity)entity);
            stack.m_41774_(1);
            entity.m_5496_(SoundEvents.f_11912_, 0.25f, 0.9f + this.rand.nextFloat(0.2f));
            if (item instanceof SMFood) {
                SMFood food = (SMFood)item;
                food.onFoodEat(this.m_9236_(), (LivingEntity)entity, stack);
                entity.setMaxLifeTime(entity.getMaxLifeTime() + foodValue * 50);
            }
            if (!stack.m_41619_()) continue;
            break;
        }
    }

    @Override
    public void discordAction() {
        ItemStack food = this.m_21205_();
        if (food.m_41619_()) {
            return;
        }
        LivingEntity owner = this.m_269323_();
        BlockPos pos = this.m_20183_();
        if (owner != null) {
            pos = owner.m_20183_().m_7494_();
        }
        this.m_9236_().m_7967_((Entity)new ItemEntity(this.m_9236_(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), food));
        this.m_5496_(SoundEvents.f_12019_, 0.67f, 1.0f);
    }

    protected void m_6153_() {
        this.discordAction();
        super.m_6153_();
    }

    protected void spawnParticleRing(Level world, ParticleOptions par, double range, double x, double y, double z, double addY, double ySpeed, double moveValue) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)world;
        y += addY;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 1.0) {
            double yS = ySpeed;
            if (ySpeed != 0.0) {
                yS += (double)(this.rand.nextFloat() * 0.025f);
            }
            server.m_8767_(par, x + Math.cos(degree), y, z + Math.sin(degree), 0, 0.0, yS, 0.0, moveValue);
        }
    }

    public Vec3 m_7939_() {
        return new Vec3(0.0, (double)this.m_20192_() * 0.6, (double)this.m_20205_() * 0.1);
    }
}

