/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.PotionInit;
import sweetmagic.util.SMDamage;

public abstract class AbstractSMMob
extends Monster
implements ISMMob {
    protected int defTime = 0;
    protected Random rand = new Random();

    public AbstractSMMob(EntityType<? extends AbstractSMMob> enType, Level world) {
        super(enType, world);
    }

    @Override
    public void refreshInfo() {
        this.m_20090_();
        this.m_6210_();
    }

    @Override
    public SynchedEntityData getData() {
        return this.m_20088_();
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Predicate<T> filter, double range) {
        return this.getEntityList(enClass, (Entity)this, filter, range);
    }

    public Predicate<LivingEntity> getFilter(boolean isPlayer) {
        return isPlayer ? this.getTargetEntity() : e -> !e.m_5833_() && e.m_6084_() && !this.isPlayer((Entity)e) && !(e instanceof ISMMob) && !e.m_21023_(PotionInit.resistance_blow);
    }

    public DamageSource getSRC() {
        return this.getDamage((Entity)this, SMDamage.magicDamage);
    }

    protected boolean teleport() {
        if (!this.isClient() && this.m_6084_()) {
            double x = this.m_20185_() + (this.rand.nextDouble() - 0.5) * 32.0;
            double y = this.m_20186_() + (double)(this.rand.nextInt(32) - 16);
            double z = this.m_20189_() + (this.rand.nextDouble() - 0.5) * 32.0;
            return this.teleport(x, y, z);
        }
        return false;
    }

    protected boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while (pos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)pos).m_280555_()) {
            pos.m_122173_(Direction.DOWN);
        }
        BlockState state = this.m_9236_().m_8055_((BlockPos)pos);
        boolean flag = state.m_280555_();
        boolean flag1 = state.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
            if (flag2) {
                this.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
                if (!this.m_20067_()) {
                    this.m_9236_().m_6263_((Player)null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                    this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                }
            }
            return flag2;
        }
        return false;
    }

    public void m_8119_() {
        try {
            super.m_8119_();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.defTime > 0) {
            --this.defTime;
        }
    }

    public void addEntity(Entity entity) {
        this.m_9236_().m_7967_(entity);
    }

    public boolean isClient() {
        return this.m_9236_().m_5776_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance dif, MobSpawnType spawn, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        data = super.m_6518_(world, dif, spawn, data, tag);
        this.initMobData((LivingEntity)this, dif);
        return this.finalizeSpawn(new ISMMob.SpawnInfo(world, dif, spawn, data, tag));
    }

    public SpawnGroupData finalizeSpawn(ISMMob.SpawnInfo info) {
        return info.data();
    }
}

