/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.entity.ai.BlazeAttackGoal;
import sweetmagic.init.entity.monster.AbstractSMMob;

public class BlazeTempestTornado
extends AbstractSMMob {
    private float allowHeight = 0.5f;
    private int nextTick;
    private int tickTime = 0;
    private int windTime = 50;
    private static final EntityDataAccessor<Integer> CANDLE = ISMMob.setData(BlazeTempestTornado.class, INT);

    public BlazeTempestTornado(Level world) {
        super(EntityInit.blazeTempestTornado, world);
    }

    public BlazeTempestTornado(EntityType<BlazeTempestTornado> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 200;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(CANDLE, 0);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new BlazeAttackGoal((Mob)this, this.isHard(this.m_9236_()), 1));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean m_6469_(DamageSource src, float amount) {
        int count;
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (this.isSMMobSRC(src)) {
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (!this.isLeader((LivingEntity)this)) {
            amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, 20.0f);
            this.defTime = 1;
        }
        if (!this.isClient() && amount >= 2.0f && this.f_19797_ > this.tickTime && (count = this.getCandole()) < 4) {
            this.setCandole(count + 1);
            this.tickTime = this.f_19797_ + 5;
        }
        return super.m_6469_(src, amount);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11701_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_11704_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11703_;
    }

    public float m_213856_() {
        return 1.0f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isClient() && this.m_5448_() != null) {
            double x = this.f_19854_ + this.rand.nextDouble() - 0.5;
            double y = this.f_19855_ + this.rand.nextDouble() + 0.5;
            double z = this.f_19856_ + this.rand.nextDouble() - 0.5;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123766_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public void m_8107_() {
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 13.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.6, 1.0));
        }
        super.m_8107_();
    }

    protected void m_8024_() {
        LivingEntity entity2;
        LivingEntity target;
        super.m_8024_();
        --this.nextTick;
        if (this.nextTick <= 0) {
            this.nextTick = 100;
            this.allowHeight = (float)this.m_217043_().m_216328_(0.5, 6.891);
        }
        if ((target = this.m_5448_()) == null || (double)this.m_21233_() <= 50.0) {
            return;
        }
        if (target.m_20188_() > this.m_20188_() + (double)this.allowHeight) {
            Vec3 vec3 = this.m_20184_();
            this.m_20256_(vec3.m_82520_(0.0, (0.3 - vec3.f_82480_) * 0.4, 0.0));
            this.f_19812_ = true;
        }
        if (this.f_19797_ % 20 != 0 || this.getCandole() < 4 || this.windTime++ < 7) {
            return;
        }
        boolean isPlayer = this.isPlayer((Entity)target);
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer), 8.0);
        if (entityList.isEmpty()) {
            return;
        }
        for (LivingEntity entity2 : entityList) {
            entity2.m_6469_(this.getSRC(), 10.0f);
            entity2.f_19802_ = 0;
            entity2.f_19855_ += 10.0;
            LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)entity2, (float)2.0f, (double)(entity2.m_20185_() - this.m_20185_()), (double)(entity2.m_20189_() - this.m_20189_()));
            if (event.isCanceled()) continue;
            Vec3 vec3 = new Vec3(event.getRatioX(), 0.75, event.getRatioZ()).m_82490_((double)event.getStrength());
            entity2.m_20256_(entity2.m_20184_().m_82549_(vec3));
            entity2.f_19789_ = (float)((double)entity2.f_19789_ + 1.0);
        }
        this.setCandole(0);
        this.windTime = 0;
        entity2 = this.m_9236_();
        if (!(entity2 instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)entity2;
        float x = (float)this.m_20185_() + this.rand.nextFloat() - 0.5f;
        float y = (float)this.m_20186_() + this.rand.nextFloat() - 0.5f;
        float z = (float)this.m_20189_() + this.rand.nextFloat() - 0.5f;
        for (int i = 0; i < 16; ++i) {
            sever.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.15f);
        }
    }

    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("candole", this.getCandole());
    }

    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setCandole(tags.m_128451_("candole"));
    }

    public int getCandole() {
        return (Integer)this.get(CANDLE);
    }

    public void setCandole(int size) {
        this.set(CANDLE, size);
    }

    @Override
    public boolean isLowRank() {
        return false;
    }
}

