/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.entity.monster.AbstractSMMob;
import sweetmagic.init.entity.monster.DwarfZombie;

public class DwarfZombieMaster
extends AbstractSMMob {
    private List<BlockPos> posList = new ArrayList<BlockPos>();
    private static final EntityDataAccessor<Boolean> SUMMON = ISMMob.setData(DwarfZombieMaster.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> HALF_HEALTH = ISMMob.setData(DwarfZombieMaster.class, BOOLEAN);

    public DwarfZombieMaster(Level world) {
        super(EntityInit.dwarfZombieMaster, world);
    }

    public DwarfZombieMaster(EntityType<DwarfZombieMaster> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 200;
        this.m_274367_(1.25f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(SUMMON, false);
        this.define(HALF_HEALTH, false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 150.0).m_22268_(Attributes.f_22279_, 0.33).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_12608_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12603_;
    }

    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (this.isSMMobSRC(src)) {
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (!this.isLeader((LivingEntity)this)) {
            amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, 20.0f);
            this.defTime = 1;
        }
        return super.m_6469_(src, amount);
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null || this.f_19797_ % 100 != 0 || this.isLeader((LivingEntity)this)) {
            return;
        }
        if (!this.getSummon()) {
            for (int i = 0; i < 3; ++i) {
                DwarfZombie entity = new DwarfZombie(this.m_9236_());
                entity.m_6034_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5);
                entity.m_21051_(Attributes.f_22276_).m_22100_((double)(this.m_21233_() / 5.0f));
                entity.m_21153_(entity.m_21233_());
                entity.setOwnerID(this.m_20148_());
                entity.setSummon(true);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
                this.addEntity((Entity)entity);
                entity.teleport();
                entity.m_21373_();
                this.f_21348_[EquipmentSlot.MAINHAND.m_20749_()] = 0.0f;
            }
            this.setSummon(true);
        }
        if (this.isHalfHealth((LivingEntity)this) && !this.isHalfHealth()) {
            int count = 0;
            List<BlockPos> posList = this.getPosList();
            for (BlockPos pos : posList) {
                DwarfZombie entity = new DwarfZombie(this.m_9236_());
                entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                entity.m_21051_(Attributes.f_22276_).m_22100_((double)(this.m_21233_() / 10.0f));
                entity.m_21153_(entity.m_21233_());
                entity.m_21373_();
                entity.setOwnerID(this.m_20148_());
                entity.setSummon(true);
                entity.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
                this.addEntity((Entity)entity);
                entity.m_21373_();
                this.f_21348_[EquipmentSlot.MAINHAND.m_20749_()] = 0.0f;
                if (count++ < 3) continue;
                break;
            }
            this.setHalfHealth(true);
            posList.clear();
        }
    }

    public boolean m_7327_(Entity entity) {
        boolean flag = super.m_7327_(entity);
        float baseDamae = (float)this.m_21133_(Attributes.f_22281_);
        if (flag && entity instanceof Warden) {
            Warden target = (Warden)entity;
            float dame = baseDamae + EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)target.m_6336_());
            entity.m_6469_(this.getSRC(), dame * 2.0f);
        }
        Vec3 look = this.m_20252_(1.0f);
        Vec3 dest = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82520_(0.0, (double)this.m_20192_(), 0.0).m_82520_(look.f_82479_ * 2.0, look.f_82480_ * 2.0, look.f_82481_ * 2.0);
        BlockPos pos = new BlockPos((int)dest.f_82479_, (int)this.m_20186_(), (int)dest.f_82481_);
        entity.f_19802_ = 0;
        List entityList = this.getEntityList(LivingEntity.class, (Entity)this, this.getFilter(this.isPlayer(entity)), pos, 2.0);
        for (LivingEntity target : entityList) {
            if (target.m_7306_(entity)) continue;
            target.m_6469_(this.getSRC(), baseDamae * 0.25f);
            target.f_19802_ = 0;
        }
        Vec3 vec3 = new Vec3(this.m_20185_() - entity.m_20185_(), 0.2, this.m_20189_() - entity.m_20189_()).m_82490_(2.0);
        this.m_20256_(this.m_20184_().m_82549_(vec3));
        return flag;
    }

    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("isSummon", this.getSummon());
        tags.m_128379_("isHalfHealth", this.isHalfHealth());
    }

    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setSummon(tags.m_128471_("isSummon"));
        this.setHalfHealth(tags.m_128471_("isHalfHealth"));
    }

    public boolean getSummon() {
        return (Boolean)this.get(SUMMON);
    }

    public void setSummon(boolean summonCount) {
        this.set(SUMMON, summonCount);
    }

    public boolean isHalfHealth() {
        return (Boolean)this.get(HALF_HEALTH);
    }

    public void setHalfHealth(boolean isHalfHealth) {
        this.set(HALF_HEALTH, isHalfHealth);
    }

    public List<BlockPos> getPosList() {
        return this.posList;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ISMMob.SpawnInfo info) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemInit.alt_sword));
        return super.finalizeSpawn(info);
    }

    @Override
    public boolean isLowRank() {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }
}

