/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.entity.monster.AbstractOwnerMob;

public class EnderShadowMirage
extends AbstractOwnerMob {
    private static final EntityDataAccessor<Boolean> SUMMON = ISMMob.setData(EnderShadowMirage.class, EntityDataSerializers.f_135035_);

    public EnderShadowMirage(Level world) {
        super(EntityInit.enderShadowMirage, world);
    }

    public EnderShadowMirage(EntityType<EnderShadowMirage> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 50;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(SUMMON, false);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean m_6469_(DamageSource src, float amount) {
        if (this.isSMMobSRC(src)) {
            return false;
        }
        amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, 30.0f);
        this.defTime = 2;
        return super.m_6469_(src, Math.min(amount, 25.0f));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11899_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_11849_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11900_;
    }

    public boolean m_7327_(Entity entity) {
        boolean flag = super.m_7327_(entity);
        if (flag && entity instanceof Warden) {
            Warden target = (Warden)entity;
            entity.m_6469_(this.getSRC(), 10.0f);
        }
        entity.f_19802_ = 0;
        return flag;
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        if (this.f_19797_ % 20 == 0 && !this.m_142582_((Entity)target)) {
            this.teleport(target);
        }
    }

    protected boolean teleport(LivingEntity target) {
        if (!this.isClient() && this.m_6084_()) {
            double x = target.m_20185_() + (this.rand.nextDouble() - 0.5) * 5.0;
            double y = target.m_20186_() + (double)(this.rand.nextInt(8) - 4);
            double z = target.m_20189_() + (this.rand.nextDouble() - 0.5) * 5.0;
            return this.teleport(x, y, z);
        }
        return false;
    }

    @Override
    public boolean isLowRank() {
        return false;
    }
}

