/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.AbstractSMMob;
import sweetmagic.util.WorldHelper;

public class PhantomWolf
extends AbstractSMMob {
    public PhantomWolf(Level world) {
        super(EntityInit.phantomWolf, world);
    }

    public PhantomWolf(EntityType<PhantomWolf> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 200;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12619_;
    }

    public float m_6100_() {
        return 0.8f;
    }

    protected float m_6121_() {
        return 0.5f;
    }

    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (this.isSMMobSRC(src)) {
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (!this.isLeader((LivingEntity)this)) {
            amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, 20.0f);
            this.defTime = 1;
        }
        return super.m_6469_(src, amount);
    }

    public boolean m_7327_(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return true;
        }
        LivingEntity target = (LivingEntity)entity;
        double range = 3.0;
        float damage = (float)this.m_21133_(Attributes.f_22281_) + 2.0f;
        Vec3 vec3 = new Vec3(this.m_20185_() - entity.m_20185_(), 0.2, this.m_20189_() - entity.m_20189_()).m_82490_(2.0);
        this.m_20256_(this.m_20184_().m_82549_(vec3));
        List<LivingEntity> targetList = this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer((Entity)target)), 4.0);
        for (LivingEntity livingEntity : targetList) {
            float newDamage = damage;
            if (!livingEntity.m_21023_(PotionInit.deadly_poison)) {
                this.addPotion(target, PotionInit.deadly_poison, 100, 1);
            } else {
                newDamage += 4.0f;
            }
            if (entity instanceof Warden) {
                newDamage *= 3.0f;
            }
            livingEntity.m_6469_(this.getMagicDamage((Entity)this), newDamage);
            livingEntity.f_19802_ = 0;
        }
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Random random = this.rand;
            double effectRange = range * range;
            SimpleParticleType par = ParticleInit.SMOKY;
            Iterable<BlockPos> pList = WorldHelper.getRangePos(this.m_20183_(), -range, 0.0, -range, range, 0.0, range);
            for (BlockPos pos : pList) {
                if (!this.checkDistance(pos, effectRange)) continue;
                double x = (double)pos.m_123341_() + random.nextDouble() * 1.5 - 0.75;
                double y = (double)pos.m_123342_() + random.nextDouble() * 1.5 - 0.75;
                double z = (double)pos.m_123343_() + random.nextDouble() * 1.5 - 0.75;
                server.m_8767_((ParticleOptions)par, x, y, z, 0, (double)0.2627451f, 0.6784313917160034, 0.40392157435417175, 1.0);
            }
        }
        return true;
    }

    public boolean checkDistance(BlockPos pos, double range) {
        return this.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) <= range;
    }

    @Override
    public boolean isLowRank() {
        return false;
    }
}

