/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import sweetmagic.api.ientity.IWitch;
import sweetmagic.config.SMConfig;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.entity.monster.AbstractSMMob;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.init.entity.projectile.BubbleMagicShot;
import sweetmagic.init.entity.projectile.CycloneMagicShot;
import sweetmagic.init.entity.projectile.FrostMagicShot;
import sweetmagic.init.entity.projectile.LightMagicShot;

public class WindWitch
extends AbstractSMMob
implements IWitch {
    private int recastTime = 0;
    private static final int RAND_RECASTTIME = 50;
    public AnimationState magicAttackAnim = new AnimationState();
    private static final EntityDataAccessor<Boolean> TARGET = SynchedEntityData.m_135353_(WindWitch.class, (EntityDataSerializer)BOOLEAN);
    private static final ItemStack WAND = new ItemStack((ItemLike)ItemInit.divine_wand_b);

    public WindWitch(Level world) {
        super(EntityInit.windWitch, world);
    }

    public WindWitch(EntityType<WindWitch> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 75;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.265).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22284_, 3.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    @Override
    public int getMaxSpawnDate() {
        return (Integer)SMConfig.spawnDate.get() * 3;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12548_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_12552_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12550_;
    }

    @Override
    public AnimationState getAnimaState() {
        return this.magicAttackAnim;
    }

    @Override
    public boolean isCharge() {
        return false;
    }

    public boolean m_6469_(DamageSource src, float amount) {
        if (this.isSMMobSRC(src)) {
            return false;
        }
        amount = this.getDamageAmount((Entity)this, src, amount, 0.25f);
        if (!this.m_9236_().m_5776_() && !src.m_269533_(TagInit.SMDAMAGE) && this.recastTime > 0) {
            this.recastTime = (int)((float)this.recastTime * 0.75f);
        }
        return super.m_6469_(src, amount);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.define(TARGET, false);
    }

    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("is_target", this.isTarget());
    }

    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.set(TARGET, tags.m_128471_("is_target"));
    }

    @Override
    public boolean isTarget() {
        return (Boolean)this.get(TARGET);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 10 == 0) {
            this.set(TARGET, this.m_5448_() != null);
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        if (this.recastTime-- > 0) {
            return;
        }
        boolean isWarden = target instanceof Warden;
        this.recastTime = (int)((float)(this.rand.nextInt(50) + 50) * (isWarden ? 0.25f : 1.0f) * (this.isHalfHealth((LivingEntity)this) ? 0.75f : 1.0f));
        AbstractMagicShot entity = this.getMagicShot(target, isWarden);
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        this.addEntity((Entity)entity);
    }

    public AbstractMagicShot getMagicShot(LivingEntity target, boolean isWarden) {
        AbstractMagicShot entity = null;
        float dama = isWarden ? 30.0f : 1.25f;
        float dameRate = isWarden ? 1.25f : this.getDateRate(this.m_9236_(), 0.1f);
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20227_(0.3333333333333333) - this.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double xz = Math.sqrt(x * x + z * z);
        int level = isWarden ? 20 : 7;
        switch (this.rand.nextInt(4)) {
            case 1: {
                entity = new FrostMagicShot((LivingEntity)this);
                break;
            }
            case 2: {
                entity = new LightMagicShot((LivingEntity)this);
                break;
            }
            case 3: {
                entity = new BubbleMagicShot((LivingEntity)this);
                level = 4;
                break;
            }
            default: {
                entity = new CycloneMagicShot((LivingEntity)this);
            }
        }
        entity.setWandLevel(level);
        entity.m_6686_(x, y - xz * 0.035, z, 3.35f, 0.0f);
        entity.setAddDamage((entity.getAddDamage() + dama) * dameRate);
        return entity;
    }

    @Override
    public ItemStack getStack() {
        return WAND;
    }
}

