/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.BlockInit;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.CherryPlant;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.CherryMagicShot;
import sweetmagic.util.PlayerHelper;

public class Arlaune
extends AbstractSMBoss {
    private int cherryTime = 0;
    private static final int MAX_CHERRYTIME = 100;
    private int plantTime = 0;
    private static final int MAX_PLANTTIME = 100;
    private int shotTime = 140;
    private static final int MAX_SHOTTIME = 150;
    private int summonTime = 600;
    private static final int MAX_SUMMONTIME = 700;
    private int rainTime = 0;
    private static final int MAX_RAINTIME = 220;
    public double oldHealth = 450.0;
    private static final EntityDataAccessor<Boolean> CLOSE = ISMMob.setData(Arlaune.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> SUMMON = ISMMob.setData(Arlaune.class, BOOLEAN);
    private static final EntityDataAccessor<Integer> CHERRY = ISMMob.setData(Arlaune.class, INT);
    private static final EntityDataAccessor<Integer> PLANT = ISMMob.setData(Arlaune.class, INT);

    public Arlaune(Level world) {
        super(EntityInit.arlaune, world);
    }

    public Arlaune(EntityType<? extends AbstractSMBoss> enType, Level world) {
        super(enType, world);
        this.setBossEvent(BC_BLUE, NOTCHED_6);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 450.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 64.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(SUMMON, false);
        this.define(CLOSE, false);
        this.define(CHERRY, 0);
        this.define(PLANT, 0);
    }

    public boolean getClose() {
        return (Boolean)this.get(CLOSE);
    }

    public void setClose(boolean isClose) {
        this.set(CLOSE, isClose);
    }

    public boolean getSummon() {
        return (Boolean)this.get(SUMMON);
    }

    public void setSummon(boolean summon) {
        this.set(SUMMON, summon);
    }

    public int getCherry() {
        return (Integer)this.get(CHERRY);
    }

    public void setCherry(int cherry) {
        this.set(CHERRY, cherry);
    }

    public int getPlant() {
        return (Integer)this.get(PLANT);
    }

    public void setPlant(int plant) {
        this.set(PLANT, plant);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("isClose", this.getClose());
        tags.m_128405_("cherry", this.getCherry());
        tags.m_128405_("plant", this.getPlant());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setClose(tags.m_128471_("isClose"));
        this.setCherry(tags.m_128451_("cherry"));
        this.setPlant(tags.m_128451_("plant"));
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (this.isSMMobSRC(src)) {
            return false;
        }
        int n = this.defTime = (amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, 7.0f)) > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, this.getSRC(), amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (amount > 1.0f && !this.isClient()) {
            this.setCherry(this.getCherry() + 1);
        }
        return super.m_6469_(src, amount);
    }

    @Override
    protected void m_8024_() {
        LivingEntity target;
        Level level;
        if (this.oldHealth != (double)this.m_21223_()) {
            this.oldHealth = this.m_21223_();
        }
        super.m_8024_();
        if (this.f_19797_ % 10 == 0 && this.getCherry() > 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Random rand = this.rand;
            Vec3 vec = this.m_20184_();
            SimpleParticleType par = ParticleInit.CHERRY_BLOSSOMS_LARGE;
            float pX = (float)this.m_20185_();
            float pY = (float)this.m_20186_();
            float pZ = (float)this.m_20189_();
            for (int i = 0; i < this.getCherry(); ++i) {
                float x = pX + this.getRandFloat(1.5f);
                float y = pY + this.getRandFloat(0.5f) + 2.0f;
                float z = pZ + this.getRandFloat(1.5f);
                float xS = (float)(vec.f_82479_ + 0.5 - (double)rand.nextFloat()) * 0.2f;
                float yS = (float)(vec.f_82480_ + 0.5 - (double)rand.nextFloat()) * 0.2f;
                float zS = (float)(vec.f_82481_ + 0.5 - (double)rand.nextFloat()) * 0.2f;
                server.m_8767_((ParticleOptions)par, (double)x, (double)y, (double)z, 0, (double)xS, (double)yS, (double)zS, 1.0);
            }
        }
        if ((target = this.m_5448_()) == null) {
            this.clearInfo();
            return;
        }
        if (!this.getSummon() && this.summonTime++ >= 700) {
            this.summonCherry(target);
        }
        this.checkPotion(MobEffects.f_19591_, 9999, 0);
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        this.firstAttack(target);
        if (this.isHalfHealth((LivingEntity)this)) {
            this.secondAttack(target);
        }
    }

    public void firstAttack(LivingEntity target) {
        if (this.getCherry() >= 6) {
            this.cherryAttack(target);
        }
        if (this.getPlant() > 0) {
            this.plantAttack(target);
        }
        if (this.shotTime++ >= 150) {
            this.shotAttack(target);
        }
        if (this.f_19797_ % 100 == 0 && this.getSummon()) {
            this.checkSummon(target);
        }
    }

    public void secondAttack(LivingEntity target) {
        this.rainAttack(target);
        if (this.f_19797_ % 10 == 0 && !this.m_21023_(PotionInit.reflash_effect)) {
            this.addPotion((LivingEntity)this, PotionInit.reflash_effect, 999999, 0);
        }
    }

    public void summonCherry(LivingEntity target) {
        List<LivingEntity> targetList = this.getPlayerList(target);
        int count = (int)Math.min(10.0f, 3.0f + this.getPlayerCount(targetList) * 2.0f);
        BlockPos pos = this.getSpawnPos();
        for (int i = 0; i < count; ++i) {
            int setPosCount = 0;
            BlockPos targetPos = new BlockPos(pos.m_123341_() + this.getRand(this.rand, 16), pos.m_123342_(), pos.m_123343_() + this.getRand(this.rand, 16));
            CherryPlant crystal = new CherryPlant(this.m_9236_());
            while (!this.m_9236_().m_46859_(targetPos) && !this.m_9236_().m_8055_(targetPos).m_60713_(BlockInit.rune_character)) {
                targetPos = new BlockPos(targetPos.m_123341_() + this.getRand(this.rand, 3), targetPos.m_123342_(), targetPos.m_123343_() + this.getRand(this.rand, 3));
                if (setPosCount++ < 16) continue;
            }
            crystal.m_6034_((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5);
            crystal.setOwnerID((LivingEntity)this);
            if (!this.isClient()) {
                this.addEntity((Entity)crystal);
                crystal.m_5496_(SoundEvents.f_11991_, 1.0f, 0.8f + this.rand.nextFloat() * 0.4f);
            }
            this.addPotion((LivingEntity)this, PotionInit.resistance_blow, 999999, 5);
            this.addPotion((LivingEntity)this, PotionInit.aether_armor, 200, 4);
            this.addPotion((LivingEntity)this, PotionInit.aether_barrier, 200, 4);
        }
        this.setSummon(true);
        this.summonTime = 0;
    }

    public void cherryAttack(LivingEntity target) {
        LivingEntity entity2;
        if (this.cherryTime++ < 100) {
            return;
        }
        int count = this.getCherry();
        double range = 8.0 + (double)count * 1.5;
        float amount = 20.0f + this.getBuffPower();
        List<LivingEntity> targetList = this.getPlayerList(target);
        for (LivingEntity entity2 : targetList) {
            this.attackDamage((Entity)entity2, this.getSRC(), entity2 instanceof Enemy ? amount * 5.0f : amount);
            entity2.m_5496_(SoundEvents.f_11929_, 0.25f, 1.0f);
        }
        this.cherryTime = 0;
        this.setCherry(0);
        entity2 = this.m_9236_();
        if (!(entity2 instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)entity2;
        BlockPos pos = this.m_20183_();
        SimpleParticleType par = ParticleInit.CHERRY_BLOSSOMS_LARGE;
        for (double eRange = 0.0; eRange < range; eRange += 1.0) {
            for (int i = 0; i < 2; ++i) {
                this.spawnParticleRing2(server, (ParticleOptions)par, 1.0 + eRange - (double)i, pos.m_6630_(i), -0.05, -0.35);
            }
        }
    }

    public void plantAttack(LivingEntity target) {
        if (this.plantTime++ < 100) {
            return;
        }
        int count = this.getPlant();
        float amount = 15.0f + (float)count * 2.0f;
        List<LivingEntity> targetList = this.getPlayerList(target);
        for (LivingEntity entity : targetList) {
            this.attackDamage((Entity)entity, this.getSRC(), entity instanceof Enemy ? amount * 4.0f : amount);
            List<MobEffectInstance> effecList = PlayerHelper.getEffectList(entity, PotionInit.BUFF);
            if (effecList.isEmpty()) continue;
            MobEffect potion = effecList.get(this.rand.nextInt(effecList.size())).m_19544_();
            entity.m_21195_(potion);
        }
        this.addPotion((LivingEntity)this, MobEffects.f_19600_, 2400, count);
        this.summonTime = 0;
        this.plantTime = 0;
        this.setPlant(0);
        this.setSummon(false);
    }

    public void shotAttack(LivingEntity target) {
        List<LivingEntity> targetList = this.getPlayerList(target);
        for (LivingEntity entity : targetList) {
            CherryMagicShot magic = new CherryMagicShot((LivingEntity)this);
            double x = entity.m_20185_() - this.m_20185_();
            double y = entity.m_20227_(0.3333333333333333) - this.m_20186_();
            double z = entity.m_20189_() - this.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            int level = 4;
            float dama = 8.0f;
            magic.setWandLevel(level);
            magic.m_6686_(x, y - xz * 0.065, z, 2.0f, 0.0f);
            magic.setAddDamage(magic.getAddDamage() + dama);
            magic.setRange(3.0);
            magic.setData(1);
            this.addEntity((Entity)magic);
        }
        this.shotTime = 0;
    }

    public void checkSummon(LivingEntity target) {
        List<CherryPlant> targetList = this.getEntityList(CherryPlant.class, (T e) -> e.m_6084_() && e.is((LivingEntity)this), 80.0);
        this.setSummon(!targetList.isEmpty());
    }

    public void rainAttack(LivingEntity target) {
        if (this.rainTime >= 0 && this.rainTime < 30) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.1, 0.0));
        } else if ((double)this.rainTime >= 30.0) {
            this.m_20256_(new Vec3(0.0, 0.0, 0.0));
        }
        if (this.rainTime++ < 220) {
            return;
        }
        BlockPos pos = target.m_20183_();
        boolean isPlayer = this.isPlayer((Entity)target);
        List<LivingEntity> targetList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer), 48.0);
        if (targetList.isEmpty()) {
            return;
        }
        double range = 15.0 + (double)targetList.size() * 2.0;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            Iterable posList = this.getPosRangeList(pos, range);
            SimpleParticleType par = ParticleInit.CHERRY_BLOSSOMS_LARGE;
            for (BlockPos p : posList) {
                if (this.rand.nextFloat() >= 0.04f || !this.checkDistances(pos, p, range * range)) continue;
                double x = (double)p.m_123341_() + this.rand.nextDouble() * 1.5 - 0.75;
                double y = (double)p.m_123342_() + this.rand.nextDouble() * 1.5 - 0.75;
                double z = (double)p.m_123343_() + this.rand.nextDouble() * 1.5 - 0.75;
                float xS = this.getRandFloat(0.1f);
                float yS = 0.2f + this.getRandFloat(0.1f);
                float zS = this.getRandFloat(0.1f);
                server.m_8767_((ParticleOptions)par, x, y, z, 0, (double)xS, (double)yS, (double)zS, 1.0);
            }
        }
        if (this.rainTime % 10 == 0) {
            float amount = 4.0f + this.getBuffPower();
            boolean isRainMax = this.rainTime >= 220;
            AABB aabb = this.getAABB(pos, range += 2.5);
            List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer), aabb);
            for (LivingEntity entity : entityList) {
                if (isRainMax) {
                    amount *= 3.0f;
                    entity.m_5496_(SoundEvents.f_11929_, 0.25f, 1.0f);
                }
                this.attackDamage((Entity)entity, this.getSRC(), entity instanceof Enemy ? amount * 4.0f : amount);
            }
        }
        if (this.rainTime >= 340) {
            this.rainTime = -(260 + this.rand.nextInt(100));
        }
    }

    @Override
    public void clearInfo() {
        this.rainTime = -(50 + this.rand.nextInt(100));
    }

    protected int getRand(Random rand, int range) {
        return rand.nextInt(range) - rand.nextInt(range);
    }

    public void spawnParticleRing2(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double addY, double speed) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0 + addY;
        double z = (double)pos.m_123343_() + 0.5;
        Random rand = this.rand;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.25) {
            if (rand.nextFloat() >= 0.3f) continue;
            double rate = range * 0.75;
            server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, Math.cos(degree) * 0.65, 0.0, Math.sin(degree) * 0.65, speed);
        }
    }
}

