/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;

public class BullFight
extends AbstractSMBoss {
    private final List<LivingEntity> targetList = new ArrayList<LivingEntity>();
    private static final EntityDataAccessor<Integer> ATTACK = ISMMob.setData(BullFight.class, INT);
    private int rushAttackChargeTime = 0;
    private static final int RUSHATTACKCHARGEMAXTIME = 60;
    private int pressAttackChargeTime = 0;
    private static final int PRESSATTACKCHARGEMAXTIME = 70;

    public BullFight(Level world) {
        super(EntityInit.bullfight, world);
    }

    public BullFight(EntityType<? extends AbstractSMBoss> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 350;
        this.m_274367_(1.25f);
        this.setBossEvent(BC_BLUE, NOTCHED_6);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new AbstractSMBoss.SMRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 256.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 92.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(ATTACK, 0);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11830_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_11832_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11831_;
    }

    public float m_6100_() {
        return 1.25f;
    }

    protected float m_6121_() {
        return 0.4f;
    }

    public int getAttackType() {
        return (Integer)this.get(ATTACK);
    }

    public void setAttackType(int attack) {
        this.set(ATTACK, attack);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (this.isSMMobSRC(src)) {
            return false;
        }
        int n = this.defTime = (amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, 10.0f)) > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, this.getSRC(), amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        return super.m_6469_(src, amount);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        if (this.m_21023_(PotionInit.flame)) {
            this.m_21195_(PotionInit.flame);
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        if (this.getAttackType() == 0 && !this.isHalfHealth((LivingEntity)this)) {
            this.groundPress(target);
        } else {
            this.rushAttack(target);
        }
    }

    public void groundPress(LivingEntity target) {
        if (this.pressAttackChargeTime++ < 70 || this.f_19797_ % 3 != 0) {
            return;
        }
        boolean isPlayer = this.isPlayer((Entity)target);
        this.m_20256_(new Vec3(0.0, 0.0, 0.0));
        Level world = this.m_9236_();
        BlockPos pos = this.m_20183_();
        BlockPos targetPos = target.m_20183_();
        int maxTickTime = Math.min(10, (int)this.distance((Entity)target));
        float rate = (float)(++this.tickTime) / (float)maxTickTime;
        double x = (float)(targetPos.m_123341_() - pos.m_123341_()) * rate;
        double y = (float)(targetPos.m_123342_() - pos.m_123342_()) * rate;
        double z = (float)(targetPos.m_123343_() - pos.m_123343_()) * rate;
        BlockPos attackPos = new BlockPos(pos.m_123341_() + (int)x, pos.m_123342_() + (int)y, pos.m_123343_() + (int)z);
        BlockState state = world.m_8055_(attackPos);
        SoundType sound = state.m_60734_().getSoundType(state, (LevelReader)world, pos, (Entity)this);
        world.m_5594_(null, attackPos, sound.m_56775_(), SoundSource.HOSTILE, 2.5f, 0.9f + this.rand.nextFloat() * 0.2f);
        List<LivingEntity> attackList = this.getEntityList(LivingEntity.class, this.getFilterList(isPlayer), attackPos, 3.0);
        this.targetList.addAll(attackList);
        float amount = 15.0f;
        for (LivingEntity entity : attackList) {
            this.attackDamage((Entity)entity, this.getSRC(), entity instanceof Enemy ? amount * 4.0f : amount);
            entity.m_20256_(entity.m_20184_().m_82520_(entity.m_20185_() - this.m_20185_(), 0.8, entity.m_20189_() - this.m_20189_()));
        }
        if (world instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)world;
            BlockParticleOption par = new BlockParticleOption(ParticleTypes.f_123794_, state);
            for (int i = 0; i < 4; ++i) {
                BlockPos rangePos = new BlockPos(attackPos.m_123341_(), attackPos.m_123342_() - 2 + i, attackPos.m_123343_());
                this.spawnParticleRing(server, (ParticleOptions)par, 2.0, rangePos, 1.25, 0.25, 0.0);
            }
        }
        if (this.tickTime < maxTickTime) {
            return;
        }
        this.clearInfo();
    }

    public void rushAttack(LivingEntity target) {
        List<LivingEntity> attackList;
        Level level;
        boolean isHalf;
        if (this.rushAttackChargeTime++ < 60) {
            return;
        }
        Vec3 vec = this.m_20184_();
        double vX = vec.f_82479_;
        double vY = vec.f_82480_;
        double vZ = vec.f_82481_;
        Vec3 src = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82520_(0.0, (double)this.m_20192_(), 0.0);
        Vec3 look = this.m_20252_(1.0f);
        Vec3 dest = src.m_82520_(look.f_82479_ * 2.0, this.m_20186_(), look.f_82481_ * 2.0);
        vX = dest.f_82479_ - src.f_82479_;
        vZ = dest.f_82481_ - src.f_82481_;
        this.m_20256_(new Vec3(vX * 1.5, vY, vZ * 1.5));
        boolean bl = isHalf = this.isHalfHealth((LivingEntity)this) || target.m_21023_(PotionInit.flame);
        if (isHalf && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel sever = (ServerLevel)level;
            BlockPos pos = this.m_20183_();
            float aX = (float)(-vec.f_82479_) / 6.0f;
            float aY = (float)(-vec.f_82480_) / 6.0f;
            float aZ = (float)(-vec.f_82481_) / 6.0f;
            for (int i = 0; i < 16; ++i) {
                float x = (float)pos.m_123341_() + this.getRandFloat(1.5f) - 0.75f;
                float y = (float)pos.m_123342_() + this.getRandFloat(2.0f) + 0.5f;
                float z = (float)pos.m_123343_() + this.getRandFloat(1.5f) - 0.75f;
                sever.m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)x, (double)y, (double)z, 0, (double)aX, (double)aY, (double)aZ, 1.0);
            }
        }
        if ((attackList = this.getEntityList(LivingEntity.class, this.getFilterList(this.isPlayer((Entity)target)), 1.0)).isEmpty()) {
            return;
        }
        boolean isFlame = false;
        float amount = (float)this.m_21133_(Attributes.f_22281_);
        for (LivingEntity entity : attackList) {
            float totalAmount = amount;
            if (isHalf) {
                if (entity.m_21023_(PotionInit.flame)) {
                    isFlame = true;
                } else if (entity.m_21023_(PotionInit.reflash_effect)) {
                    totalAmount += 2.0f;
                } else {
                    this.addPotion(entity, PotionInit.flame, 300, 0);
                }
            }
            this.attackDamage((Entity)entity, this.getSRC(), entity instanceof Enemy ? totalAmount * 4.0f : totalAmount);
            entity.m_20256_(entity.m_20184_().m_82520_(entity.m_20185_() - this.m_20185_(), 0.8, entity.m_20189_() - this.m_20189_()));
            this.targetList.add(entity);
            Level level2 = this.m_9236_();
            if (!(level2 instanceof ServerLevel)) continue;
            ServerLevel sever = (ServerLevel)level2;
            sever.m_8767_((ParticleOptions)ParticleTypes.f_123797_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 0, 0.0, 0.0, 0.0, 1.0);
        }
        Vec3 vec3 = new Vec3(this.m_20185_() - target.m_20185_(), 0.2, this.m_20189_() - target.m_20189_()).m_82490_(2.5);
        this.m_20256_(this.m_20184_().m_82549_(vec3));
        this.rushAttackChargeTime = isFlame ? 40 : 0;
        this.clearInfo();
        this.m_5496_(SoundEvents.f_11830_, 1.5f, 1.2f);
    }

    public float distance(Entity entity) {
        float f = (float)(this.m_20185_() - entity.m_20185_());
        float f2 = (float)(this.m_20189_() - entity.m_20189_());
        return Mth.m_14116_((float)(f * f + f2 * f2));
    }

    @Override
    public void clearInfo() {
        this.targetList.clear();
        this.setAttackType(this.rand.nextInt(3));
        this.pressAttackChargeTime = 0;
        this.tickTime = 0;
    }

    public Predicate<LivingEntity> getFilterList(boolean isPlayer) {
        return e -> !e.m_5833_() && e.m_6084_() && e != this && !this.targetList.contains(e) && (isPlayer ? e instanceof Player || e instanceof AbstractSummonMob : !(e instanceof Player)) && !(e instanceof ISMMob);
    }
}

