/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.IAngel;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.ElectricMagicShot;
import sweetmagic.init.entity.projectile.ExplosionThunderShot;
import sweetmagic.init.entity.projectile.LigningBulletShot;

public class ElshariaCurious
extends AbstractSMBoss
implements IAngel {
    private int bulletTime = 150;
    private static final int MAX_BULLET_TTIME = 200;
    private int thunderTime = 200;
    private static final int MAX_THUNDER_TTIME = 400;
    private int lightBoltTime = 300;
    private static final int MAX_LIGHTBOL_TTIME = 600;
    private static final EntityDataAccessor<Boolean> BOLT = ISMMob.setData(ElshariaCurious.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> CHARGE = ISMMob.setData(ElshariaCurious.class, BOOLEAN);
    private Map<Integer, BlockPos> posMap = new LinkedHashMap<Integer, BlockPos>();

    public ElshariaCurious(Level world) {
        super(EntityInit.elshariaCurious, world);
    }

    public ElshariaCurious(EntityType<? extends AbstractSMBoss> enType, Level world) {
        super(enType, world);
        this.setBossEvent(BC_BLUE, NOTCHED_6);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(BOLT, false);
        this.define(CHARGE, false);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(4, (Goal)new AbstractSMBoss.SMRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 768.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 96.0);
    }

    public boolean getBolt() {
        return (Boolean)this.get(BOLT);
    }

    public void setBolt(boolean arrow) {
        this.set(BOLT, arrow);
    }

    @Override
    public boolean getCharge() {
        return (Boolean)this.get(CHARGE);
    }

    public void setCharge(boolean isCharge) {
        this.set(CHARGE, isCharge);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128379_("bolt", this.getBolt());
        tags.m_128379_("isCharge", this.getCharge());
        tags.m_128405_("bulletTime", this.bulletTime);
        tags.m_128405_("rodSetTime", this.thunderTime);
        tags.m_128405_("lightBoltTime", this.lightBoltTime);
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setBolt(tags.m_128471_("bolt"));
        this.setCharge(tags.m_128471_("isCharge"));
        this.bulletTime = tags.m_128451_("bulletTime");
        this.thunderTime = tags.m_128451_("rodSetTime");
        this.lightBoltTime = tags.m_128451_("lightBoltTime");
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (this.isSMMobSRC(src)) {
            return false;
        }
        int n = this.defTime = (amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, 7.0f)) > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, this.getSRC(), amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        return super.m_6469_(src, amount);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_20919_ > 0) {
            return;
        }
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        if (this.m_20186_() < target.m_20186_() || this.m_20186_() < target.m_20186_() + 4.0) {
            Vec3 vec = this.m_20184_();
            double y = Math.max(0.0, vec.f_82480_);
            y *= 0.25;
            y += (0.5 - y) * 0.25;
            this.m_20256_(new Vec3(vec.f_82479_, y, vec.f_82481_));
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        this.checkSpawnPos();
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        this.firstAttack(target);
        if (this.isHalfHealth((LivingEntity)this)) {
            this.secondAttack(target);
            this.checkPotion(PotionInit.reflash_effect, 9999, 0);
        }
    }

    public void firstAttack(LivingEntity target) {
        if (this.bulletTime++ >= 200) {
            this.bulletShot(target);
        }
        if (this.thunderTime++ >= 200) {
            this.thunderAction(target);
        }
    }

    public void secondAttack(LivingEntity target) {
        if (this.lightBoltTime++ >= 400) {
            this.setCharge(true);
            this.lightningBoltShot(target);
        }
    }

    public void bulletShot(LivingEntity target) {
        float damage = (float)this.m_21133_(Attributes.f_22281_) + 4.0f;
        List<LivingEntity> targetList = this.getPlayerList(target);
        for (LivingEntity entity : targetList) {
            double x = entity.m_20185_() - this.m_20185_();
            double y = entity.m_20227_(0.3333333333333333) - this.m_20186_();
            double z = entity.m_20189_() - this.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            LigningBulletShot magic = new LigningBulletShot((LivingEntity)this);
            magic.m_6686_(x, y - xz * 0.065, z, 1.0f, 0.0f);
            magic.setAddDamage(magic.getAddDamage() + damage);
            magic.setTarget((Entity)entity);
            magic.setMaxLifeTime(120);
            this.addEntity((Entity)magic);
        }
        this.bulletTime = 0;
    }

    public void thunderAction(LivingEntity target) {
        if (this.thunderTime < 400) {
            if (this.posMap.isEmpty()) {
                int size = (int)this.getPlayerCount(target) + 2;
                for (int i = 0; i < size; ++i) {
                    int z;
                    int y;
                    int x;
                    BlockPos pos;
                    while (this.posMap.containsValue(pos = new BlockPos(x = (int)(this.m_20185_() + (double)this.getRandFloat(20.0f)), y = (int)this.m_20186_() + 3 + this.rand.nextInt(8), z = (int)(this.m_20189_() + (double)this.getRandFloat(20.0f))))) {
                    }
                    this.posMap.put(i, pos);
                }
            } else if (this.f_19797_ % 30 == 0) {
                this.posMap.values().forEach(p -> this.spawnParticleCycle((BlockPos)p, 5.0));
            }
            return;
        }
        float damage = (float)this.m_21133_(Attributes.f_22281_) + 8.0f;
        for (Map.Entry<Integer, BlockPos> map : this.posMap.entrySet()) {
            BlockPos pos = map.getValue().m_6630_(3);
            ElectricMagicShot magic = new ElectricMagicShot((LivingEntity)this);
            magic.setAddDamage(magic.getAddDamage());
            magic.setRange(5.0);
            magic.setData(2);
            magic.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, 0.0f, 0.0f);
            magic.m_6034_(pos.m_123341_(), target.m_20186_(), pos.m_123343_());
            magic.setAddDamage(magic.getAddDamage() + damage);
            magic.m_20256_(new Vec3(0.0, -10.0, 0.0));
            magic.setHitDead(false);
            this.addEntity((Entity)magic);
        }
        this.thunderTime = 0;
    }

    public void lightningBoltShot(LivingEntity target) {
        if (this.lightBoltTime <= 600) {
            if (this.f_19797_ % 4 != 0) {
                return;
            }
            float damage = (float)this.m_21133_(Attributes.f_22281_) + 15.0f;
            for (int i = 0; i < 3; ++i) {
                int x = (int)(this.m_20185_() + (double)this.getRandFloat(20.0f));
                int y = (int)this.m_20186_() + 3 + this.rand.nextInt(5);
                int z = (int)(this.m_20189_() + (double)this.getRandFloat(20.0f));
                BlockPos pos = new BlockPos(x, y, z);
                ExplosionThunderShot magic = new ExplosionThunderShot((LivingEntity)this);
                magic.setAddDamage(magic.getAddDamage());
                magic.setRange(7.5);
                magic.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, 0.0f, 0.0f);
                magic.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                magic.setAddDamage(magic.getAddDamage() + damage);
                magic.m_20256_(new Vec3(0.0, -0.75, 0.0));
                magic.setHitDead(false);
                this.addEntity((Entity)magic);
            }
        } else {
            this.lightBoltTime = 0;
            this.setCharge(false);
        }
    }

    @Override
    public void clearInfo() {
        this.tickTime = 0;
        this.setCharge(false);
    }
}

