/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.EvilArrow;
import sweetmagic.init.entity.projectile.FireMagicShot;

public class IgnisKnight
extends AbstractSMBoss {
    private int targetCount = 0;
    private List<LivingEntity> entityList = new ArrayList<LivingEntity>();
    private List<LivingEntity> targetList = new ArrayList<LivingEntity>();
    private List<Player> playerList = new ArrayList<Player>();
    private static final EntityDataAccessor<Integer> ATTACK_TYPE = ISMMob.setData(IgnisKnight.class, INT);
    private static final EntityDataAccessor<Integer> ARMOR = ISMMob.setData(IgnisKnight.class, INT);
    private static final EntityDataAccessor<Boolean> RUSH = ISMMob.setData(IgnisKnight.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> SWING = ISMMob.setData(IgnisKnight.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> ATTACK = ISMMob.setData(IgnisKnight.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> BLAST = ISMMob.setData(IgnisKnight.class, BOOLEAN);
    private int recastTime = 0;
    private int firstAttackChargeTime = 0;
    private static final int FIRSTATTACKCHARGEMAXTIME = 135;
    private int firstAttackTime = 0;
    private boolean isGround = false;
    private int groundTime = 0;
    private int secondAttackChargeTime = 0;
    private static final int SECONDATTACKCHARGEMAXTIME = 145;

    public IgnisKnight(Level world) {
        super(EntityInit.ignisKnight, world);
    }

    public IgnisKnight(EntityType<IgnisKnight> enType, Level world) {
        super(enType, world);
        this.f_21342_ = new IKMoveControl(this);
        this.f_21364_ = 500;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22279_, 0.32).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 64.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(ATTACK_TYPE, 0);
        this.define(ARMOR, 0);
        this.define(RUSH, false);
        this.define(SWING, false);
        this.define(ATTACK, false);
        this.define(BLAST, false);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new MoveTowards(this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new AbstractSMBoss.SMRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_11936_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_11936_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_11936_;
    }

    public float m_6121_() {
        return 0.75f;
    }

    public int getAttackType() {
        return (Integer)this.get(ATTACK_TYPE);
    }

    public void setAttackType(int attack) {
        this.set(ATTACK_TYPE, attack);
    }

    public int getArmor() {
        return (Integer)this.get(ARMOR);
    }

    public void setArmor(int armor) {
        this.set(ARMOR, armor);
    }

    public boolean getRush() {
        return (Boolean)this.get(RUSH);
    }

    public void setRush(boolean rush) {
        this.set(RUSH, rush);
    }

    public boolean getSwing() {
        return (Boolean)this.get(SWING);
    }

    public void setSwing(boolean swing) {
        this.set(SWING, swing);
    }

    public boolean getAttack() {
        return (Boolean)this.get(ATTACK);
    }

    public void setAttack(boolean isAttack) {
        this.set(ATTACK, isAttack);
    }

    public boolean getBlast() {
        return (Boolean)this.get(BLAST);
    }

    public void setBlast(boolean isBlast) {
        this.set(BLAST, isBlast);
    }

    @Override
    public boolean isArmorEmpty() {
        return this.getArmor() <= 0;
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (this.isSMMobSRC(src)) {
            return false;
        }
        boolean isLectern = this.getLectern();
        amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, isLectern ? 8.0f : 6.0f);
        int n = this.defTime = amount > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, this.getSRC(), amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (this.getLectern()) {
            amount = this.getLecternAction(src, amount, this.getArmor());
        }
        return super.m_6469_(src, amount);
    }

    public float getLecternAction(DamageSource src, float amount, int armorSize) {
        if (armorSize > 0) {
            if (src.m_7640_() instanceof EvilArrow) {
                amount = this.getEvilDamage(amount, armorSize);
            } else {
                amount *= 0.125f;
                this.specialDamageCut(src, this.playerList, "ignis_damecut");
            }
        } else {
            this.halfHealthTeleport();
        }
        return amount;
    }

    public float getEvilDamage(float amount, int armorSize) {
        this.setArmor(armorSize - 1);
        amount = 25.0f / (float)this.getEntityList(Player.class, 80.0).size();
        this.m_5496_(SoundEvents.f_11983_, 3.0f, 1.1f);
        if (!this.isClient() && this.getArmor() <= 0 && !this.playerList.isEmpty()) {
            this.sendMSG(this.playerList, (Component)this.getText("ignis_break").m_130940_(GREEN));
        }
        return amount;
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("armor", this.getArmor());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setArmor(tags.m_128451_("armor"));
        if (!this.getLectern()) {
            this.setBossEvent(BC_BLUE, NOTCHED_6);
        }
    }

    @Override
    public SpawnGroupData finalizeSpawn(ISMMob.SpawnInfo info) {
        this.startInfo();
        return super.finalizeSpawn(info);
    }

    @Override
    public void startInfo() {
        super.startInfo();
        this.setArmor(4 * Math.min(1, this.getEntityList(Player.class, 80.0).size()));
        this.setHealthArmorCount(this.getHealthArmorCount() + 1);
    }

    @Override
    public float getBuffPower() {
        int armorCount;
        float damage = super.getBuffPower();
        if (!this.getLectern()) {
            damage += 10.0f;
            damage *= 1.25f;
        }
        if ((armorCount = this.getMaxHealthArmorCount()) > 0) {
            damage *= 1.0f + (float)armorCount * 0.5f;
        }
        return damage;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            int attackType = this.getAttackType();
            this.clearInfo();
            this.setAttackType(attackType);
            return;
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        if (this.recastTime-- > 0) {
            return;
        }
        if (!this.isHalfHealth((LivingEntity)this)) {
            this.firstPhaseSttack(target);
        } else {
            this.secondPhaseSttack(target);
        }
    }

    public void firstPhaseSttack(LivingEntity target) {
        this.setAttack(true);
        boolean isPlayer = this.isPlayer((Entity)target);
        if (this.entityList.isEmpty()) {
            this.entityList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer), 32.0);
        }
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = target.m_20189_() - this.m_20189_();
        this.m_146922_(-((float)Math.atan2(d1, d2)) * 57.295776f);
        this.f_20883_ = this.m_146908_();
        this.f_20885_ = this.m_146908_();
        if (this.firstAttackChargeTime++ < 135) {
            return;
        }
        if (this.firstAttackChargeTime == 135) {
            this.setAttackType(this.rand.nextInt(2));
            if (this.entityList.size() > 1) {
                this.entityList = this.entityList.stream().sorted((s1, s2) -> this.sortEntity((Entity)this, (Entity)s1, (Entity)s2)).toList();
            }
        }
        switch (this.getAttackType()) {
            case 0: {
                this.rushAttack(target, isPlayer);
                break;
            }
            case 1: {
                this.hammerGroundwork(target, isPlayer);
            }
        }
    }

    public void secondPhaseSttack(LivingEntity target) {
        this.setAttackType(2);
        this.setAttack(true);
        boolean isPlayer = this.isPlayer((Entity)target);
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = target.m_20189_() - this.m_20189_();
        this.m_146922_(-((float)Math.atan2(d1, d2)) * 57.295776f);
        this.f_20883_ = this.m_146908_();
        this.f_20885_ = this.m_146908_();
        if (this.secondAttackChargeTime++ < 145) {
            return;
        }
        if (this.entityList.isEmpty()) {
            this.entityList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer), 24.0);
            if (this.entityList.size() > 1) {
                this.entityList = this.entityList.stream().sorted((s1, s2) -> this.sortEntity((Entity)this, (Entity)s1, (Entity)s2)).toList();
            }
        }
        if (this.secondAttackChargeTime >= 145) {
            this.hammerBlast(target, isPlayer);
        }
    }

    public void rushAttack(LivingEntity target, boolean isPlayer) {
        if (!this.getRush()) {
            this.setRush(true);
            this.setSwing(true);
            return;
        }
        if (this.firstAttackTime++ < 15) {
            return;
        }
        this.setSwing(false);
        this.setRush(false);
        this.m_5496_(SoundEvents.f_11669_, 1.0f, 1.0f);
        float damage = 10.0f + this.getBuffPower();
        float shotSpeed = 0.5f;
        int shotRange = 50;
        int count = 5 + this.targetCount * 2;
        int angle = 12 * (count - 1) / 2;
        for (int i = 0; i < count; ++i) {
            FireMagicShot entity = new FireMagicShot((LivingEntity)this);
            double x = target.m_20185_() - this.m_20185_();
            double z = target.m_20189_() - this.m_20189_();
            double y = target.m_20227_(0.3333333333333333) - this.m_20186_();
            Vector3f vec = this.getShotVector((Mob)this, new Vec3(x, y, z), -angle + i * angle / 2);
            entity.m_6686_(vec.x(), vec.y(), vec.z(), shotSpeed, 1.0f);
            entity.setAddDamage(entity.getAddDamage() + damage);
            entity.setMaxLifeTime(shotRange);
            entity.setRange(2.5);
            this.addEntity((Entity)entity);
        }
        if (this.targetCount++ >= 3) {
            this.clearInfo();
        } else {
            this.firstAttackTime = 0;
        }
    }

    public void hammerGroundwork(LivingEntity target, boolean isPlayer) {
        Level level;
        ++this.tickTime;
        if (this.tickTime == 1) {
            this.setSwing(true);
        } else if (this.tickTime == 2) {
            this.setSwing(false);
        } else if (this.tickTime == 6) {
            this.m_5496_(SoundEvents.f_11669_, 1.0f, 1.0f);
        }
        if (this.tickTime < 15 || this.tickTime % 3 != 0) {
            return;
        }
        this.m_5496_(SoundEvents.f_11874_, 1.0f, 1.0f);
        float rate = (float)(this.tickTime - 15) / 15.0f;
        BlockPos pos = this.m_20183_();
        BlockPos targetPos = target.m_20183_();
        double x = (float)(targetPos.m_123341_() - pos.m_123341_()) * rate;
        double y = (float)(targetPos.m_123342_() - pos.m_123342_()) * rate;
        double z = (float)(targetPos.m_123343_() - pos.m_123343_()) * rate;
        BlockPos attackPos = new BlockPos(pos.m_123341_() + (int)x, pos.m_123342_() + (int)y, pos.m_123343_() + (int)z);
        this.m_9236_().m_5594_(null, attackPos, SoundEvents.f_11874_, SoundSource.HOSTILE, 1.0f, 1.0f);
        List<LivingEntity> attackList = this.getEntityList(LivingEntity.class, attackPos, 2.0).stream().filter(this.getFilterList(isPlayer)).toList();
        this.targetList.addAll(attackList);
        float amount = this.setDamage(this.tickTime >= 30 ? 8.5f : 6.0f);
        attackList.forEach(e -> this.attackDamage((Entity)e, this.getSRC(), e instanceof Enemy ? amount * 4.0f : amount));
        if (this.tickTime >= 30 || !target.m_6084_()) {
            this.entityList = this.entityList.stream().filter(e -> e.m_6084_()).toList();
            if (this.entityList.isEmpty() || this.targetCount++ >= this.entityList.size()) {
                this.clearInfo();
            } else {
                this.m_6710_(this.entityList.get(0));
                this.firstAttackTime = 0;
            }
        }
        if (!((level = this.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        for (int i = 0; i < 4; ++i) {
            this.spawnParticleRing(server, (ParticleOptions)ParticleTypes.f_123745_, 1.0, new BlockPos(attackPos.m_123341_(), attackPos.m_123342_() - 2 + i, attackPos.m_123343_()), 1.25, 0.25, 0.0);
        }
    }

    public void hammerBlast(LivingEntity target, boolean isPlayer) {
        block20: {
            block21: {
                Level level;
                block19: {
                    ++this.tickTime;
                    this.setBlast(true);
                    if (this.tickTime != 10) break block19;
                    BlockPos beforePos = this.m_20183_();
                    this.m_6021_(target.m_20185_(), target.m_20186_() + 5.0, target.m_20189_());
                    this.teleportParticle((ParticleOptions)ParticleTypes.f_123745_, this.m_9236_(), beforePos, this.m_20183_());
                    break block20;
                }
                if (this.tickTime <= 10 || this.tickTime > 50) break block21;
                Vec3 vec = this.m_20184_();
                if (vec.f_82480_ < 0.0) {
                    this.m_20256_(new Vec3(0.0, 0.0, 0.0));
                }
                if (this.tickTime == 50) {
                    this.setSwing(true);
                }
                if ((level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel sever = (ServerLevel)level;
                    for (int i = 0; i < 4; ++i) {
                        float x = (float)this.m_20185_() + this.getRandFloat(0.5f);
                        float y = (float)this.m_20186_() + this.getRandFloat(0.5f);
                        float z = (float)this.m_20189_() + this.getRandFloat(0.5f);
                        float aX = this.getRandFloat(0.75f);
                        float aY = 0.1f + this.rand.nextFloat() * 0.2f;
                        float aZ = this.getRandFloat(0.75f);
                        sever.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)x, (double)y, (double)z, 0, (double)aX, (double)aY, (double)aZ, 1.0);
                    }
                }
                if (this.tickTime != 11 && this.tickTime != 41) break block20;
                double range = 10.0 + (double)this.entityList.size() * 0.5;
                for (int i = 1; i <= 4; ++i) {
                    this.spawnParticleCycle(this.m_20183_().m_6625_(4), range * 0.25 * (double)i);
                }
                break block20;
            }
            if (this.tickTime > 50) {
                Level x2;
                if (!this.m_20096_()) {
                    this.m_20256_(new Vec3(0.0, -1.5, 0.0));
                    return;
                }
                if (!this.isGround) {
                    this.isGround = true;
                    float amount = this.setDamage(10.0f);
                    double range = 10.0 + (double)this.entityList.size() * 0.5;
                    List<LivingEntity> attackList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer, range), range);
                    attackList.forEach(e -> this.attackDamage((Entity)e, this.getSRC(), e instanceof Enemy ? amount * 4.0f : amount));
                    this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
                    this.entityList = this.entityList.stream().filter(e -> e.m_6084_()).toList();
                    if (this.entityList.isEmpty()) {
                        this.clearInfo();
                    } else {
                        this.m_6710_(this.entityList.get(0));
                        this.firstAttackTime = 0;
                    }
                    Level z = this.m_9236_();
                    if (!(z instanceof ServerLevel)) {
                        return;
                    }
                    ServerLevel sever = (ServerLevel)z;
                    float x2 = (float)this.m_20185_() + this.getRandFloat(0.5f);
                    float y = (float)this.m_20186_() + this.getRandFloat(0.5f);
                    float z2 = (float)this.m_20189_() + this.getRandFloat(0.5f);
                    for (int i = 0; i < 16; ++i) {
                        sever.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)x2, (double)y, (double)z2, 4, 0.0, 0.0, 0.0, (double)0.15f);
                    }
                    sever.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                    return;
                }
                if (this.groundTime++ < 19 || this.groundTime % 20 != 0) {
                    return;
                }
                float amount = this.setDamage(3.0f);
                double ran = 14.0 + (double)this.entityList.size() * 2.0;
                List<LivingEntity> attackList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer, ran), ran);
                attackList.forEach(e -> this.attackDamage((Entity)e, this.getSRC(), e instanceof Enemy ? amount * 4.0f : amount));
                this.m_5496_(SoundEvents.f_11705_, 1.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
                this.entityList = this.entityList.stream().filter(e -> e.m_6084_()).toList();
                if (this.entityList.isEmpty()) {
                    this.clearInfo();
                } else {
                    this.m_6710_(this.entityList.get(0));
                    this.firstAttackTime = 0;
                }
                if (this.groundTime >= 60) {
                    this.clearInfo();
                }
                if (!((x2 = this.m_9236_()) instanceof ServerLevel)) {
                    return;
                }
                ServerLevel sever = (ServerLevel)x2;
                BlockPos pos = this.m_20183_();
                for (int range = 0; range < 3; ++range) {
                    for (int i = 0; i < 3; ++i) {
                        this.spawnParticleRing(sever, (ParticleOptions)ParticleTypes.f_123745_, 2 + range * 4, pos, -0.25 + (double)i * 0.5);
                    }
                }
            }
        }
    }

    public void contactDamage(boolean isPlayer, float amount, double range) {
        List<LivingEntity> targetList = this.getEntityList(LivingEntity.class, this.getFilterList(isPlayer), range);
        if (targetList.isEmpty()) {
            return;
        }
        for (LivingEntity target : targetList) {
            this.attackDamage((Entity)target, this.getSRC(), target instanceof Enemy ? amount * 3.0f : amount);
            Level level = this.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel sever = (ServerLevel)level;
            BlockPos pos = target.m_20183_();
            float x = (float)pos.m_123341_() + this.getRandFloat(0.5f);
            float y = (float)pos.m_123342_() + this.getRandFloat(0.5f);
            float z = (float)pos.m_123343_() + this.getRandFloat(0.5f);
            for (int i = 0; i < 16; ++i) {
                sever.m_8767_((ParticleOptions)ParticleTypes.f_123797_, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, 1.0);
            }
        }
        this.targetList.addAll(targetList);
        this.m_5496_(SoundEvents.f_11669_, 1.0f, 1.0f);
    }

    public float setDamage(float amount) {
        amount = this.isArmorEmpty() ? amount * 1.25f : amount;
        return (this.getHard() ? amount * 2.0f : amount) + this.getBuffPower();
    }

    @Override
    public void clearInfo() {
        this.setAttackType(this.isHalfHealth((LivingEntity)this) ? 2 : this.rand.nextInt(2));
        this.recastTime = this.getHard() ? 25 : 75 + this.rand.nextInt(50);
        this.groundTime = 0;
        this.tickTime = 0;
        this.firstAttackTime = 0;
        this.targetCount = 0;
        this.secondAttackChargeTime = 0;
        this.firstAttackChargeTime = 0;
        this.entityList = new ArrayList<LivingEntity>();
        this.targetList = new ArrayList<LivingEntity>();
        this.isGround = false;
        this.setSwing(false);
        this.setRush(false);
        this.setAttack(false);
        this.setBlast(false);
    }

    public Predicate<LivingEntity> getFilterList(boolean isPlayer) {
        return e -> !e.m_5833_() && e.m_6084_() && !this.targetList.contains(e) && (isPlayer ? e instanceof Player || e instanceof AbstractSummonMob : !(e instanceof Player)) && !(e instanceof ISMMob);
    }

    public Predicate<LivingEntity> getFilter(boolean isPlayer, double range) {
        return e -> !e.m_5833_() && e.m_6084_() && this.checkDistances(this.m_20183_(), e.m_20183_(), range * range) && (isPlayer ? e instanceof Player || e instanceof AbstractSummonMob : !(e instanceof Player)) && !(e instanceof ISMMob);
    }

    public class IKMoveControl
    extends MoveControl {
        public IgnisKnight ignis;

        public IKMoveControl(IgnisKnight mob) {
            super((Mob)mob);
            this.ignis = mob;
        }

        public void m_8126_() {
            if (this.ignis.getAttack()) {
                return;
            }
            super.m_8126_();
        }
    }

    public class MoveTowards
    extends MoveTowardsRestrictionGoal {
        public IgnisKnight ignis;

        public MoveTowards(IgnisKnight ignis, double par1) {
            super((PathfinderMob)ignis, par1);
            this.ignis = ignis;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.ignis.getAttack();
        }
    }
}

