/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.EvilArrow;
import sweetmagic.init.entity.projectile.FrostMagicShot;
import sweetmagic.util.SMDamage;
import sweetmagic.util.WorldHelper;

public class QueenFrost
extends AbstractSMBoss {
    private int recastTime = 0;
    private int attackType = 0;
    private int frostRainTime = 0;
    private int chargeTime = 0;
    private int laserTime = 0;
    private static final int FROSTRAIN_MAXTIME = 70;
    private static final int CHARGE_MAXTIME = 80;
    private static final int LASER_MAXTIME = 15;
    private int leserTotalTime = 0;
    private BlockPos pos = null;
    private BlockPos targetOldPos = null;
    private Vec3 look = this.m_20252_(1.0f);
    private List<Player> playerList = new ArrayList<Player>();
    private static final EntityDataAccessor<Integer> ARMOR = ISMMob.setData(QueenFrost.class, INT);
    private static final EntityDataAccessor<Boolean> LASER = ISMMob.setData(QueenFrost.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> LECTERN = ISMMob.setData(QueenFrost.class, BOOLEAN);
    private static final EntityDataAccessor<Boolean> MAGIC = ISMMob.setData(QueenFrost.class, BOOLEAN);

    public QueenFrost(Level world) {
        super(EntityInit.queenFrost, world);
    }

    public QueenFrost(EntityType<QueenFrost> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 400;
        this.m_274367_(1.25f);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 64.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(ARMOR, 0);
        this.define(LASER, false);
        this.define(LECTERN, false);
        this.define(MAGIC, false);
    }

    public boolean m_21533_() {
        return super.m_21533_() || this.isLaser();
    }

    protected SoundEvent m_7515_() {
        return SoundInit.QUEEN_VOICE;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundInit.QUEEN_DAME;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.QUEEN_DAME;
    }

    public float m_6121_() {
        return 0.25f;
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (this.isSMMobSRC(src)) {
            return false;
        }
        boolean isLectern = this.getLectern();
        amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, isLectern ? 10.0f : 7.5f);
        int n = this.defTime = amount > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, this.getSRC(), amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        if (isLectern) {
            this.getLecternAction(src, amount, this.getArmor());
        }
        return super.m_6469_(src, amount);
    }

    public float getLecternAction(DamageSource src, float amount, int armorSize) {
        if (armorSize > 0) {
            if (src.m_7640_() instanceof EvilArrow) {
                this.getEvilDamage(amount, armorSize);
            } else {
                amount *= 0.25f;
                this.specialDamageCut(src, this.playerList, "queen_damecut");
            }
        } else {
            this.halfHealthTeleport();
        }
        return amount;
    }

    public float getEvilDamage(float amount, int armorSize) {
        this.setArmor(armorSize - 1);
        amount = 25.0f / (float)this.getEntityList(Player.class, 80.0).size();
        this.m_5496_(SoundEvents.f_11983_, 3.0f, 1.1f);
        if (!this.isClient() && this.getArmor() <= 0 && !this.playerList.isEmpty()) {
            this.sendMSG(this.playerList, (Component)this.getText("queen_break").m_130940_(GREEN));
        }
        return amount;
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("armor", this.getArmor());
        tags.m_128405_("recastTime", this.recastTime);
        tags.m_128405_("attackType", this.attackType);
        tags.m_128405_("frostRainTime", this.frostRainTime);
        tags.m_128405_("chargeTime", this.chargeTime);
        tags.m_128405_("laserTime", this.laserTime);
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setArmor(tags.m_128451_("armor"));
        this.recastTime = tags.m_128451_("recastTime");
        this.attackType = tags.m_128451_("attackType");
        this.frostRainTime = tags.m_128451_("frostRainTime");
        this.chargeTime = tags.m_128451_("chargeTime");
        this.laserTime = tags.m_128451_("laserTime");
        if (!this.getLectern()) {
            this.setBossEvent(BC_BLUE, NOTCHED_6);
        }
    }

    public int getArmor() {
        return (Integer)this.get(ARMOR);
    }

    public void setArmor(int size) {
        this.set(ARMOR, size);
    }

    public boolean isLaser() {
        return (Boolean)this.get(LASER);
    }

    @Override
    public boolean isArmorEmpty() {
        return this.getArmor() <= 0;
    }

    @Override
    public SpawnGroupData finalizeSpawn(ISMMob.SpawnInfo info) {
        this.startInfo();
        return super.finalizeSpawn(info);
    }

    @Override
    public void startInfo() {
        super.startInfo();
        this.setArmor(3 * this.getEntityList(Player.class, 80.0).size());
        this.setHealthArmorCount(this.getHealthArmorCount() + 1);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isClient()) {
            Vec3 vec = this.m_20184_();
            float x = (float)this.m_20185_() - 0.5f + this.rand.nextFloat();
            float y = (float)this.m_20186_() + 1.0f;
            float z = (float)this.m_20189_() - 0.5f + this.rand.nextFloat();
            float f1 = (float)((vec.f_82479_ + 0.5 - (double)this.rand.nextFloat()) * (double)0.2f);
            float f2 = 0.0f;
            float f3 = (float)((vec.f_82481_ + 0.5 - (double)this.rand.nextFloat()) * (double)0.2f);
            this.m_9236_().m_7106_((ParticleOptions)ParticleInit.FROST, (double)x, (double)y, (double)z, (double)f1, (double)f2, (double)f3);
        }
        BlockPos spawnPos = this.getSpawnPos();
        if (this.f_19797_ % 20 == 0 && spawnPos != null && this.m_20275_(spawnPos.m_123341_(), spawnPos.m_123342_(), spawnPos.m_123343_()) >= 2000.0) {
            this.teleport();
        }
    }

    @Override
    protected boolean teleport() {
        BlockPos pos = this.getSpawnPos();
        if (!this.isClient() && this.m_6084_() && pos != null) {
            double x = (double)pos.m_123341_() + (this.rand.nextDouble() - 0.5) * 32.0;
            double y = (double)pos.m_123342_() + (double)(this.rand.nextInt(8) - 4);
            double z = (double)pos.m_123343_() + (this.rand.nextDouble() - 0.5) * 32.0;
            return this.teleport(x, y, z);
        }
        return false;
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return;
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        if (this.recastTime-- > 0) {
            return;
        }
        if (!this.isHalfHealth((LivingEntity)this)) {
            this.firstPhaseSttack(target);
        } else {
            this.secondPhaseSttack(target);
        }
    }

    public void firstPhaseSttack(LivingEntity target) {
        boolean isPlayer = this.isPlayer((Entity)target);
        if (this.attackType == 0) {
            this.frostSpia(isPlayer);
        } else {
            this.frostRain(target, isPlayer);
        }
    }

    public void secondPhaseSttack(LivingEntity target) {
        Level i2;
        Vec3 dest;
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = target.m_20189_() - this.m_20189_();
        this.m_146922_(-((float)Math.atan2(d1, d2)) * 57.295776f);
        this.f_20883_ = this.m_146908_();
        this.f_20885_ = this.m_146908_();
        float damage = this.getBuffPower() * 0.25f;
        boolean isPlayer = target instanceof Player;
        ++this.tickTime;
        this.set(LASER, true);
        List<Player> targetPlayerList = this.getPlayer(Player.class);
        if (this.leserTotalTime == 0) {
            this.leserTotalTime = targetPlayerList.size() * 15;
        }
        if (this.leserTotalTime % 15 == 0 && targetPlayerList.size() >= 2) {
            target = (LivingEntity)targetPlayerList.get(this.rand.nextInt(targetPlayerList.size() - 1));
            this.m_6710_(target);
        }
        if (this.tickTime % 15 == 0 || this.targetOldPos == null) {
            this.targetOldPos = target.m_20183_();
            this.look = this.m_20252_(1.0f);
        }
        Vec3 src = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82520_(0.0, (double)this.m_20192_(), 0.0);
        if (this.tickTime % 6 == 0) {
            this.m_5496_(SoundInit.LASER, 0.3f, 1.0f);
        }
        if (this.tickTime % 8 == 0) {
            ArrayList<LivingEntity> entityAllList = new ArrayList<LivingEntity>();
            ++this.laserTime;
            for (double i2 = 0.0; i2 < 30.0; i2 += 0.5) {
                dest = src.m_82520_(this.look.f_82479_ * i2, this.look.f_82480_ * i2, this.look.f_82481_ * i2);
                List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer, entityAllList), dest, 1.0);
                entityAllList.addAll(entityList);
                this.attackDamage(entityList, this.getDamage((Entity)this, SMDamage.flostDamage), 1.0f + damage);
            }
        }
        if ((i2 = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)i2;
            BlockPos p = this.targetOldPos.m_7495_();
            for (int i3 = 0; i3 < 20; ++i3) {
                if (this.rand.nextFloat() >= 0.65f) continue;
                dest = src.m_82520_(this.look.f_82479_ * (double)i3, this.look.f_82480_, this.look.f_82481_ * (double)i3);
                float f1 = (float)dest.f_82479_ - 0.5f + this.rand.nextFloat();
                float f2 = (float)dest.f_82480_ - 1.0f + this.rand.nextFloat();
                float f3 = (float)dest.f_82481_ - 0.5f + this.rand.nextFloat();
                float x = (float)((double)p.m_123341_() - this.m_20185_()) / 10.0f;
                float y = (float)((double)p.m_123342_() - this.m_20186_()) / 10.0f;
                float z = (float)((double)p.m_123343_() - this.m_20189_()) / 10.0f;
                server.m_8767_((ParticleOptions)ParticleInit.FROST_LASER, (double)f1, (double)f2, (double)f3, 0, (double)x, (double)y, (double)z, 1.0);
            }
        }
        if (this.laserTime >= 15) {
            this.clearInfo();
        }
    }

    public void frostSpia(boolean isPlayer) {
        int level = 5;
        float damage = this.getBuffPower();
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer, false), 32.0);
        for (LivingEntity living : entityList) {
            double x = living.m_20185_() - this.m_20185_();
            double y = living.m_20227_(0.3333333333333333) - this.m_20186_() - (double)this.m_20192_() / 2.0;
            double z = living.m_20189_() - this.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            FrostMagicShot entity = new FrostMagicShot((LivingEntity)this);
            entity.setHitDead(false);
            entity.setData(1);
            entity.setWandLevel(level);
            entity.m_6686_(x, y - xz * 0.035, z, 3.0f, 0.0f);
            entity.setAddDamage(entity.getAddDamage() - 3.0f + damage);
            this.addEntity((Entity)entity);
        }
        this.recastTime = (int)((float)(this.rand.nextInt(40) + 40) * (this.isHalfHealth((LivingEntity)this) ? 0.75f : 1.0f));
        this.attackType = this.rand.nextInt(2);
    }

    public void frostRain(LivingEntity target, boolean isPlayer) {
        if (this.chargeTime % 10 == 0) {
            this.spawnParticleCycle(target);
        }
        if (this.chargeTime++ >= 80) {
            ++this.frostRainTime;
            int level = 2;
            float damage = this.getBuffPower();
            if (this.pos == null) {
                this.pos = target.m_20183_();
            }
            for (int i = 0; i < 4; ++i) {
                BlockPos targetPos = WorldHelper.offset(this.pos, this.rand.nextInt(10) - this.rand.nextInt(10), 10.0, this.rand.nextInt(10) - this.rand.nextInt(10));
                FrostMagicShot entity = new FrostMagicShot((LivingEntity)this);
                entity.setWandLevel(level);
                entity.m_6686_(0.0, -0.35, 0.0, 1.35f, 0.0f);
                entity.m_6034_((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 10.5, (double)targetPos.m_123343_() + 0.5);
                entity.setAddDamage(entity.getAddDamage() - 4.0f + damage);
                entity.setChangeParticle(true);
                this.addEntity((Entity)entity);
            }
            if (this.frostRainTime < 70) {
                return;
            }
            this.chargeTime = 0;
            this.frostRainTime = 0;
            this.pos = null;
            this.recastTime = (int)((float)(this.rand.nextInt(60) + 60) * (this.isHalfHealth((LivingEntity)this) ? 0.75f : 1.0f));
            this.attackType = this.rand.nextInt(2);
            List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(isPlayer, target), 32.0);
            if (entityList.size() >= 1) {
                this.m_6710_(entityList.get(this.rand.nextInt(entityList.size())));
            }
        }
    }

    @Override
    public float getBuffPower() {
        int armorCount;
        float damage = super.getBuffPower();
        if (!this.getLectern()) {
            damage += 8.0f;
            damage *= 1.25f;
        }
        if ((armorCount = this.getMaxHealthArmorCount()) > 0) {
            damage *= 1.0f + (float)armorCount * 0.75f;
        }
        return damage;
    }

    @Override
    public boolean checkDistance(BlockPos targetPos, BlockPos pos, double range) {
        return (double)Math.abs(targetPos.m_123341_() - pos.m_123341_() + targetPos.m_123343_() - pos.m_123343_()) <= range;
    }

    protected void spawnParticleCycle(LivingEntity target) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        this.pos = this.pos == null ? target.m_20183_() : this.pos;
        for (double range = 2.5; range < 10.0; range += 3.0) {
            int count = (int)(range / 3.0) + 1;
            boolean isReverse = count % 2 == 0;
            for (int i = 0; i < 6 * count; ++i) {
                this.spawnParticleCycle(server, (ParticleOptions)ParticleInit.CYCLE_FROST, (double)this.pos.m_123341_() + 0.5, (double)this.pos.m_123342_() + 0.5, (double)this.pos.m_123343_() + 0.5, Direction.UP, range, (double)(i * 60 / count) + (double)this.rand.nextFloat() * 10.0, isReverse);
            }
        }
    }

    @Override
    public void clearInfo() {
        this.laserTime = 0;
        this.tickTime = 0;
        this.chargeTime = 0;
        this.frostRainTime = 0;
        this.recastTime = this.rand.nextInt(200) + 150;
        this.attackType = this.rand.nextInt(2);
        this.set(LASER, false);
    }

    public Predicate<LivingEntity> getFilter(boolean isPlayer, boolean flag) {
        return e -> !e.m_5833_() && e.m_6084_() && (isPlayer ? e instanceof Player || e instanceof AbstractSummonMob : !(e instanceof Player)) && !(e instanceof ISMMob) && this.m_142582_((Entity)e);
    }

    public Predicate<LivingEntity> getFilter(boolean isPlayer, LivingEntity target) {
        return e -> !e.m_5833_() && e.m_6084_() && (isPlayer ? e instanceof Player || e instanceof AbstractSummonMob : !(e instanceof Player)) && target != e;
    }

    public Predicate<LivingEntity> getFilter(boolean isPlayer, List<LivingEntity> entityAllList) {
        return e -> !e.m_5833_() && e.m_6084_() && (isPlayer ? e instanceof Player || e instanceof AbstractSummonMob : !(e instanceof Player)) && !entityAllList.contains(e);
    }
}

