/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.monster.boss;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import sweetmagic.SweetMagicCore;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.animal.StellaWizard;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.monster.boss.DemonsBelial;
import sweetmagic.init.entity.projectile.CommetBulet;
import sweetmagic.init.entity.projectile.ElectricMagicShot;
import sweetmagic.init.entity.projectile.EvilArrow;
import sweetmagic.init.entity.projectile.KnifeShot;
import sweetmagic.init.entity.projectile.ShootingStar;
import sweetmagic.init.entity.projectile.TripleTornadoShot;
import sweetmagic.util.WorldHelper;

public class StellaWizardMaster
extends AbstractSMBoss {
    private static final EntityDataAccessor<Integer> ROBE_TYPE = ISMMob.setData(StellaWizardMaster.class, INT);
    private static final EntityDataAccessor<Integer> GIMMICK = ISMMob.setData(StellaWizardMaster.class, INT);
    private static final EntityDataAccessor<Boolean> DEMONS = ISMMob.setData(StellaWizardMaster.class, BOOLEAN);
    private static final ResourceLocation WIND = SweetMagicCore.getSRC("textures/armor/windwitch_master_robe.png");
    private static final ResourceLocation BLIZE = SweetMagicCore.getSRC("textures/armor/blize_robe.png");
    private static final ResourceLocation IGNIS = SweetMagicCore.getSRC("textures/armor/ignisknight_robe.png");
    private static final ResourceLocation BUTLER = SweetMagicCore.getSRC("textures/armor/butler_robe.png");
    private int summonCometTime = 150;
    private static final int MAX_SUMMON_COMET_TIME = 300;
    private int cometShotTime = 0;
    private static final int MAX_COMET_SHOT_TIME = 200;
    private int evilShotTime = 100;
    private static final int MAX_EVIL_SHOT_TIME = 400;
    private int shootingStarTime = 200;
    private static final int MAX_SHOOTINGSTAR_TIME = 400;
    private Map<Integer, BlockPos> posMap = new HashMap<Integer, BlockPos>();
    private int robeCount = 0;
    private int robeTime = 0;
    private int maxRobeTime = 0;

    public StellaWizardMaster(Level world) {
        super(EntityInit.stellaWizardMaster, world);
    }

    public StellaWizardMaster(EntityType<StellaWizardMaster> enType, Level world) {
        super(enType, world);
        this.f_21364_ = 800;
        this.setBossEvent(BC_BLUE, NOTCHED_6);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 768.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22278_, 96.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(ROBE_TYPE, -1);
        this.define(GIMMICK, 0);
        this.define(DEMONS, false);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Warden.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new AbstractSMBoss.SMRandomLookGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Warden.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12548_;
    }

    protected SoundEvent m_7975_(DamageSource src) {
        return SoundEvents.f_12552_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12550_;
    }

    public int getRobeType() {
        return (Integer)this.get(ROBE_TYPE);
    }

    public void setRobeType(int robeType) {
        this.set(ROBE_TYPE, robeType);
    }

    public int getGimmick() {
        return (Integer)this.get(GIMMICK);
    }

    public void setGimmick(int gimmick) {
        this.set(GIMMICK, gimmick);
    }

    public boolean getDemons() {
        return (Boolean)this.get(DEMONS);
    }

    public void setDemons(boolean demons) {
        this.set(DEMONS, demons);
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("robeType", this.getRobeType());
        tags.m_128405_("gimmick", this.getGimmick());
        tags.m_128379_("demons", this.getDemons());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setRobeType(tags.m_128451_("robeType"));
        this.setGimmick(tags.m_128451_("gimmick"));
        this.setDemons(tags.m_128471_("demons"));
    }

    @Override
    public boolean m_6469_(DamageSource src, float amount) {
        float cap;
        Entity attacker = src.m_7639_();
        Entity attackEntity = src.m_7640_();
        if (this.isSMMobSRC(src)) {
            return false;
        }
        float f = cap = this.getDemons() ? 3.0f : 6.0f;
        if (this.getGimmick() > 0) {
            cap += (float)this.getGimmick() * 1.5f;
        }
        amount = this.getBossDamageAmount((Entity)this, this.defTime, src, amount, this.getHealthArmor() > 0.0f ? cap * 0.75f : cap);
        int n = this.defTime = amount > 0.0f ? 2 : this.defTime;
        if (attacker instanceof Warden) {
            this.attackDamage(attacker, this.getSRC(), amount);
            return false;
        }
        if (this.notMagicDamage(attacker, attackEntity)) {
            amount *= 0.25f;
        }
        return super.m_6469_(src, amount);
    }

    @Override
    protected void halfHealthAction(LivingEntity target) {
        float healthArmor = this.getHealthArmor();
        if (healthArmor > 0.0f) {
            return;
        }
        int count = this.getHealthArmorCount();
        if (count > 0) {
            this.armorHealthSet(target, 1);
            this.setHealthArmorCount(count - 1);
            this.setRobeType(this.getHealthArmorCount());
        }
        if (count <= 0) {
            this.setHalfHealth(true);
        }
    }

    @Override
    public MutableComponent getArmorName() {
        String name = "";
        switch (this.getRobeType()) {
            case 0: {
                name = "blize_robe";
                break;
            }
            case 1: {
                name = "ifrite_robe";
                break;
            }
            case 2: {
                name = "windwitch_master_robe";
                break;
            }
            case 3: {
                name = "butler_robe";
            }
        }
        return this.getTip("item.sweetmagic." + name);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        LivingEntity target = this.m_5448_();
        if (target == null) {
            this.clearInfo();
            return;
        }
        this.m_21563_().m_24960_((Entity)target, 10.0f, 10.0f);
        this.firstAttack(target);
        if (this.isHalfHealth((LivingEntity)this)) {
            this.secondAttack(target);
        }
    }

    public void firstAttack(LivingEntity target) {
        if (this.summonCometTime++ >= 300) {
            this.summonComet(target);
        }
        if (this.cometShotTime++ >= 200) {
            this.cometShot(target);
        }
        if (this.evilShotTime++ >= 400) {
            this.evilShot(target);
        }
    }

    public void secondAttack(LivingEntity target) {
        int robeType = this.getRobeValue();
        if (robeType != -1) {
            this.robeAttack(target, robeType);
        } else if (this.shootingStarTime++ >= 400) {
            this.shootingStarShot(target);
        }
    }

    public void summonComet(LivingEntity target) {
        this.summonCometTime = 0;
        Level world = this.m_9236_();
        List<LivingEntity> targetList = this.getPlayerList(target);
        if (targetList.isEmpty()) {
            return;
        }
        boolean isWarden = target instanceof Warden;
        float dama = (float)this.m_21133_(Attributes.f_22281_) + (isWarden ? 50.0f : 30.0f);
        float dameRate = isWarden ? 1.5f : 1.0f;
        int level = isWarden ? 50 : 20;
        int summonSize = Math.min(3, Math.max(1, 45 / Math.max(1, targetList.size())));
        for (LivingEntity entity : targetList) {
            double x = entity.m_20185_() - this.m_20185_();
            double y = entity.m_20227_(0.3333333333333333) - this.m_20186_();
            double z = entity.m_20189_() - this.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            for (int i = 0; i < summonSize; ++i) {
                CommetBulet magic = new CommetBulet((LivingEntity)this);
                magic.setWandLevel(level);
                magic.m_6686_(x, y - xz * 0.065, z, 2.0f, 0.0f);
                magic.setAddDamage((magic.getAddDamage() + dama) * dameRate);
                magic.setTarget((Entity)entity);
                magic.setCharge(true);
                magic.m_20256_(new Vec3(0.0, 0.0, 0.0));
                this.addEntity((Entity)magic);
            }
        }
    }

    public void cometShot(LivingEntity target) {
        this.summonCometTime = 200;
        List<CommetBulet> commetList = this.getEntityList(CommetBulet.class, (T e) -> e.m_19749_() == this && e.getCharge(), 64.0);
        if (!commetList.isEmpty()) {
            commetList.get(0).setCharge(false);
            this.cometShotTime = 196;
        } else {
            this.cometShotTime = 0;
        }
    }

    public void evilShot(LivingEntity target) {
        this.evilShotTime = 0;
        List<LivingEntity> targetList = this.getPlayerList(target);
        for (LivingEntity entity : targetList) {
            double x = entity.m_20185_() - this.m_20185_();
            double y = entity.m_20227_(0.3333333333333333) - this.m_20186_();
            double z = entity.m_20189_() - this.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            EvilArrow magic = new EvilArrow((LivingEntity)this);
            magic.m_6686_(x, y - xz * 0.065, z, 2.0f, 0.0f);
            magic.isDrop = entity instanceof Player;
            this.addEntity((Entity)magic);
        }
    }

    public void robeAttack(LivingEntity target, int robeType) {
        switch (robeType) {
            case 0: {
                this.maxRobeTime = 240;
                this.blitzAttack(target);
                break;
            }
            case 1: {
                this.maxRobeTime = 150;
                this.ignisAttack(target);
                break;
            }
            case 2: {
                this.maxRobeTime = 200;
                this.windWitchAttack(target);
                break;
            }
            case 3: {
                this.maxRobeTime = 140;
                this.butlerAttack(target);
            }
        }
    }

    public void blitzAttack(LivingEntity target) {
        if (this.robeTime++ < this.maxRobeTime || this.f_19797_ % 20 != 0) {
            return;
        }
        boolean isWarden = target instanceof Warden;
        float damage = isWarden ? 50.0f : 7.5f;
        int angle = 15 + this.f_19797_ / 20;
        int rangeMax = 16;
        for (int i = 0; i < rangeMax; ++i) {
            ElectricMagicShot entity = new ElectricMagicShot((LivingEntity)this);
            double x = target.m_20185_() - this.m_20185_();
            double z = target.m_20189_() - this.m_20189_();
            double y = 0.0;
            Vector3f vec = this.getShotVector((Mob)this, new Vec3(x, y, z), 360 / rangeMax * (i + 1) + angle);
            entity.m_6686_(vec.x(), vec.y(), vec.z(), 0.875f, 1.75f);
            entity.setAddDamage(entity.getAddDamage() + damage);
            entity.setMaxLifeTime(40);
            entity.setRange(3.5);
            entity.setHitDead(false);
            entity.setNotDamage(true);
            entity.isRangeAttack = true;
            this.addEntity((Entity)entity);
        }
        this.m_5496_(SoundEvents.f_11705_, 0.5f, 0.67f);
        if (this.robeCount++ >= 3) {
            this.robeTime = 0;
            this.robeCount = 0;
        }
    }

    public void ignisAttack(LivingEntity target) {
        block18: {
            List<LivingEntity> entityList;
            Level world;
            block19: {
                block17: {
                    if (this.robeTime++ < this.maxRobeTime) {
                        return;
                    }
                    world = this.m_9236_();
                    entityList = this.getPlayerList(target);
                    if (this.robeTime != this.getMaxTime(10)) break block17;
                    BlockPos beforePos = this.m_20183_();
                    this.m_6021_(target.m_20185_(), target.m_20186_() + 5.0, target.m_20189_());
                    this.teleportParticle((ParticleOptions)ParticleTypes.f_123745_, world, beforePos, this.m_20183_());
                    break block18;
                }
                if (this.robeTime <= this.getMaxTime(10) || this.robeTime > this.getMaxTime(50)) break block19;
                Vec3 vec = this.m_20184_();
                if (vec.f_82480_ < 0.0) {
                    this.m_20256_(new Vec3(0.0, 0.0, 0.0));
                }
                if (world instanceof ServerLevel) {
                    ServerLevel sever = (ServerLevel)world;
                    for (int i = 0; i < 4; ++i) {
                        float x = (float)this.m_20185_() + this.getRandFloat(0.5f);
                        float y = (float)this.m_20186_() + this.getRandFloat(0.5f);
                        float z = (float)this.m_20189_() + this.getRandFloat(0.5f);
                        float aX = this.getRandFloat(0.75f);
                        float aY = 0.1f + this.rand.nextFloat() * 0.2f;
                        float aZ = this.getRandFloat(0.75f);
                        sever.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)x, (double)y, (double)z, 0, (double)aX, (double)aY, (double)aZ, 1.0);
                    }
                }
                if (this.robeTime != this.getMaxTime(11) && this.robeTime != this.getMaxTime(41)) break block18;
                double range = 15.0 + (double)this.getPlayerCount(entityList) * 0.5;
                for (int i = 1; i <= 4; ++i) {
                    this.spawnParticleCycle(this.m_20183_().m_6625_(4), range * 0.25 * (double)i);
                }
                break block18;
            }
            if (this.robeTime > this.getMaxTime(50)) {
                if (!this.m_20096_()) {
                    this.m_20256_(new Vec3(0.0, -1.5, 0.0));
                } else if (this.robeCount == 0) {
                    ++this.robeCount;
                    float amount = 50.0f + this.getBuffPower();
                    double range = 15.0 + (double)this.getPlayerCount(entityList) * 0.5;
                    List<LivingEntity> attackList = this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer((Entity)target)), range);
                    attackList.forEach(e -> this.attackDamage((Entity)e, this.getSRC(), e instanceof Enemy ? amount * 8.0f : amount));
                    this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
                    if (!(world instanceof ServerLevel)) {
                        return;
                    }
                    ServerLevel sever = (ServerLevel)world;
                    sever.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                    float x = (float)this.m_20185_() + this.getRandFloat(0.5f);
                    float y = (float)this.m_20186_() + this.getRandFloat(0.5f);
                    float z = (float)this.m_20189_() + this.getRandFloat(0.5f);
                    for (int i = 0; i < 16; ++i) {
                        sever.m_8767_((ParticleOptions)ParticleTypes.f_123745_, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.15f);
                    }
                } else {
                    if (this.tickTime++ < 19 || this.tickTime % 20 != 0) {
                        return;
                    }
                    ++this.robeCount;
                    float amount = 15.0f + this.getBuffPower();
                    double ran = 20.0 + (double)this.getPlayerCount(entityList) * 2.0;
                    List<LivingEntity> attackList = this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer((Entity)target)), ran);
                    attackList.forEach(e -> this.attackDamage((Entity)e, this.getSRC(), e instanceof Enemy ? amount * 8.0f : amount));
                    this.m_5496_(SoundEvents.f_11705_, 1.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
                    if (this.robeCount > 3) {
                        this.tickTime = 0;
                        this.robeCount = 0;
                        this.robeTime = 0;
                    }
                    if (!(world instanceof ServerLevel)) {
                        return;
                    }
                    ServerLevel sever = (ServerLevel)world;
                    BlockPos pos = this.m_20183_();
                    for (int range = 0; range < 3; ++range) {
                        for (int i = 0; i < 3; ++i) {
                            this.spawnParticleRing(sever, (ParticleOptions)ParticleTypes.f_123745_, 2 + range * 4, pos, -0.25 + (double)i * 0.5);
                        }
                    }
                }
            }
        }
    }

    public void windWitchAttack(LivingEntity target) {
        if (this.robeTime++ < this.maxRobeTime) {
            return;
        }
        Level world = this.m_9236_();
        boolean isPlayer = this.isPlayer((Entity)target);
        HashMap<Integer, BlockPos> posMap = new HashMap<Integer, BlockPos>();
        List<LivingEntity> entityList = this.getPlayerList(target);
        if (entityList.isEmpty()) {
            return;
        }
        double range = Math.min(15.0, 8.0 + (double)entityList.size() * 0.325);
        int count = 0;
        int maxCount = 5;
        for (LivingEntity livingEntity : entityList) {
            posMap.put(count, livingEntity.m_20183_());
            if (++count < maxCount) continue;
            break;
        }
        if (count < maxCount) {
            int mapRange = 32;
            BlockPos blockPos = this.m_20183_();
            for (int i = count; i < 3; ++i) {
                BlockPos pos;
                while (posMap.containsValue(pos = WorldHelper.offset(blockPos, this.randRange(mapRange), 0.0, this.randRange(mapRange))) || world.m_46859_(pos.m_7495_())) {
                }
                posMap.put(i, pos);
            }
        }
        for (Map.Entry entry : posMap.entrySet()) {
            BlockPos pos = (BlockPos)entry.getValue();
            TripleTornadoShot entity = new TripleTornadoShot((LivingEntity)this);
            entity.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, 1.0f, 0.0f);
            entity.m_6686_(0.0, 0.0, 0.0, 0.0f, 0.0f);
            entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
            entity.setHitDead(false);
            entity.setNotDamage(true);
            entity.setRange(range);
            entity.setAddDamage(40.0f + this.getBuffPower());
            entity.isPlayer = isPlayer;
            this.addEntity((Entity)entity);
        }
        this.robeTime = 0;
    }

    public void butlerAttack(LivingEntity target) {
        if (this.robeTime++ < this.maxRobeTime) {
            return;
        }
        List<LivingEntity> targetList = this.getPlayerList(target);
        for (LivingEntity entity : targetList) {
            double x = entity.m_20185_() - this.m_20185_();
            double y = entity.m_20227_(0.3333333333333333) - this.m_20186_() - 0.25;
            double z = entity.m_20189_() - this.m_20189_();
            double xz = Math.sqrt(x * x + z * z);
            KnifeShot knife = new KnifeShot((LivingEntity)this);
            knife.setHitDead(false);
            knife.m_6686_(x, y - xz * 0.065, z, 1.5f, 1.5f);
            knife.setAddDamage(knife.getAddDamage() + 6.0f);
            this.addEntity((Entity)knife);
        }
        this.m_5496_(SoundInit.KNIFE_SHOT, 0.5f, 0.9f);
        this.robeTime = 0;
    }

    public void shootingStarShot(LivingEntity target) {
        if (this.shootingStarTime++ < 400) {
            return;
        }
        Level world = this.m_9236_();
        if (this.posMap.isEmpty() && this.shootingStarTime <= 402) {
            this.m_6021_(this.m_20185_(), this.m_20186_() + 6.0, this.m_20189_());
            int mapRange = 48;
            BlockPos basePos = this.m_20183_();
            int count = (int)Math.max(10.0f, 6.0f * this.getPlayerCount(target) * 0.5f);
            for (int i = 0; i < count; ++i) {
                BlockPos pos;
                while (this.posMap.containsValue(pos = WorldHelper.offset(basePos, this.randRange(mapRange), -6.0, this.randRange(mapRange))) || world.m_46859_(pos.m_7495_())) {
                }
                this.posMap.put(i, pos);
            }
        } else if (this.shootingStarTime > 400 && this.shootingStarTime <= 560) {
            double range;
            this.m_20256_(new Vec3(0.0, 0.0, 0.0));
            if (this.shootingStarTime % 30 == 0) {
                range = 12.5;
                for (BlockPos pos : this.posMap.values()) {
                    for (int i = 1; i <= 3; ++i) {
                        this.spawnParticleCycle(pos, range * (double)i / 3.0);
                    }
                }
            }
            if (!this.posMap.isEmpty()) {
                range = 12.5;
                float damage = 30.0f;
                for (Map.Entry<Integer, BlockPos> map : this.posMap.entrySet()) {
                    BlockPos pos = map.getValue().m_6630_(15);
                    ShootingStar magic = new ShootingStar((LivingEntity)this);
                    magic.setAddDamage(magic.getAddDamage());
                    magic.setRange(range);
                    magic.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, 0.0f, 0.0f);
                    magic.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
                    magic.setAddDamage(magic.getAddDamage() + damage);
                    magic.setHitDead(false);
                    magic.setCharge(true);
                    this.addEntity((Entity)magic);
                }
                this.posMap.clear();
            }
        } else if (this.shootingStarTime > 560 && this.shootingStarTime % 3 == 0) {
            this.m_20256_(new Vec3(0.0, 0.0, 0.0));
            List<ShootingStar> commetList = this.getEntityList(ShootingStar.class, (T e) -> e.m_19749_() == this && e.getCharge(), 64.0);
            if (!commetList.isEmpty()) {
                Vec3 vec = new Vec3(0.0, -1.5, 0.0);
                ShootingStar magic = commetList.get(0);
                magic.setCharge(false);
                magic.m_20256_(vec);
            } else {
                this.shootingStarTime = 0;
            }
        }
    }

    public int getMaxTime(int time) {
        return this.maxRobeTime + time;
    }

    public int getRobeValue() {
        return this.getHealthArmor() > 0.0f ? this.getRobeType() : -1;
    }

    @Override
    public void spawnAction() {
        this.setHealthArmorCount(4);
    }

    public ResourceLocation getTEX() {
        return switch (this.getRobeType()) {
            case 1 -> IGNIS;
            case 2 -> WIND;
            case 3 -> BUTLER;
            default -> BLIZE;
        };
    }

    @Override
    public void clearInfo() {
        this.robeTime = 0;
        this.robeCount = 0;
        this.shootingStarTime = 0;
        this.evilShotTime = 0;
        this.cometShotTime = 0;
        this.summonCometTime = 0;
        this.posMap.clear();
    }

    @Override
    protected void deathFinish() {
        List<Player> playerList = this.getEntityList(Player.class, 48.0);
        List<ItemEntity> entityItemList = this.getEntityList(ItemEntity.class, (T e) -> e.m_32055_().m_150930_(ItemInit.evil_arrow), 128.0);
        entityItemList.forEach(e -> e.m_146870_());
        for (Player player : playerList) {
            List<ItemStack> stackList = player.m_150109_().f_35974_.stream().filter(s -> !s.m_41619_() && s.m_150930_(ItemInit.evil_arrow)).toList();
            stackList.forEach(s -> s.m_41774_(s.m_41613_()));
        }
        if (!this.getDemons()) {
            return;
        }
        DemonsBelial belial = new DemonsBelial(this.m_9236_());
        belial.m_6034_(this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_());
        belial.setHealthArmorCount(1);
        belial.startInfo();
        belial.startInfo();
        this.addEntity((Entity)belial);
        if (playerList.isEmpty()) {
            return;
        }
        int level = 60;
        double rate = Math.max(3.5, 1.0 + (double)(level - 1) * 0.075);
        Player player = playerList.get(0);
        Vec3 src = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_()).m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 look = player.m_20252_(5.0f);
        Vec3 dest = src.m_82520_(look.f_82479_ * 3.0, player.m_20186_(), look.f_82481_ * 3.0);
        BlockPos pos = new BlockPos((int)dest.f_82479_, (int)player.m_20186_() + 1, (int)dest.f_82481_);
        StellaWizard entity = new StellaWizard(this.m_9236_());
        entity.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5);
        entity.m_21828_(player);
        entity.setWandLevel(level);
        entity.setState(rate);
        entity.setMaxLifeTime(99999);
        entity.setCrystal(true);
        entity.setDemons(true);
        entity.setCrystalHealth(128.0f);
        entity.setMaxCrystalHealth(128.0f);
        entity.m_21051_(Attributes.f_22276_).m_22100_((double)(entity.m_21233_() * 2.0f));
        entity.m_21153_(entity.m_21233_());
        this.addEntity((Entity)entity);
        if (!this.isClient()) {
            this.sendMSG(playerList, (Component)this.getText("stella_wizard_crystal").m_130940_(GREEN));
        }
    }
}

