/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.entity.monster.boss.QueenFrost;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.util.WorldHelper;

public abstract class AbstractBossMagic
extends AbstractMagicShot {
    protected int tickTime = 0;
    protected LivingEntity summon = null;
    protected LivingEntity target = null;
    private static final EntityDataAccessor<Float> ROT = AbstractBossMagic.setEntityData(EntityDataSerializers.f_135029_);

    public AbstractBossMagic(EntityType<? extends AbstractBossMagic> entityType, Level world) {
        super(entityType, world);
    }

    public AbstractBossMagic(EntityType<? extends AbstractBossMagic> entityType, double x, double y, double z, Level world) {
        this(entityType, world);
        this.m_6034_(x, y, z);
    }

    public AbstractBossMagic(EntityType<? extends AbstractBossMagic> entityType, LivingEntity entity, Level world) {
        this(entityType, entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(ROT, Float.valueOf(0.0f));
    }

    public float getRotData() {
        return this.get(ROT).floatValue();
    }

    public void setRotData(float rot) {
        this.set(ROT, Float.valueOf(rot));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(new Vec3(0.0, 0.0, 0.0));
        this.tickSpawnParticle();
        this.summonSpawnParticle();
        this.onUpdate();
        this.teleportToPlayer();
    }

    public void teleportToPlayer() {
        if (this.f_19797_ % 100 != 0 || this.target != null || this.m_19749_() == null || this.m_19749_().m_20270_((Entity)this) < 256.0f) {
            return;
        }
        this.m_6021_(this.m_19749_().m_20185_(), this.m_19749_().m_20186_(), this.m_19749_().m_20189_() + 1.0);
    }

    abstract void onUpdate();

    public void tickSpawnParticle() {
    }

    public void summonSpawnParticle() {
        Level level;
        if (this.f_19797_ != 1 || !((level = this.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        BlockPos pos = this.m_20183_();
        double range = 1.0;
        double ySpeed = 0.35;
        for (int i = 0; i < 4; ++i) {
            this.spawnParticleRing(server, (ParticleOptions)ParticleInit.NORMAL, range, pos.m_6625_(2), (double)i / 3.0, ySpeed, 0.0);
        }
    }

    public void setRotInit() {
        if (this.target == null || !this.target.m_6084_()) {
            return;
        }
        double d1 = this.target.m_20185_() - this.m_20185_();
        double d2 = this.target.m_20189_() - this.m_20189_();
        float rot = -((float)Math.atan2(d1, d2)) * 57.295776f;
        this.m_146922_(rot);
        this.setRotData(-rot);
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, AABB aabb) {
        return WorldHelper.getEntityList((Entity)this, enClass, aabb);
    }

    public AABB getAABB(double x, double y, double z, boolean flag) {
        double pX = this.m_20185_() + x;
        double pY = this.m_20186_() + y;
        double pZ = this.m_20189_() + z;
        return new AABB(pX - 1.5, pY - 1.5, pZ - 1.5, pX + 1.5, pY + 1.5, pZ + 1.5);
    }

    public LivingEntity getEntity() {
        if (this.summon == null) {
            switch (this.getData()) {
                case 0: {
                    QueenFrost queen = new QueenFrost(EntityInit.queenFrost, this.m_9236_());
                    queen.setArmor(3);
                    queen.setMagic(true);
                    this.summon = queen;
                }
            }
        }
        return this.summon;
    }

    @Override
    protected void tickDespawn() {
        Level level;
        if (this.getLifeTime() >= this.getMaxLifeTime() && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            this.discordParticle(server);
        }
        super.tickDespawn();
    }

    public void discordParticle(ServerLevel server) {
        this.m_5496_(SoundEvents.f_11775_, 1.0f, 2.0f);
        Random rand = this.rand;
        BlockPos pos = this.m_20183_().m_7494_();
        SimpleParticleType par = ParticleInit.NORMAL;
        for (int i = 0; i < 64; ++i) {
            double x = this.getRand(rand) * 0.3;
            double y = (double)rand.nextFloat() * 0.4;
            double z = this.getRand(rand) * 0.3;
            server.m_8767_((ParticleOptions)par, this.getRandomX(pos, rand), this.getRandomY(pos, rand), this.getRandomZ(pos, rand), 0, x, y + 0.1, z, 1.0);
        }
    }

    public double getRand(Random rand) {
        return rand.nextDouble() - rand.nextDouble();
    }

    public double getRandomX(BlockPos pos, Random rand) {
        return (double)pos.m_123341_() + this.getRand(rand) * 0.25 + 0.5;
    }

    public double getRandomY(BlockPos pos, Random rand) {
        return (double)pos.m_123342_() + this.getRand(rand) * 0.5 - 1.0;
    }

    public double getRandomZ(BlockPos pos, Random rand) {
        return (double)pos.m_123343_() + this.getRand(rand) * 0.25 + 0.5;
    }

    public int sortEntity(Entity mob, Entity entity1, Entity entity2) {
        double distance2;
        if (entity1 == null || entity2 == null) {
            return 0;
        }
        boolean isBoss1 = entity1.m_6095_().m_204039_(TagInit.BOSS);
        boolean isBoss2 = entity2.m_6095_().m_204039_(TagInit.BOSS);
        if (isBoss1 && isBoss2) {
            return 0;
        }
        if (isBoss1) {
            return -1;
        }
        if (isBoss2) {
            return 1;
        }
        double distance1 = mob.m_20280_(entity1);
        if (distance1 > (distance2 = mob.m_20280_(entity2))) {
            return 1;
        }
        if (distance1 < distance2) {
            return -1;
        }
        return 0;
    }

    public void spawnParticleRing(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double addY, double ySpeed, double moveValue) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0 + addY;
        double z = (double)pos.m_123343_() + 0.5;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.25) {
            double rate = range * 0.75;
            server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, Math.cos(degree) * 0.1, ySpeed, Math.sin(degree) * 0.1, 1.0);
        }
    }

    protected void spawnParticleCycle(BlockPos pos, double range, Random rand) {
        ServerLevel server;
        block4: {
            block3: {
                Level level = this.m_9236_();
                if (!(level instanceof ServerLevel)) break block3;
                server = (ServerLevel)level;
                if (pos != null) break block4;
            }
            return;
        }
        int count = 18;
        SimpleParticleType par = ParticleInit.CYCLE_ELECTRIC;
        for (int i = 0; i < count; ++i) {
            this.spawnParticleCycle(server, (ParticleOptions)par, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, Direction.UP, range, (float)i * 20.0f, false);
        }
    }

    protected void spawnParticleCycle(ServerLevel server, ParticleOptions par, double x, double y, double z, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 1;
        server.m_8767_(par, x, y, z, 0, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * 6.0f), 1.0);
    }

    public void teleportParticle(ParticleOptions par, Level world, BlockPos beforePos, BlockPos afterPos) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sever = (ServerLevel)level;
        float pX = afterPos.m_123341_() - beforePos.m_123341_();
        float pY = afterPos.m_123342_() - beforePos.m_123342_();
        float pZ = afterPos.m_123343_() - beforePos.m_123343_();
        float count = Math.abs((int)(pX + pZ)) * 2;
        int i = 0;
        while ((float)i < count) {
            for (int k = 0; k < 16; ++k) {
                float randX = this.getRandFloat(1.5f);
                float randY = this.getRandFloat(1.5f);
                float randZ = this.getRandFloat(1.5f);
                float ax = (float)beforePos.m_123341_() + 0.5f + randX + pX * ((float)i / count);
                float ay = (float)beforePos.m_123342_() + 1.25f + randY + pY * ((float)i / count);
                float az = (float)beforePos.m_123343_() + 0.5f + randZ + pZ * ((float)i / count);
                sever.m_8767_(par, (double)ax, (double)ay, (double)az, 0, 0.0, 0.0, 0.0, 1.0);
            }
            ++i;
        }
    }
}

