/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.fluids.FluidType;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.iitem.IMagicBook;
import sweetmagic.api.iitem.IMagicItem;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.BookInfo;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.BlockInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.block.sm.MirageGlass;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.projectile.CycloneMagicShot;
import sweetmagic.init.entity.projectile.DigMagicShot;
import sweetmagic.init.entity.projectile.MagicSquareMagic;
import sweetmagic.util.PlayerHelper;
import sweetmagic.util.SMDamage;
import sweetmagic.util.WorldHelper;

public abstract class AbstractMagicShot
extends Projectile {
    @Nullable
    private BlockState lastState;
    public int wandLevel = 1;
    public int lifeTime;
    public int maxLifeTime = 50;
    public int tickTime = 0;
    public int shakeTime;
    public int knockback = 1;
    public int addAttack = 0;
    public int maxBreak = 0;
    public float baseDamage = 2.0f;
    public float addDamage = 0.0f;
    public float criticalChance = 0.0f;
    public float baseCriticalDamage = 1.0f;
    public float capRelaxationDamage = 0.0f;
    public boolean inGround;
    private boolean isHitDead = true;
    public boolean isCritical = false;
    public boolean isPlayerThrower = true;
    public boolean isBlockPenetration = false;
    public boolean isNotDamage = false;
    public boolean isSilk = false;
    public IWand wand;
    public CompoundTag tags;
    public ItemStack stack = ItemStack.f_41583_;
    public Random rand = new Random();
    private static final EntityDataAccessor<Boolean> CHANGE_PARTICLE = AbstractMagicShot.setEntityData(ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Integer> DATA = AbstractMagicShot.setEntityData(ISMMob.INT);
    private static final EntityDataAccessor<Integer> TIER = AbstractMagicShot.setEntityData(ISMMob.INT);
    private static final EntityDataAccessor<Float> RANGE = AbstractMagicShot.setEntityData(ISMMob.FLOAT);
    private static final EntityDataAccessor<Float> SHOTSPEED = AbstractMagicShot.setEntityData(ISMMob.FLOAT);
    private static final EntityDataAccessor<Float> CRITICAL_DAMAGE = AbstractMagicShot.setEntityData(ISMMob.FLOAT);
    private static final EntityDataAccessor<Boolean> ARROW = AbstractMagicShot.setEntityData(ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HOUR_GLASS = AbstractMagicShot.setEntityData(ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> WARRIOR_CARD = AbstractMagicShot.setEntityData(ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> QUILLPEN = AbstractMagicShot.setEntityData(ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> BROOCH = AbstractMagicShot.setEntityData(ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HEART = AbstractMagicShot.setEntityData(ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> COAL = AbstractMagicShot.setEntityData(ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Boolean> KEY = AbstractMagicShot.setEntityData(ISMMob.BOOLEAN);
    private static final EntityDataAccessor<Integer> JEWEL = AbstractMagicShot.setEntityData(ISMMob.INT);

    public AbstractMagicShot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public AbstractMagicShot(EntityType<? extends AbstractMagicShot> entityType, double x, double y, double z, Level world) {
        this(entityType, world);
        this.m_6034_(x, y, z);
    }

    public AbstractMagicShot(EntityType<? extends AbstractMagicShot> entityType, LivingEntity entity, Level world) {
        this(entityType, entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
    }

    public <T> T get(EntityDataAccessor<T> value) {
        return (T)this.m_20088_().m_135370_(value);
    }

    public <T> void set(EntityDataAccessor<T> value, T par) {
        this.m_20088_().m_135381_(value, par);
    }

    public <T> void define(EntityDataAccessor<T> value, T par) {
        this.m_20088_().m_135372_(value, par);
    }

    public static <T> EntityDataAccessor<T> setEntityData(EntityDataSerializer<T> seria) {
        return SynchedEntityData.m_135353_(AbstractMagicShot.class, seria);
    }

    public boolean m_6783_(double dis) {
        double d0 = this.m_20191_().m_82309_() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return dis < (d0 *= 64.0 * AbstractMagicShot.m_20150_()) * d0;
    }

    protected void m_8097_() {
        this.define(CHANGE_PARTICLE, false);
        this.define(DATA, 0);
        this.define(TIER, 1);
        this.define(RANGE, Float.valueOf(0.0f));
        this.define(SHOTSPEED, Float.valueOf(1.0f));
        this.define(CRITICAL_DAMAGE, Float.valueOf(0.0f));
        this.define(ARROW, false);
        this.define(HOUR_GLASS, false);
        this.define(WARRIOR_CARD, false);
        this.define(QUILLPEN, false);
        this.define(BROOCH, false);
        this.define(HEART, false);
        this.define(COAL, false);
        this.define(KEY, false);
        this.define(JEWEL, 0);
    }

    public void m_6686_(double x, double y, double z, float vec, float inaccuracy) {
        super.m_6686_(x, y, z, vec, inaccuracy);
        this.setLifeTime(0);
    }

    public void checkOwner() {
        Entity owner = this.m_19749_();
        if (owner == null || !owner.m_6084_()) {
            this.m_146870_();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void m_8119_() {
        block17: {
            block16: {
                super.m_8119_();
                vec3 = this.m_20184_();
                if (this.f_19860_ == 0.0f && this.f_19859_ == 0.0f) {
                    d0 = vec3.m_165924_();
                    this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
                    this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
                    this.f_19859_ = this.m_146908_();
                    this.f_19860_ = this.m_146909_();
                }
                pos = this.m_20183_();
                state = this.m_9236_().m_8055_(pos);
                if (!(state.m_60795_() || this.getBlockPenetration() || (voxel = state.m_60812_((BlockGetter)this.m_9236_(), pos)).m_83281_())) {
                    vec31 = this.m_20182_();
                    for (AABB aabb : voxel.m_83299_()) {
                        if (!aabb.m_82338_(pos).m_82390_(vec31)) continue;
                        this.inGround = true;
                        break;
                    }
                }
                if (this.shakeTime > 0) {
                    --this.shakeTime;
                }
                ++this.lifeTime;
                if (!this.isClient()) {
                    this.tickDespawn();
                }
                if (this.m_20070_() || state.m_60713_(Blocks.f_152499_) || this.isInFluidType((BiPredicate<FluidType, Double>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Z, lambda$tick$0(net.minecraftforge.fluids.FluidType java.lang.Double ), (Lnet/minecraftforge/fluids/FluidType;Ljava/lang/Double;)Z)((AbstractMagicShot)this))) {
                    this.m_20095_();
                }
                if (this.isClient() && this.f_19797_ >= this.getMinParticleTick()) {
                    this.spawnParticle();
                }
                if (!this.inGround) break block16;
                this.inGround();
                break block17;
            }
            vec32 = this.m_20182_();
            vec33 = vec32.m_82549_(vec3);
            result = this.m_9236_().m_45547_(new ClipContext(vec32, vec33, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (result.m_6662_() != HitResult.Type.MISS) {
                vec33 = result.m_82450_();
            }
            while (!this.m_213877_()) {
                block18: {
                    entityHit = this.findHitEntity(vec32, vec33);
                    if (entityHit != null) {
                        result = entityHit;
                    }
                    if (result == null || result.m_6662_() != HitResult.Type.ENTITY) break block18;
                    entity = ((EntityHitResult)result).m_82443_();
                    entity1 = this.m_19749_();
                    if (!(entity instanceof Player)) ** GOTO lbl-1000
                    player = (Player)entity;
                    if (entity1 instanceof Player && !(player1 = (Player)entity1).m_7099_(player)) {
                        result = null;
                        entityHit = null;
                    } else if (this.canHitTarget(entity) && this.canHitTarget(entity1) || entity == entity1) {
                        result = null;
                        entityHit = null;
                    }
                }
                if (result != null && result.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)result)) {
                    this.m_6532_((HitResult)result);
                    this.f_19812_ = true;
                    break;
                }
                if (entityHit == null) break;
                result = null;
            }
            vec3 = this.m_20184_();
            d5 = vec3.f_82479_;
            d6 = vec3.f_82480_;
            d1 = vec3.f_82481_;
            d7 = this.m_20185_() + d5;
            d2 = this.m_20186_() + d6;
            d3 = this.m_20189_() + d1;
            d4 = vec3.m_165924_();
            this.m_146922_((float)(Mth.m_14136_((double)d5, (double)d1) * 57.2957763671875));
            this.m_146926_((float)(Mth.m_14136_((double)d6, (double)d4) * 57.2957763671875));
            this.m_146926_(AbstractMagicShot.m_37273_((float)this.f_19860_, (float)this.m_146909_()));
            this.m_146922_(AbstractMagicShot.m_37273_((float)this.f_19859_, (float)this.m_146908_()));
            if (this.m_20069_()) {
                // empty if block
            }
            this.m_6034_(d7, d2, d3);
            this.m_20101_();
            if (this.getArrow()) {
                vec = this.m_20184_().m_82490_(0.99);
                this.m_20334_(vec.f_82479_, vec.f_82480_ - 0.02, vec.f_82481_);
            }
        }
    }

    protected void m_6532_(HitResult hit) {
        HitResult.Type type = hit.m_6662_();
        if (type == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)hit);
        }
        if (type != HitResult.Type.BLOCK || this.getBlockPenetration() && !(this instanceof DigMagicShot)) {
            return;
        }
        Level world = this.m_9236_();
        BlockHitResult result = (BlockHitResult)hit;
        BlockPos pos = result.m_82425_();
        BlockState state = world.m_8055_(pos);
        if (this.getArrow()) {
            this.setLifeTime(0);
            this.setMaxLifeTime(80);
            if (!this.isClient()) {
                this.setArrow(false);
                this.m_5496_(SoundEvents.f_11685_, 1.0f, 1.2f / (this.rand.nextFloat() * 0.2f + 0.9f));
            }
            if (result.m_82434_() == Direction.UP) {
                this.m_6034_(this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_());
            }
            return;
        }
        if (state.m_60713_(BlockInit.mirage_wall_glass) && !((Boolean)state.m_61143_((Property)MirageGlass.ISVIEW)).booleanValue()) {
            MirageGlass mirage = (MirageGlass)state.m_60734_();
            mirage.setValue(world, pos, true);
        }
        this.m_8060_(result);
        if (this.f_19797_ <= this.getMinParticleTick() && world instanceof ServerLevel) {
            ServerLevel sever = (ServerLevel)world;
            this.spawnParticleShort(sever, result.m_82425_().m_121945_(result.m_82434_()));
        }
        world.m_220407_(GameEvent.f_157777_, pos, GameEvent.Context.m_223719_((Entity)this, (BlockState)world.m_8055_(pos)));
    }

    protected void spawnParticle() {
    }

    protected void spawnParticleShort(ServerLevel sever, BlockPos pos) {
    }

    protected void spawnParticleRing(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double ySpeed, double moveValue) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        for (double degree = 0.0; degree < range * Math.PI; degree += 0.1) {
            double rate = range;
            server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, -Math.cos(degree), ySpeed, -Math.sin(degree), moveValue);
        }
    }

    public void spawnParticleRing(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double addY) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 1.0 + addY;
        double z = (double)pos.m_123343_() + 0.5;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.25) {
            double rate = range * 0.75;
            server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, Math.cos(degree) * 0.65, 0.0, Math.sin(degree) * 0.65, -0.67);
        }
    }

    public void spawnParticleRingY(ServerLevel server, ParticleOptions par, double range, BlockPos pos, double speed, double addY) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.5;
        double z = (double)pos.m_123343_() + 0.5;
        for (double degree = -range * Math.PI; degree < range * Math.PI; degree += 0.25) {
            double rate = range * 0.75;
            server.m_8767_(par, x + Math.cos(degree) * rate, y, z + Math.sin(degree) * rate, 0, Math.cos(degree) * speed, addY, Math.sin(degree) * speed, 1.0);
        }
    }

    public void addParticle(ParticleOptions par, double x, double y, double z, double xS, double yS, double zS) {
        this.m_9236_().m_7106_(par, x, y, z, xS, yS, zS);
    }

    public BlockParticleOption getParticle(BlockState state) {
        return new BlockParticleOption(ParticleTypes.f_123794_, state);
    }

    protected void tickDespawn() {
        if (this.getLifeTime() >= this.getMaxLifeTime()) {
            this.despawnAction();
            this.m_146870_();
        }
    }

    public void despawnAction() {
    }

    public void m_37251_(Entity entity, float x, float y, float z, float shotSpeed, float par1) {
        float pi = (float)Math.PI / 180;
        float f = -Mth.m_14031_((float)(y * pi)) * Mth.m_14089_((float)(x * pi));
        float f1 = -Mth.m_14031_((float)((x + z) * pi));
        float f2 = Mth.m_14089_((float)(y * pi)) * Mth.m_14089_((float)(x * pi));
        this.m_6686_(f, f1, f2, shotSpeed, par1);
        this.setShotSpeed(shotSpeed);
    }

    protected void m_5790_(EntityHitResult result) {
        Player player;
        float dame;
        super.m_5790_(result);
        if (this.getNotDamage()) {
            return;
        }
        Entity target = result.m_82443_();
        Entity attacker = this.m_19749_();
        float f = dame = attacker instanceof Player && target instanceof Player ? this.getDamage() * 1.0E-5f : this.getDamage();
        if (!(target instanceof EnderMan) && !(target instanceof Witch)) {
            Player player2;
            src = this.damageSource();
            if (target instanceof LivingEntity) {
                living = (LivingEntity)target;
                this.onKnockBack(living);
                if (!this.isClient() && attacker instanceof LivingEntity) {
                    LivingEntity attackkerLiv = (LivingEntity)attacker;
                    try {
                        EnchantmentHelper.m_44823_((LivingEntity)living, (Entity)attacker);
                        EnchantmentHelper.m_44896_((LivingEntity)attackkerLiv, (Entity)living);
                        attackkerLiv.m_6703_(living);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                float f2 = dame = target instanceof Warden ? dame * 4.0f : dame;
                if (target.m_6469_(src, dame)) {
                    Level level;
                    this.entityHitEffect(living);
                    this.entityHit(living);
                    living.f_19802_ = 0;
                    if (attacker instanceof LivingEntity) {
                        LivingEntity entity = (LivingEntity)attacker;
                        this.vulnerableAttack(living, entity, dame);
                        this.addAttackEntity((Entity)living, entity, dame, this.getAddAttack());
                    }
                    if (this.f_19797_ <= this.getMinParticleTick() && (level = this.m_9236_()) instanceof ServerLevel) {
                        ServerLevel sever = (ServerLevel)level;
                        this.spawnParticleShort(sever, this.m_20183_());
                    }
                }
                if (living instanceof Player && attacker instanceof ServerPlayer) {
                    server = (ServerPlayer)attacker;
                    if (!this.m_20067_()) {
                        server.f_8906_.m_9829_((Packet)new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132159_, 0.0f));
                    }
                }
            } else if (attacker instanceof Player && target.m_6469_(SMDamage.getPlayerDamage((Entity)(player2 = (Player)attacker)), dame)) {
                target.f_19802_ = 0;
                this.addAttackEntity(target, (LivingEntity)player2, dame, this.getAddAttack());
            }
        } else {
            LivingEntity entity;
            src = null;
            this.onKnockBack((LivingEntity)target);
            if (attacker instanceof Player) {
                player = (Player)attacker;
                src = SMDamage.getPlayerDamage((Entity)player);
            } else if (attacker instanceof LivingEntity) {
                entity = (LivingEntity)attacker;
                src = SMDamage.getDamage((ResourceKey<DamageType>)DamageTypes.f_268566_, (Entity)entity);
            }
            if (src != null) {
                living = (LivingEntity)target;
                living.m_6469_(src, dame);
                this.entityHitEffect(living);
                this.entityHit(living);
                if (this.f_19797_ <= this.getMinParticleTick() && (server = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel sever = (ServerLevel)server;
                    this.spawnParticleShort(sever, this.m_20183_());
                }
                living.f_19802_ = 0;
                if (attacker instanceof LivingEntity) {
                    entity = (LivingEntity)attacker;
                    this.vulnerableAttack(living, entity, dame);
                    living.m_6703_(living);
                }
                this.addAttack(living, dame, this.getAddAttack());
            }
        }
        if (this.getCritical()) {
            IPorch porch;
            Item y2;
            Player player3;
            ItemStack leg;
            if (this.getBrooch() && this.getPlayer() != null) {
                int healValue = 20;
                player = this.getPlayer();
                List<ItemStack> magicList = IWand.getMagicList(IWand.getWandList(player), s -> true);
                for (ItemStack stack : magicList) {
                    IMagicItem magic = new MagicInfo(stack).getMagicItem();
                    int recast = magic.getRecastTime(stack);
                    if (recast <= 0) continue;
                    magic.setRecastTime(stack, Math.max(0, recast - healValue));
                }
                this.m_5496_(SoundEvents.f_11913_, 2.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
                List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.isTarget(), 2.0);
                entityList.forEach(e -> this.addAttackEntity((Entity)e, (LivingEntity)player, this.getDamage(), 1));
            }
            target.m_5496_(SoundInit.CRITICAL, 1.0f, 1.0f);
            player = this.m_9236_();
            if (player instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)player;
                BlockPos pos = target.m_20183_();
                float x = (float)target.f_19854_ + this.rand.nextFloat() * 0.5f;
                float y2 = (float)pos.m_123342_() + this.rand.nextFloat() * 0.5f + 0.5f;
                float z = (float)target.f_19856_ + this.rand.nextFloat() * 0.5f;
                for (int i = 0; i < 16; ++i) {
                    sever.m_8767_((ParticleOptions)ParticleTypes.f_123815_, (double)x, (double)y2, (double)z, 2, 0.0, 0.0, 0.0, (double)0.1f);
                }
            }
            if (attacker instanceof Player && !(leg = (player3 = (Player)attacker).m_6844_(EquipmentSlot.LEGS)).m_41619_() && (y2 = leg.m_41720_()) instanceof IPorch && (porch = (IPorch)y2).hasAcce(leg, ItemInit.fairy_wing)) {
                int attackCount = Math.max(1, 6 - (int)(this.getRange() / 3.0));
                this.addAttackEntity(target, (LivingEntity)player3, dame, attackCount);
            }
        }
        if (this.getHeart() && target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            if (attacker instanceof Player) {
                player = (Player)attacker;
                int debuffSize = PlayerHelper.getEffectList(living, PotionInit.DEBUFF).size();
                if (living.m_21023_(PotionInit.belial_flame)) {
                    this.addAttackEntity(target, (LivingEntity)player, dame, debuffSize);
                } else {
                    this.addPotion(living, PotionInit.belial_flame, debuffSize * 200, debuffSize);
                }
            }
        }
        if (this.getHitDead() && !this.isClient()) {
            this.m_146870_();
        }
    }

    public void addAttack(LivingEntity entity, float dame, int addAttackCount) {
        if (addAttackCount <= 0) {
            return;
        }
        LivingEntity owner = this.getLiving();
        if (owner != null && owner.m_21023_(PotionInit.arlaune_bless)) {
            ++addAttackCount;
        }
        float rate = this.getQuillpen() ? 0.5f : 0.1f;
        float f = dame = this.isBoss((Entity)entity) ? dame * rate : dame * 0.25f;
        if (entity.m_21023_(PotionInit.flame) && this.getWarriorCard()) {
            dame *= 1.25f;
        }
        for (int i = 0; i < addAttackCount; ++i) {
            this.acceAddAttack((Entity)entity, (LivingEntity)this.m_19749_(), dame, true);
            this.attackDamage(entity, dame, true, true);
            this.vulnerableParticle((Entity)entity);
        }
        this.setAddAttack(0);
    }

    public void addAttackEntity(Entity target, LivingEntity attacker, float dame, int addAttackCount) {
        LivingEntity entity;
        if (addAttackCount <= 0) {
            return;
        }
        float rate = this.getQuillpen() ? 0.5f : 0.1f;
        float f = dame = this.isBoss(target) ? dame * rate : dame * 0.25f;
        if (target instanceof LivingEntity && (entity = (LivingEntity)target).m_21023_(PotionInit.flame) && this.getWarriorCard()) {
            dame *= 1.25f;
        }
        for (int i = 0; i < addAttackCount; ++i) {
            this.acceAddAttack(target, attacker, dame, false);
            if (target.m_6469_(SMDamage.getAddDamage((Entity)this, (Entity)attacker), dame)) {
                target.f_19802_ = 0;
            }
            this.vulnerableParticle(target);
        }
        this.setAddAttack(0);
    }

    public void acceAddAttack(Entity target, LivingEntity attacker, float dame, boolean isNotEnder) {
        IPorch porch;
        Item item;
        if (this.rand.nextFloat() > 0.5f || attacker == null || !(attacker instanceof Player)) {
            return;
        }
        Player player = (Player)attacker;
        ItemStack leg = attacker.m_6844_(EquipmentSlot.LEGS);
        if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch && (porch = (IPorch)item).hasAcce(leg, ItemInit.cherry_ornate_hairpin)) {
            DamageSource src;
            DamageSource damageSource = src = isNotEnder ? SMDamage.getAddDamage((Entity)this, (Entity)attacker) : SMDamage.getPlayerDamage((Entity)player);
            if (target.m_6469_(src, dame * 0.25f)) {
                target.f_19802_ = 0;
            }
        }
    }

    public void onKnockBack(LivingEntity living) {
        if ((double)this.knockback <= 0.0) {
            return;
        }
        float knock = (float)Math.max(0.0, 1.0 - living.m_21133_(Attributes.f_22278_));
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)living, (float)((float)this.knockback * 0.6f * knock), (double)1.0, (double)1.0);
        if (event.isCanceled()) {
            return;
        }
        Vec3 vec3 = this.m_20184_().m_82542_(event.getRatioX(), 0.01, event.getRatioZ()).m_82541_().m_82490_((double)event.getStrength());
        if (vec3.m_82556_() > 0.0) {
            living.m_5997_(vec3.f_82479_, 0.1, vec3.f_82481_);
        }
    }

    public void attackDamage(LivingEntity target, float dame, boolean isExtend) {
        this.attackDamage(target, dame, isExtend, false);
    }

    public void attackDamage(LivingEntity target, float dame, boolean isExtend, boolean isAddAttack) {
        if (!isExtend) {
            this.onKnockBack(target);
        }
        this.vulnerableAttack(target, (LivingEntity)this.m_19749_(), dame);
        if (!(target instanceof EnderMan) && !(target instanceof Witch)) {
            target.m_6469_(isAddAttack ? SMDamage.getAddDamage((Entity)this, this.m_19749_()) : this.damageSource(), target instanceof Warden ? dame * 4.0f : dame);
            target.f_19802_ = 0;
        } else {
            DamageSource src = null;
            LivingEntity attacker = (LivingEntity)this.m_19749_();
            if (attacker instanceof Player) {
                Player payer = (Player)attacker;
                src = SMDamage.getPlayerDamage((Entity)payer);
            } else if (attacker instanceof Monster) {
                Monster entity = (Monster)attacker;
                src = SMDamage.getDamage((ResourceKey<DamageType>)DamageTypes.f_268566_, (Entity)entity);
            }
            if (src != null) {
                target.m_6469_(src, dame);
                target.f_19802_ = 0;
            }
        }
    }

    private void entityHitEffect(LivingEntity living) {
        if (this.getCoal() && living.m_21023_(PotionInit.flame)) {
            this.setAddAttack(this.getAddAttack() + living.m_21124_(PotionInit.flame).m_19564_() + 1);
        }
    }

    protected void entityHit(LivingEntity living) {
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        if (this.getBlockPenetration()) {
            return;
        }
        if (this.getHitDead() && !this.isClient()) {
            this.m_146870_();
        }
    }

    public void inGround() {
    }

    public boolean canHitTarget(Entity entity) {
        AbstractSummonMob mob;
        return entity instanceof Player || entity instanceof AbstractSummonMob && !(mob = (AbstractSummonMob)entity).canAttack();
    }

    @Nullable
    protected EntityHitResult findHitEntity(Vec3 vec1, Vec3 vec2) {
        return ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)vec1, (Vec3)vec2, (AABB)this.m_20191_().m_82369_(this.m_20184_()).m_82400_(1.0), x$0 -> this.m_5603_((Entity)x$0));
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected float m_6380_(Pose pose, EntityDimensions dime) {
        return 0.13f;
    }

    public RandomSource getRandom() {
        return this.f_19796_;
    }

    public void setWandLevel(int wandLevel) {
        this.wandLevel = wandLevel;
    }

    public int getWandLevel() {
        return this.wandLevel;
    }

    public void setLifeTime(int lifeTime) {
        this.lifeTime = lifeTime;
    }

    public int getLifeTime() {
        return this.lifeTime;
    }

    public void setMaxLifeTime(int maxLifeTime) {
        this.maxLifeTime = maxLifeTime;
    }

    public int getMaxLifeTime() {
        return this.maxLifeTime;
    }

    public int getMinParticleTick() {
        return 0;
    }

    protected void setBaseDamage(float damage) {
        this.baseDamage = damage;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public void setAddDamage(float addDamage) {
        this.addDamage = addDamage;
    }

    public float getAddDamage() {
        return this.addDamage;
    }

    public void setCriticalChance(float criticalChance) {
        this.criticalChance = criticalChance;
    }

    public float getCriticalChance() {
        return this.criticalChance;
    }

    public void setBaseCriticalDamage(float criticalDamage) {
        this.baseCriticalDamage = criticalDamage;
    }

    public float getBaseCriticalDamage() {
        return this.baseCriticalDamage;
    }

    public void setCapRelaxationDamage(float capRelaxationDamage) {
        this.capRelaxationDamage = capRelaxationDamage;
    }

    public float getCapRelaxationDamage() {
        return this.capRelaxationDamage;
    }

    public void setAddCriticalDamage(float criticalDamage) {
        this.set(CRITICAL_DAMAGE, Float.valueOf(criticalDamage));
    }

    public float getAddCriticalDamage() {
        return this.get(CRITICAL_DAMAGE).floatValue();
    }

    public void setRange(double range) {
        this.set(RANGE, Float.valueOf((float)range));
    }

    public double getRange() {
        return this.get(RANGE).floatValue();
    }

    public void setShotSpeed(float shotSpeed) {
        this.set(SHOTSPEED, Float.valueOf(shotSpeed));
    }

    public float getShotSpeed() {
        return this.get(SHOTSPEED).floatValue();
    }

    public void setAddAttack(int addAttack) {
        this.addAttack = addAttack;
    }

    public int getAddAttack() {
        return this.addAttack;
    }

    public void setMaxBreak(int maxBreak) {
        this.maxBreak = maxBreak;
    }

    public boolean getArrow() {
        return this.get(ARROW);
    }

    public void setArrow(boolean isArrow) {
        this.set(ARROW, isArrow);
    }

    public boolean getHourGlass() {
        return this.get(HOUR_GLASS);
    }

    public void setHourGlass(boolean isGlass) {
        this.set(HOUR_GLASS, isGlass);
    }

    public boolean getWarriorCard() {
        return this.get(WARRIOR_CARD);
    }

    public void setWarriorCard(boolean isCard) {
        this.set(WARRIOR_CARD, isCard);
    }

    public boolean getQuillpen() {
        return this.get(QUILLPEN);
    }

    public void setQuillpen(boolean isCard) {
        this.set(QUILLPEN, isCard);
    }

    public boolean getBrooch() {
        return this.get(BROOCH);
    }

    public void setBrooch(boolean isBrooch) {
        this.set(BROOCH, isBrooch);
    }

    public boolean getHeart() {
        return this.get(HEART);
    }

    public void setHeart(boolean isHeart) {
        this.set(HEART, isHeart);
    }

    public boolean getCoal() {
        return this.get(COAL);
    }

    public void setCoal(boolean isCoal) {
        this.set(COAL, isCoal);
    }

    public boolean getKey() {
        return this.get(KEY);
    }

    public void setKey(boolean key) {
        this.set(KEY, key);
    }

    public int getJewel() {
        return this.get(JEWEL);
    }

    public void setJewel(int jewel) {
        this.set(JEWEL, jewel);
    }

    public int getMaxBreak() {
        return this.maxBreak;
    }

    public void setBlockPenetration(boolean isBlockPenetration) {
        this.isBlockPenetration = isBlockPenetration;
    }

    public boolean getBlockPenetration() {
        return this.isBlockPenetration;
    }

    public void setNotDamage(boolean isNotDamage) {
        this.isNotDamage = isNotDamage;
    }

    public boolean getNotDamage() {
        return this.isNotDamage;
    }

    public void setSilk(boolean isSilk) {
        this.isSilk = isSilk;
    }

    public boolean getSilk() {
        return this.isSilk;
    }

    public void setChangeParticle(boolean isChangetParticle) {
        this.set(CHANGE_PARTICLE, isChangetParticle);
    }

    public boolean getChangeParticle() {
        return this.get(CHANGE_PARTICLE);
    }

    public void setHitDead(boolean isHitDead) {
        this.isHitDead = isHitDead;
    }

    public boolean getHitDead() {
        return this.isHitDead;
    }

    public void setCritical(boolean isCritical) {
        this.isCritical = isCritical;
    }

    public boolean getCritical() {
        return this.isCritical;
    }

    public void setData(int data) {
        this.set(DATA, data);
    }

    public int getData() {
        return this.get(DATA);
    }

    public int getTier() {
        return this.get(TIER);
    }

    public void setTier(int tier) {
        this.set(TIER, tier);
    }

    public void setPlayerThrower(boolean isPlayerThrower) {
        this.isPlayerThrower = isPlayerThrower;
    }

    public boolean getPlayerThrower() {
        return this.isPlayerThrower;
    }

    public void setWand(IWand wand) {
        this.wand = wand;
    }

    public abstract SMElement getElement();

    public SMElement getSubElement() {
        return null;
    }

    protected DamageSource damageSource() {
        Entity owner = this.m_19749_();
        if (owner == null) {
            return SMDamage.getDebuffDamage(this.m_9236_());
        }
        if (!(owner instanceof Monster)) {
            return SMDamage.getMagicDamage((Entity)this, owner);
        }
        Monster entity = (Monster)owner;
        return entity.m_5448_() instanceof Player ? SMDamage.getDamage((ResourceKey<DamageType>)DamageTypes.f_268566_, owner) : SMDamage.getMagicDamage((Entity)this, owner);
    }

    public int addPotion(LivingEntity entity, MobEffect potion, int time, int level) {
        float rate;
        Player player;
        Entity entity2 = this.m_19749_();
        boolean flag = entity2 instanceof Player && (player = (Player)entity2).m_21023_(PotionInit.debuff_duration_increase);
        float f = rate = flag ? 1.5f : 1.0f;
        if (this.isBoss((Entity)entity)) {
            if (!potion.equals(PotionInit.bleeding)) {
                time /= 4;
                level = Math.max(0, level - 1);
            } else {
                time /= 2;
            }
            time /= 4;
            int n = level = potion.equals(PotionInit.bleeding) ? level : Math.max(0, level - 1);
            if (potion.equals(PotionInit.bubble)) {
                time = Math.min(20 + 30 * level, time);
            }
        }
        if (potion == PotionInit.flame) {
            if (this.getCoal()) {
                ++level;
            }
            if (this.getJewel() > 0) {
                time = (int)((float)time * (1.0f + 0.1f * (float)this.getJewel()));
            }
        }
        time = (int)((float)time * rate);
        PlayerHelper.setPotion(entity, potion, level, time);
        return time;
    }

    public boolean isBoss(Entity entity) {
        return entity.m_6095_().m_204039_(TagInit.BOSS);
    }

    public boolean isNotSpecial(Entity entity) {
        return entity.m_6095_().m_204039_(TagInit.NOT_SPECIAL);
    }

    public IWand getWand() {
        return this.wand;
    }

    public void setNBT(CompoundTag tags) {
        this.tags = tags;
    }

    public CompoundTag getNBT() {
        return this.tags;
    }

    public void setWandInfo(WandInfo info) {
        this.setStack(info.getStack());
        this.setWandLevel(info.getLevel());
        this.setNBT(info.getNBT());
    }

    public void acceEffect(WandInfo info) {
        List<ItemStack> stackBookList;
        Entity entity = this.m_19749_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        float criticalChance = this.getCriticalChance();
        float criticalDamage = this.getBaseCriticalDamage();
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        IPorch porch = IPorch.getPorch(leg);
        if (porch != null) {
            int jewelCount;
            int roseCount;
            int extensionCount;
            int bloodCount = porch.acceCount(leg, ItemInit.blood_sucking_ring, 5);
            if (bloodCount > 0 && player.m_21223_() > (float)(1 + bloodCount)) {
                float addDameRate = 1.0f + (float)bloodCount * 0.2f;
                this.setAddDamage(this.getAddDamage() * addDameRate);
            }
            if (porch.hasAcce(leg, ItemInit.wizard_gauntlet)) {
                if (this.getRange() > 0.0) {
                    this.setRange(this.getRange() * 1.125);
                }
                if (this.isElement(SMElement.LIGHTNING)) {
                    this.setAddAttack(this.getAddAttack() + 2);
                    this.setAddDamage(this.getAddDamage() * 1.5f);
                }
            }
            if ((extensionCount = porch.acceCount(leg, ItemInit.extension_ring, 8)) > 0) {
                float addRangeRate = 1.0f + (float)extensionCount * 0.125f;
                if (this.getRange() > 0.0) {
                    this.setRange(this.getRange() * (double)addRangeRate);
                } else {
                    this.setAddAttack(this.getAddAttack() + extensionCount);
                }
                if (this.getMaxBreak() > 0) {
                    this.setMaxBreak(this.getMaxBreak() + extensionCount / 2);
                }
            }
            if ((roseCount = porch.acceCount(leg, ItemInit.rose_quartz_pendant, 5)) > 0) {
                criticalChance += 0.05f;
                criticalDamage += (float)roseCount * 0.05f;
            }
            if (porch.hasAcce(leg, ItemInit.frosted_chain) && this.isElement(SMElement.FROST)) {
                this.setAddDamage(this.getAddDamage() * 1.25f);
                List<Monster> entityList = this.getEntityList(Monster.class, 7.5);
                entityList.forEach(e -> this.addPotion((LivingEntity)e, PotionInit.frost, 200, 1));
                this.setAddAttack(this.getAddAttack() + 1);
            }
            if (porch.hasAcce(leg, ItemInit.holly_charm) && this.isElement(SMElement.SHINE)) {
                this.setAddDamage(this.getAddDamage() * 1.25f);
                this.setAddAttack(this.getAddAttack() + 1);
            }
            if (porch.hasAcce(leg, ItemInit.ignis_soul) && this.isElement(SMElement.FLAME)) {
                this.setAddDamage(this.getBaseDamage() * 1.25f);
                this.setAddAttack(this.getAddAttack() + 1);
            }
            if (porch.hasAcce(leg, ItemInit.warrior_card) && player.m_21023_(MobEffects.f_19600_)) {
                this.setAddAttack(this.getAddAttack() + player.m_21124_(MobEffects.f_19600_).m_19564_() + 1);
                this.setWarriorCard(true);
            }
            if (porch.hasAcce(leg, ItemInit.magician_quillpen)) {
                this.setQuillpen(true);
            }
            if (porch.hasAcce(leg, ItemInit.twilight_hourglass)) {
                this.setHourGlass(true);
            }
            if (porch.hasAcce(leg, ItemInit.wind_relief) && (this instanceof CycloneMagicShot || this instanceof MagicSquareMagic && this.getData() == 1)) {
                boolean isSquare = this instanceof MagicSquareMagic;
                if (!isSquare) {
                    this.setAddDamage(this.getBaseDamage() * 1.25f);
                    this.setAddAttack(this.getAddAttack() + 1);
                }
                List<Monster> entityList = this.getEntityList(Monster.class, 7.5);
                float damage = isSquare ? 20.0f : this.getDamage();
                entityList.forEach(e -> this.attackDamage((LivingEntity)e, damage * 0.25f, true));
            }
            if (porch.hasAcceIsActive(leg, ItemInit.earth_ruby_ring) && this instanceof DigMagicShot) {
                this.setSilk(true);
            }
            if (porch.hasAcce(leg, ItemInit.fairy_wing)) {
                criticalChance += 0.1f;
            }
            if (porch.hasAcce(leg, ItemInit.magic_magia_cherryrain)) {
                criticalChance += 0.05f;
            }
            if (porch.hasAcce(leg, ItemInit.wizard_brooch)) {
                criticalChance += 0.05f;
                this.setBrooch(true);
            }
            if (porch.hasAcce(leg, ItemInit.belial_heart)) {
                this.setHeart(true);
            }
            if (porch.hasAcce(leg, ItemInit.burning_coal)) {
                this.setCoal(true);
            }
            if (porch.hasAcce(leg, ItemInit.fluorite_key) && this.isElement(SMElement.BLAST)) {
                this.setKey(true);
                criticalDamage += 0.15f;
            }
            if ((jewelCount = porch.acceCount(leg, ItemInit.scorching_jewel, 5)) > 0) {
                this.setJewel(jewelCount);
            }
        }
        if (player.m_21023_(PotionInit.critical_increase)) {
            int level = player.m_21124_(PotionInit.critical_increase).m_19564_() + 1;
            criticalChance += 0.025f * (float)level;
            criticalDamage += (float)level * 0.05f;
        }
        if (!(stackBookList = IMagicBook.getBookList(player)).isEmpty()) {
            BookInfo bInfo = new BookInfo(stackBookList.get(0));
            IMagicBook book = bInfo.getBook();
            criticalChance += book.getChance(book.getAttackPage(bInfo));
        }
        if (player.m_21023_(MobEffects.f_19621_)) {
            criticalChance += (float)(player.m_21124_(MobEffects.f_19621_).m_19564_() + 1) * 0.025f;
        }
        if (criticalChance > 0.0f) {
            float elementBonus = info.getWand().getElementBonus();
            criticalChance += elementBonus * 0.1f;
            criticalDamage += elementBonus * 0.1f;
            if (criticalChance >= this.rand.nextFloat()) {
                this.setCritical(true);
            }
        }
        if (player.m_21023_(PotionInit.holy_bless)) {
            this.setRange(this.getRange() + 3.0);
        }
        if (player.m_21023_(PotionInit.magic_rangeup)) {
            this.setRange(this.getRange() + 2.0);
        }
        if (player.m_21023_(PotionInit.knight_bless)) {
            this.setAddDamage(this.getAddDamage() + 6.0f);
        }
        this.setAddCriticalDamage(criticalDamage);
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public LivingEntity getLiving() {
        return (LivingEntity)this.m_19749_();
    }

    protected float getDamage() {
        int level;
        float damage = this.getBaseDamage();
        LivingEntity entity = this.getLiving();
        if (entity == null) {
            return damage;
        }
        if (entity.m_21023_(MobEffects.f_19600_)) {
            level = entity.m_21124_(MobEffects.f_19600_).m_19564_() + 1;
            damage += (float)(level * 2);
        }
        if (entity.m_21023_(MobEffects.f_19613_)) {
            level = entity.m_21124_(MobEffects.f_19613_).m_19564_() + 1;
            damage -= (float)level;
        }
        if (entity.m_21023_(PotionInit.blood_curse)) {
            level = entity.m_21124_(PotionInit.blood_curse).m_19564_() + 1;
            damage += (float)(level * 3);
        }
        if (entity.m_21023_(PotionInit.magic_damage_cause)) {
            level = entity.m_21124_(PotionInit.magic_damage_cause).m_19564_() + 1;
            damage += (float)level;
        }
        return damage += !this.getCritical() ? this.getAddDamage() : this.getAddDamage() * this.getCriticalDamage();
    }

    public float getCriticalDamage() {
        return 1.5f + this.getAddCriticalDamage();
    }

    protected double wrap180Radian(double radian) {
        radian %= Math.PI * 2;
        while (radian >= Math.PI) {
            radian -= Math.PI * 2;
        }
        while (radian < -Math.PI) {
            radian += Math.PI * 2;
        }
        return radian;
    }

    protected double clampAbs(double param, double maxMagnitude) {
        if (Math.abs(param) > maxMagnitude) {
            param = param < 0.0 ? -Math.abs(maxMagnitude) : Math.abs(maxMagnitude);
        }
        return param;
    }

    protected double angleBetween(Vec3 v1, Vec3 v2) {
        double vDot = v1.m_82526_(v2) / (v1.m_82553_() * v2.m_82553_());
        if (vDot < -1.0) {
            vDot = -1.0;
        }
        if (vDot > 1.0) {
            vDot = 1.0;
        }
        return Math.acos(vDot);
    }

    protected Vec3 transform(Vec3 axis, double angle, Vec3 normal) {
        double m00 = 1.0;
        double m01 = 0.0;
        double m02 = 0.0;
        double m10 = 0.0;
        double m11 = 1.0;
        double m12 = 0.0;
        double m20 = 0.0;
        double m21 = 0.0;
        double m22 = 1.0;
        double mag = Math.sqrt(axis.f_82479_ * axis.f_82479_ + axis.f_82480_ * axis.f_82480_ + axis.f_82481_ * axis.f_82481_);
        if (mag >= 1.0E-10) {
            mag = 1.0 / mag;
            double ax = axis.f_82479_ * mag;
            double ay = axis.f_82480_ * mag;
            double az = axis.f_82481_ * mag;
            double sinTheta = Math.sin(angle);
            double cosTheta = Math.cos(angle);
            double t = 1.0 - cosTheta;
            double xz = ax * az;
            double xy = ax * ay;
            double yz = ay * az;
            m00 = t * ax * ax + cosTheta;
            m01 = t * xy - sinTheta * az;
            m02 = t * xz + sinTheta * ay;
            m10 = t * xy + sinTheta * az;
            m11 = t * ay * ay + cosTheta;
            m12 = t * yz - sinTheta * ax;
            m20 = t * xz - sinTheta * ay;
            m21 = t * yz + sinTheta * ax;
            m22 = t * az * az + cosTheta;
        }
        return new Vec3(m00 * normal.f_82479_ + m01 * normal.f_82480_ + m02 * normal.f_82481_, m10 * normal.f_82479_ + m11 * normal.f_82480_ + m12 * normal.f_82481_, m20 * normal.f_82479_ + m21 * normal.f_82480_ + m22 * normal.f_82481_);
    }

    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        if (this.lastState != null) {
            tags.m_128365_("inBlockState", (Tag)NbtUtils.m_129202_((BlockState)this.lastState));
        }
        tags.m_128405_("data", this.getData());
        tags.m_128405_("tier", this.getTier());
        tags.m_128405_("wandLevel", this.getWandLevel());
        tags.m_128376_("lifeTime", (short)this.getLifeTime());
        tags.m_128376_("maxLifeTime", (short)this.getMaxLifeTime());
        tags.m_128405_("tickTime", this.tickTime);
        tags.m_128344_("shake", (byte)this.shakeTime);
        tags.m_128405_("knockback", this.knockback);
        tags.m_128405_("addAttack", this.addAttack);
        tags.m_128405_("maxBreak", this.maxBreak);
        tags.m_128350_("baseDamage", this.getBaseDamage());
        tags.m_128350_("addDamage", this.getAddDamage());
        tags.m_128347_("range", this.getRange());
        tags.m_128350_("criticalDamage", this.getAddCriticalDamage());
        tags.m_128350_("shotSpeed", this.getShotSpeed());
        tags.m_128350_("criticalChance", this.getCriticalChance());
        tags.m_128350_("baseCriticalDamage", this.getBaseCriticalDamage());
        tags.m_128350_("capRelaxationDamage", this.getCapRelaxationDamage());
        tags.m_128379_("inGround", this.inGround);
        tags.m_128379_("isHitDead", this.getHitDead());
        tags.m_128379_("isCritical", this.getCritical());
        tags.m_128379_("isPlayerThrower", this.getPlayerThrower());
        tags.m_128379_("isBlockPenetration", this.getBlockPenetration());
        tags.m_128379_("isNotDamage", this.getNotDamage());
        tags.m_128379_("isSilk", this.getSilk());
        tags.m_128379_("isArrow", this.getArrow());
        tags.m_128379_("isWarriorCard", this.getWarriorCard());
        tags.m_128379_("isQuillpen", this.getQuillpen());
        tags.m_128379_("isBrooch", this.getBrooch());
        tags.m_128379_("isHeart", this.getHeart());
        tags.m_128379_("isCoal", this.getCoal());
        tags.m_128379_("isKey", this.getKey());
        tags.m_128405_("jewel", this.getJewel());
        tags.m_128379_("isHourGlass", this.getHourGlass());
        if (!this.getStack().m_41619_()) {
            tags.m_128365_("wandStack", (Tag)this.getStack().m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        if (tags.m_128425_("inBlockState", 10)) {
            this.lastState = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)tags.m_128469_("inBlockState"));
        }
        this.setData(tags.m_128451_("data"));
        this.setTier(tags.m_128451_("tier"));
        this.setLifeTime(tags.m_128448_("lifeTime"));
        this.setMaxLifeTime(tags.m_128448_("maxLifeTime"));
        this.tickTime = tags.m_128451_("tickTime");
        this.shakeTime = tags.m_128445_("shake") & 0xFF;
        this.knockback = tags.m_128451_("knockback");
        this.addDamage = tags.m_128451_("addDamage");
        this.maxBreak = tags.m_128451_("maxBreak");
        this.setBaseDamage(tags.m_128457_("baseDamage"));
        this.setAddDamage(tags.m_128457_("addDamage"));
        this.setRange(tags.m_128459_("range"));
        this.setAddCriticalDamage(tags.m_128457_("criticalDamage"));
        this.setShotSpeed(tags.m_128457_("shotSpeed"));
        this.setCriticalChance(tags.m_128457_("criticalChance"));
        this.setBaseCriticalDamage(tags.m_128457_("baseCriticalDamage"));
        this.setCapRelaxationDamage(tags.m_128457_("capRelaxationDamage"));
        this.inGround = tags.m_128471_("inGround");
        this.setHitDead(tags.m_128471_("isHitDead"));
        this.setCritical(tags.m_128471_("isCritical"));
        this.setPlayerThrower(tags.m_128471_("isPlayerThrower"));
        this.setBlockPenetration(tags.m_128471_("isBlockPenetration"));
        this.setNotDamage(tags.m_128471_("isNotDamage"));
        this.setSilk(tags.m_128471_("isSilk"));
        this.setArrow(tags.m_128471_("isArrow"));
        this.setWarriorCard(tags.m_128471_("isWarriorCard"));
        this.setQuillpen(tags.m_128471_("isQuillpen"));
        this.setBrooch(tags.m_128471_("isBrooch"));
        this.setHeart(tags.m_128471_("isHeart"));
        this.setCoal(tags.m_128471_("isCoal"));
        this.setKey(tags.m_128471_("isKey"));
        this.setJewel(tags.m_128451_("jewel"));
        this.setHourGlass(tags.m_128471_("isHourGlass"));
        if (tags.m_128425_("wandStack", 10)) {
            this.stack = ItemStack.m_41712_((CompoundTag)tags.m_128469_("wandStack"));
            this.wand = IWand.getWand(this.getStack());
            this.tags = this.wand.getNBT(this.getStack());
        }
    }

    public void playSound(Entity entity, SoundEvent sound, float vol, float pit) {
        this.m_9236_().m_5594_(null, entity.m_20097_(), sound, SoundSource.AMBIENT, vol, pit);
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, double range) {
        return WorldHelper.getEntityList((Entity)this, enClass, this.getAABB(range));
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Predicate<T> filter, AABB aabb) {
        return WorldHelper.getEntityList((Entity)this, enClass, filter, aabb);
    }

    public <T extends Entity> List<T> getEntityList(Class<T> enClass, Predicate<T> filter, double range) {
        return WorldHelper.getEntityList((Entity)this, enClass, filter, this.getAABB(range));
    }

    public AABB getAABB(double range) {
        return this.getAABB(range, range / 2.0, range);
    }

    public AABB getAABB(double x, double y, double z) {
        return this.m_20191_().m_82377_(x, y, z);
    }

    public AABB getAABB(BlockPos pos, double range) {
        return WorldHelper.getAABB(pos, range, range, range);
    }

    public <T extends LivingEntity> Predicate<T> isTarget() {
        return e -> e.m_6084_() && this.canTargetEffect((LivingEntity)e, this.m_19749_());
    }

    public <T extends LivingEntity> Predicate<T> isBladTarget(double range) {
        return e -> e.m_6084_() && this.canTargetEffect((LivingEntity)e, this.m_19749_()) && this.checkDistance(e.m_20183_(), range);
    }

    public Iterable<BlockPos> getPosList(BlockPos pos, double range) {
        return WorldHelper.getRangePos(pos, range);
    }

    public Iterable<BlockPos> getPosRangeList(BlockPos pos, double range) {
        return WorldHelper.getRangePos(pos, -range, 0.0, -range, range, 0.0, range);
    }

    public Player getPlayer() {
        Player player;
        Entity entity = this.m_19749_();
        return entity instanceof Player ? (player = (Player)entity) : null;
    }

    public float getRandFloat(float rate) {
        return (this.rand.nextFloat() - this.rand.nextFloat()) * rate;
    }

    public double getColorValue(double base, double max) {
        return Math.min(1.0, (base + this.rand.nextDouble() * max) / 255.0);
    }

    public boolean canTargetEffect(LivingEntity target, Entity owner) {
        Player player;
        if (owner instanceof Player || owner instanceof AbstractSummonMob) {
            return target instanceof Enemy;
        }
        boolean isPlayer = target instanceof Player && !(player = (Player)target).m_7500_() && !player.m_5833_() || target instanceof AbstractSummonMob;
        return isPlayer ? true : target instanceof Enemy;
    }

    public boolean checkDistance(BlockPos pos, double range) {
        return this.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) <= range;
    }

    public boolean checkDistances(BlockPos basePos, BlockPos pos, double range) {
        double z;
        double y;
        double x = basePos.m_123341_() - pos.m_123341_();
        return x * x + (y = (double)(basePos.m_123342_() - pos.m_123342_())) * y + (z = (double)(basePos.m_123343_() - pos.m_123343_())) * z <= range;
    }

    public void vulnerableAttack(LivingEntity target, LivingEntity attacker, float dame) {
        if (this.isVulnerable(target, PotionInit.flame_explosion_vulnerable, SMElement.FLAME, SMElement.BLAST)) {
            this.vulnerableAttack(target, attacker, PotionInit.flame_explosion_vulnerable, dame);
        }
        if (this.isVulnerable(target, PotionInit.flost_water_vulnerable, SMElement.FROST, SMElement.WATER)) {
            this.vulnerableAttack(target, attacker, PotionInit.flost_water_vulnerable, dame);
        }
        if (this.isVulnerable(target, PotionInit.lightning_wind_vulnerable, SMElement.LIGHTNING, SMElement.CYCLON)) {
            this.vulnerableAttack(target, attacker, PotionInit.lightning_wind_vulnerable, dame);
        }
        if (this.isVulnerable(target, PotionInit.dig_poison_vulnerable, SMElement.EARTH, SMElement.TOXIC)) {
            this.vulnerableAttack(target, attacker, PotionInit.dig_poison_vulnerable, dame);
        }
    }

    public boolean isVulnerable(LivingEntity target, MobEffect potion, SMElement ... eleArray) {
        return target.m_21023_(potion) && this.isElement(eleArray);
    }

    public void vulnerableAttack(LivingEntity target, LivingEntity attacker, MobEffect potion, float dame) {
        this.addAttackEntity((Entity)target, attacker, dame * 2.5f, target.m_21124_(potion).m_19564_() + 1);
    }

    public boolean isElement(SMElement ... ele) {
        return this.getElement().is(ele) || this.getSubElement() != null && this.getSubElement().is(ele);
    }

    public boolean isClient() {
        return this.m_9236_().m_5776_();
    }

    public void vulnerableParticle(Entity target) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        double red = this.getColorValue(10.0, 235.0);
        double green = this.getColorValue(10.0, 235.0);
        double blue = this.getColorValue(10.0, 235.0);
        float addX = this.getRandFloat(1.25f);
        float addY = this.getRandFloat(1.25f);
        float addZ = this.getRandFloat(1.25f);
        for (int i = 0; i < 5; ++i) {
            double x = target.m_20185_() + (double)this.getRandFloat(0.5f) + (double)addX;
            double y = target.m_20186_() + 1.5 + (double)this.getRandFloat(0.5f) + (double)addY;
            double z = target.m_20189_() + (double)this.getRandFloat(0.5f) + (double)addZ;
            server.m_8767_((ParticleOptions)ParticleInit.ADDATTACK, x, y, z, 0, red, green, blue, 1.0);
        }
    }

    private /* synthetic */ boolean lambda$tick$0(FluidType fluidType, Double height) {
        return this.canFluidExtinguish(fluidType);
    }
}

