/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.util.SMDamage;

public class CalamityBomb
extends AbstractMagicShot {
    private static final EntityDataAccessor<Integer> COUNT = CalamityBomb.setEntityData(ISMMob.INT);

    public CalamityBomb(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public CalamityBomb(double x, double y, double z, Level world) {
        this(EntityInit.calamityBomb, world);
        this.m_6034_(x, y, z);
    }

    public CalamityBomb(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(COUNT, 0);
    }

    public void setCount(int count) {
        this.set(COUNT, count);
    }

    public int getCount() {
        return this.get(COUNT);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.inGround) {
            Vec3 vec = this.m_20184_();
            float down = this.getCount() == 2 ? 0.075f : 0.015f;
            this.m_20256_(new Vec3(vec.f_82479_, vec.f_82480_ - (double)down, vec.f_82481_));
        }
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        if (this.isClient()) {
            this.setHitDead(false);
        }
        this.setLifeTime(0);
        if (this.getCount() > 0) {
            this.setCount(this.getCount() - 1);
            Vec3 look = this.m_20184_();
            Vec3 dest = this.getCount() == 1 ? new Vec3(look.f_82479_ * 0.25, (double)0.1f, look.f_82481_ * 0.25) : new Vec3(look.f_82479_, (double)0.1f, look.f_82481_);
            this.m_20256_(dest);
            this.m_5496_(SoundEvents.f_11913_, 2.0f, 1.0f);
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)level;
                BlockPos pos = this.m_20183_().m_7494_();
                float x = (float)pos.m_123341_() + 0.5f;
                float y = (float)pos.m_123342_() - 0.5f;
                float z = (float)pos.m_123343_() + 0.5f;
                sever.m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.15f);
            }
            float rate = 0.33f + (float)(1 - this.getCount()) * 0.34f;
            this.createExplo(this.getDamage() * rate, (float)this.getRange() * rate);
        } else {
            Level dest = this.m_9236_();
            if (dest instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)dest;
                BlockPos pos = this.m_20183_().m_7494_();
                float x = (float)pos.m_123341_() + 0.5f;
                float y = (float)pos.m_123342_() - 0.5f;
                float z = (float)pos.m_123343_() + 0.5f;
                sever.m_8767_((ParticleOptions)ParticleTypes.f_123812_, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.15f);
            }
            this.createExplo(this.getDamage(), (float)this.getRange() * 2.0f);
            this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f);
            this.m_146870_();
        }
    }

    public void createExplo(float explo, float range) {
        double effectRange = range * range;
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> !(e instanceof ISMMob), explo);
        if (entityList.isEmpty() || this.m_19749_() == null || !this.m_19749_().m_6084_()) {
            return;
        }
        DamageSource src = SMDamage.getMagicDamage((Entity)this, this.m_19749_());
        for (LivingEntity entity : entityList) {
            float dame = explo;
            double distance = 2.0f - entity.m_20270_((Entity)this) / dame;
            boolean isWarden = entity instanceof Warden;
            dame = (float)((double)dame * (distance * (double)(isWarden ? 25.0f : 1.0f)));
            entity.m_6469_(src, dame);
            entity.f_19802_ = 0;
            float pi = (float)Math.PI / 180;
            entity.m_147240_(1.0, (double)Mth.m_14031_((float)(this.m_146908_() * pi)), (double)(-Mth.m_14089_((float)(this.m_146908_() * pi))));
            if (!((double)this.m_20270_((Entity)entity) <= effectRange)) continue;
            this.addPotion(entity, PotionInit.gravity, 100, 0);
        }
    }

    @Override
    protected void spawnParticle() {
        Random rand = this.rand;
        Vec3 vec = this.m_20184_();
        float x = (float)(-vec.f_82479_) / 80.0f;
        float y = (float)(-vec.f_82480_) / 80.0f;
        float z = (float)(-vec.f_82481_) / 80.0f;
        float f1 = (float)(this.m_20185_() - 0.5 + (double)rand.nextFloat() + vec.f_82479_);
        float f2 = (float)(this.m_20186_() + 0.25 + (double)rand.nextFloat() * 0.5 + vec.f_82480_);
        float f3 = (float)(this.m_20189_() - 0.5 + (double)rand.nextFloat() + vec.f_82481_);
        this.addParticle((ParticleOptions)ParticleTypes.f_123796_, f1, f2, f3, x, y, z);
    }

    @Override
    public SMElement getElement() {
        return SMElement.BLAST;
    }
}

