/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.DimentionInit;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.monster.boss.AbstractSMBoss;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class EvilArrow
extends AbstractMagicShot {
    public boolean isDrop = false;

    public EvilArrow(EntityType<? extends EvilArrow> entityType, Level world) {
        super(entityType, world);
    }

    public EvilArrow(double x, double y, double z, Level world) {
        this((EntityType<? extends EvilArrow>)EntityInit.evilArrow, world);
        this.m_6034_(x, y, z);
    }

    public EvilArrow(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = info.getStack();
    }

    public EvilArrow(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        this.rangeAttack(null, 2.5);
        super.m_8060_(result);
    }

    @Override
    protected void entityHit(LivingEntity living) {
        if (!(this.m_19749_() instanceof Enemy) && (living instanceof ISMMob || living.m_21023_(PotionInit.darkness_fog))) {
            if (!this.isBoss((Entity)living)) {
                if (living.m_21223_() > 1.0f && !this.isNotSpecial((Entity)living)) {
                    living.m_21153_(1.0f);
                }
                this.attackDamage(living, 999.0f, false);
            } else {
                AbstractSMBoss boss;
                boolean isSMDim;
                boolean bl = isSMDim = this.m_9236_().m_46472_() == DimentionInit.SweetMagicWorld;
                if (isSMDim && living instanceof AbstractSMBoss) {
                    AbstractSMBoss boss2 = (AbstractSMBoss)living;
                    this.attackDamage((LivingEntity)boss2, 15.0f, false);
                } else if (living instanceof AbstractSMBoss && (boss = (AbstractSMBoss)living).isArmorEmpty()) {
                    this.attackDamage((LivingEntity)boss, 10.0f, false);
                }
            }
        }
        this.rangeAttack(living, 3.5);
    }

    public void rangeAttack(LivingEntity living, double range) {
        Level world = this.m_9236_();
        boolean isSMDim = world.m_46472_() == DimentionInit.SweetMagicWorld;
        this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
        boolean isEnemy = this.m_19749_() instanceof Enemy;
        Predicate filter = isEnemy ? this.isTarget() : this.expTarget(living);
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, filter, range);
        for (LivingEntity entity : entityList) {
            AbstractSMBoss boss;
            if (this.canHitTarget((Entity)entity)) {
                this.attackDamage(entity, 6.0f, false);
                continue;
            }
            if (!this.isBoss((Entity)entity)) {
                if (entity.m_21223_() > 1.0f && !this.isNotSpecial((Entity)entity)) {
                    entity.m_21153_(1.0f);
                }
                this.attackDamage(entity, 999.0f, false);
                continue;
            }
            if (isSMDim && entity instanceof AbstractSMBoss) {
                AbstractSMBoss boss2 = (AbstractSMBoss)entity;
                this.attackDamage((LivingEntity)boss2, 15.0f, false);
                continue;
            }
            if (!(entity instanceof AbstractSMBoss) || !(boss = (AbstractSMBoss)entity).isArmorEmpty()) continue;
            this.attackDamage((LivingEntity)boss, 10.0f, false);
        }
        if (world instanceof ServerLevel) {
            ServerLevel sever = (ServerLevel)world;
            sever.m_8767_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 2, 0.0, 0.0, 0.0, 0.0);
        }
        if (isEnemy && this.isDrop) {
            world.m_7967_((Entity)new ItemEntity(world, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ItemInit.evil_arrow)));
        }
    }

    public <T extends LivingEntity> Predicate<T> expTarget(LivingEntity living) {
        return e -> e instanceof ISMMob || e.m_21023_(PotionInit.darkness_fog);
    }

    @Override
    protected void spawnParticle() {
        if (this.f_19797_ < 3) {
            return;
        }
        Vec3 vec = this.m_20184_();
        float addX = (float)(-vec.f_82479_) / 10.0f;
        float addY = (float)(-vec.f_82480_) / 10.0f;
        float addZ = (float)(-vec.f_82481_) / 10.0f;
        this.addParticle((ParticleOptions)ParticleInit.NORMAL, this.m_20185_(), this.m_20186_(), this.m_20189_(), addX, addY, addZ);
    }

    @Override
    public SMElement getElement() {
        return SMElement.BLAST;
    }
}

