/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.ai.ExplosionAttackGoal;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class ExplosionMagicShot
extends AbstractMagicShot {
    public ExplosionMagicShot(EntityType<? extends ExplosionMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public ExplosionMagicShot(double x, double y, double z, Level world) {
        this((EntityType<? extends ExplosionMagicShot>)EntityInit.explosionMagic, world);
        this.m_6034_(x, y, z);
    }

    public ExplosionMagicShot(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(info);
    }

    public ExplosionMagicShot(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
        this.setRange(5.0);
    }

    @Override
    protected void entityHit(LivingEntity living) {
        double range = this.getRange() * (1.0 + 0.5 * (double)this.getData());
        float dame = this.getDamage() * this.getDamageRate();
        this.rangeAttack(living.m_20183_(), dame, range);
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        double range = this.getRange();
        float dame = this.getDamage() * this.getDamageRate() * 0.67f;
        this.rangeAttack(result.m_82425_().m_7494_(), dame, range);
        this.m_146870_();
    }

    public void rangeAttack(BlockPos pos, float dame, double range) {
        range = this.getKey() ? range * 1.25 : range;
        this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sever = (ServerLevel)level;
            sever.m_8767_((ParticleOptions)ParticleTypes.f_123812_, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), 2, 0.0, 0.0, 0.0, 0.0);
        }
        boolean hasKey = this.getKey();
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range);
        entityList.forEach(e -> {
            this.attackDamage((LivingEntity)e, dame, false);
            if (hasKey) {
                this.addAttack((LivingEntity)e, this.getDamage(), 1 + (int)(this.getRange() / 2.0));
            }
        });
        if (this.getData() >= 3) {
            List<Mob> mobList = this.getEntityList(Mob.class, this.isTarget(), range);
            for (Mob mob : mobList) {
                List<WrappedGoal> goalList = mob.f_21345_.m_148105_().stream().filter(e -> e.m_26015_() instanceof ExplosionAttackGoal).toList();
                if (goalList.isEmpty()) {
                    mob.f_21345_.m_25352_(0, (Goal)new ExplosionAttackGoal(mob, this.m_19749_(), (Entity)this, this.getDamage(), 31 + this.rand.nextInt(4)));
                    continue;
                }
                ExplosionAttackGoal goal = (ExplosionAttackGoal)goalList.get(0).m_26015_();
                goal.clearInfo(31 + this.rand.nextInt(4), goal.damage * 1.1f);
            }
        }
    }

    @Override
    public void attackDamage(LivingEntity target, float dame, boolean isExtend) {
        super.attackDamage(target, dame, isExtend);
        this.addAttackEntity((Entity)target, (LivingEntity)this.m_19749_(), dame, (int)(this.getRange() / 4.0));
    }

    public float getDamageRate() {
        return switch (this.getData()) {
            case 1 -> 0.875f;
            case 2 -> 1.35f;
            case 3 -> 1.75f;
            default -> 0.5f;
        };
    }

    @Override
    protected void spawnParticle() {
        this.addParticle((ParticleOptions)ParticleInit.ORB, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0, 0.972549f, 0.1725490242242813);
    }

    @Override
    public SMElement getElement() {
        return SMElement.BLAST;
    }
}

