/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class GemShot
extends AbstractMagicShot {
    private static final EntityDataAccessor<Integer> GEM_TYPE = GemShot.setEntityData(ISMMob.INT);

    public GemShot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public GemShot(double x, double y, double z, Level world) {
        this(EntityInit.gemShot, world);
        this.m_6034_(x, y, z);
    }

    public GemShot(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.setGemType(this.rand.nextInt(3));
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(GEM_TYPE, 0);
    }

    public int getGemType() {
        return this.get(GEM_TYPE);
    }

    public void setGemType(int type) {
        this.set(GEM_TYPE, type);
    }

    @Override
    protected void entityHit(LivingEntity target) {
        this.rangeAttack(target.m_20183_(), this.getDamage(), this.getRange());
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        this.rangeAttack(result.m_82425_().m_7494_(), this.getDamage() * 0.67f, this.getRange() * (double)0.67f);
        this.m_146870_();
    }

    public void rangeAttack(BlockPos pos, float dame, double range) {
        List<LivingEntity> entityList;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            server.m_8767_((ParticleOptions)ParticleTypes.f_123812_, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), 2, 0.0, 0.0, 0.0, 0.0);
        }
        if ((entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range)).isEmpty()) {
            return;
        }
        double effectRange = range * range;
        this.m_5496_(SoundEvents.f_11913_, 3.0f, 1.0f / (this.rand.nextFloat() * 0.2f + 0.9f));
        for (LivingEntity entity : entityList) {
            if (!this.checkDistance(entity.m_20183_(), effectRange)) continue;
            this.attackDamage(entity, dame, false);
        }
    }

    @Override
    public void m_7380_(CompoundTag tags) {
        super.m_7380_(tags);
        tags.m_128405_("gemType", this.getGemType());
    }

    @Override
    public void m_7378_(CompoundTag tags) {
        super.m_7378_(tags);
        this.setGemType(tags.m_128451_("gemType"));
    }

    @Override
    protected void spawnParticle() {
        Vec3 vec = this.m_20184_();
        float addX = (float)(-vec.f_82479_) / 20.0f;
        float addY = (float)(-vec.f_82480_) / 20.0f;
        float addZ = (float)(-vec.f_82481_) / 20.0f;
        this.addParticle((ParticleOptions)ParticleInit.DIG, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), addX, addY, addZ);
    }

    @Override
    public SMElement getElement() {
        return SMElement.BLAST;
    }
}

