/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class GravityMagicShot
extends AbstractMagicShot {
    public GravityMagicShot(EntityType<? extends GravityMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public GravityMagicShot(double x, double y, double z, Level world) {
        this((EntityType<? extends GravityMagicShot>)EntityInit.gravityMagic, world);
        this.m_6034_(x, y, z);
    }

    public GravityMagicShot(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(info);
    }

    public GravityMagicShot(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
        this.setRange(5.0);
    }

    @Override
    protected void entityHit(LivingEntity living) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sever = (ServerLevel)level;
            Random rand = this.rand;
            for (int i = 0; i < 16; ++i) {
                float x = (float)(living.m_20185_() + (double)(rand.nextFloat() * 1.5f) - 0.5);
                float y = (float)(living.m_20186_() + (double)(rand.nextFloat() * 2.0f) - 0.5);
                float z = (float)(living.m_20189_() + (double)(rand.nextFloat() * 1.5f) - 0.75);
                sever.m_8767_((ParticleOptions)ParticleTypes.f_123799_, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.1f);
            }
        }
        int time = 60 * (this.getWandLevel() + 1);
        if (living instanceof Player && this.m_19749_() instanceof Player) {
            living.m_21195_(PotionInit.gravity);
        } else {
            this.addPotion(living, PotionInit.gravity, time, this.getData());
        }
        int data = this.getData();
        if (data < 1) {
            return;
        }
        if (data >= 2) {
            this.setLifeTime(0);
            this.setMaxLifeTime(data >= 3 ? 100 : 60);
        }
        float rate = this.getDamageRate();
        this.rangeAttack(living.m_20183_(), this.getDamage() * rate, this.getRange());
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        int data = this.getData();
        if (data >= 1) {
            if (data >= 2) {
                this.setLifeTime(0);
                this.setMaxLifeTime(data >= 3 ? 100 : 60);
            }
            float rate = data >= 2 ? 1.0f : 0.67f;
            float damageRate = this.getDamageRate() * 0.67f;
            this.rangeAttack(result.m_82425_().m_7494_(), this.getDamage() * damageRate, this.getRange() * (double)rate);
        }
        if (data < 2) {
            this.m_146870_();
        }
    }

    public void rangeAttack(BlockPos bPos, float dame, double range) {
        List<LivingEntity> entityList;
        int tick = this.getLifeTime();
        boolean isTier3 = !this.getHitDead();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (!isTier3 || tick % 10 == 0) {
                boolean isZero = this.getMaxLifeTime() == 100;
                double ySpeed = isZero ? 0.0 : -0.25;
                double yRate = isZero ? 0.0 : -0.6;
                double inRate = isZero ? 1.5 : 0.25;
                for (int i = 0; i < 4; ++i) {
                    this.spawnParticleRing(server, (ParticleOptions)ParticleInit.GRAVITY, range * (1.0 - 0.14 * (double)i), bPos.m_6630_(i + 1), ySpeed + (double)i * yRate, inRate);
                }
            }
        }
        if ((entityList = this.getEntityList(LivingEntity.class, this.isTarget(), range)).isEmpty()) {
            return;
        }
        Entity owner = this.m_19749_();
        int time = 60 * (this.getWandLevel() + 1);
        for (LivingEntity entity : entityList) {
            if (!this.canTargetEffect(entity, owner)) continue;
            if (!isTier3 || tick % 10 == 0) {
                this.attackDamage(entity, dame, false);
            }
            this.addPotion(entity, PotionInit.gravity, time, this.getData());
            Vec3 vec3 = new Vec3(entity.m_20185_() - this.m_20185_(), (entity.m_20186_() - this.m_20186_()) * 1.0, entity.m_20189_() - this.m_20189_()).m_82490_(-0.25);
            entity.m_20256_(entity.m_20184_().m_82549_(vec3));
            entity.f_19789_ = (float)((double)entity.f_19789_ + 0.5);
        }
    }

    @Override
    public void inGround() {
        if (this.getData() >= 2) {
            this.rangeAttack(this.m_20183_(), this.getData() >= 3 ? this.getDamage() * 0.1f : 1.0f, this.getRange());
        }
    }

    @Override
    protected void spawnParticleShort(ServerLevel sever, BlockPos pos) {
        float x = (float)pos.m_123341_() + this.getRandFloat(0.25f);
        float y = (float)pos.m_123342_() + this.getRandFloat(0.25f);
        float z = (float)pos.m_123343_() + this.getRandFloat(0.25f);
        for (int i = 0; i < 3; ++i) {
            sever.m_8767_((ParticleOptions)ParticleInit.GRAVITY, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.15f);
        }
    }

    @Override
    public int getMinParticleTick() {
        return 4;
    }

    @Override
    protected void spawnParticle() {
        Vec3 vec = this.m_20184_();
        float x = (float)(-vec.f_82479_) / 10.0f;
        float y = (float)(-vec.f_82480_) / 10.0f;
        float z = (float)(-vec.f_82481_) / 10.0f;
        Random rand = this.rand;
        for (int i = 0; i < 6; ++i) {
            float f1 = (float)(this.m_20185_() - 0.5 + (double)rand.nextFloat() + vec.f_82479_ * (double)i / 4.0);
            float f2 = (float)(this.m_20186_() - 0.25 + (double)(rand.nextFloat() * 0.5f) + vec.f_82480_ * (double)i / 4.0);
            float f3 = (float)(this.m_20189_() - 0.5 + (double)rand.nextFloat() + vec.f_82481_ * (double)i / 4.0);
            this.addParticle((ParticleOptions)ParticleInit.GRAVITY, f1, f2, f3, x + this.getRandFloat(0.075f), y + this.getRandFloat(0.075f), z + this.getRandFloat(0.075f));
        }
    }

    public float getDamageRate() {
        return switch (this.getData()) {
            case 2 -> 1.0f;
            case 3 -> 1.375f;
            default -> 0.67f;
        };
    }

    @Override
    public SMElement getElement() {
        return SMElement.GRAVITY;
    }
}

