/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.BlockInit;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.util.PlayerHelper;

public class LightMagicShot
extends AbstractMagicShot {
    public LightMagicShot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public LightMagicShot(double x, double y, double z, Level world) {
        this(EntityInit.lightMagic, world);
        this.m_6034_(x, y, z);
    }

    public LightMagicShot(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.stack = info.getStack();
    }

    public LightMagicShot(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void entityHit(LivingEntity living) {
        int time = 200 * this.getWandLevel();
        if (living instanceof Player && this.m_19749_() instanceof Player) {
            this.addPotion(living, MobEffects.f_19611_, time, 1);
        } else {
            this.addPotion(living, MobEffects.f_19619_, time, 1);
        }
        if (this.getData() <= 0) {
            return;
        }
        double range = this.getRange() / 0.67;
        float dame = 0.5f + 0.67f * (float)this.getWandLevel() * this.getDamageRate();
        this.rangeAttack(living.m_20183_(), dame, range);
    }

    @Override
    protected void m_8060_(BlockHitResult result) {
        if (!(this.m_19749_() instanceof Player)) {
            return;
        }
        if (this.getData() >= 1) {
            double range = this.getRange();
            float dame = 0.5f + 0.5f * (float)this.getWandLevel() * this.getDamageRate();
            this.rangeAttack(result.m_82425_().m_7494_(), dame, range);
            this.m_146870_();
            return;
        }
        BlockPos pos = result.m_82425_().m_121945_(result.m_82434_());
        BlockState state = this.m_9236_().m_8055_(pos);
        Block block = state.m_60734_();
        if (block == Blocks.f_50016_ || state.m_247087_()) {
            this.m_9236_().m_7731_(pos, BlockInit.magiclight.m_49966_(), 2);
        }
        this.m_146870_();
    }

    public void rangeAttack(BlockPos bPos, float dame, double range) {
        Object object;
        boolean isTier4;
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.isTarget(), this.getRange());
        int time = 200 * this.getWandLevel();
        int data = this.getData();
        boolean bl = isTier4 = data >= 3;
        if (isTier4 && (object = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel sever = (ServerLevel)object;
            float x = (float)bPos.m_123341_() + this.getRandFloat(0.5f);
            float y = (float)bPos.m_123342_() + this.getRandFloat(0.5f);
            float z = (float)bPos.m_123343_() + this.getRandFloat(0.5f);
            BlockPos pos = this.m_20183_();
            for (int ran = 0; ran < 3; ++ran) {
                for (int i = 0; i < 3; ++i) {
                    this.spawnParticleRingY(sever, (ParticleOptions)ParticleTypes.f_123744_, 2 + ran * 4, pos, 0.25, (double)i * 0.1);
                    this.spawnParticleRing(sever, (ParticleOptions)ParticleInit.MAGICLIGHT, 2 + ran * 4, pos, -0.25 + (double)i * 0.5);
                }
            }
        }
        int addAttack = 1;
        switch (data) {
            case 2: {
                addAttack = 3;
                break;
            }
            case 3: {
                addAttack = 5;
            }
        }
        for (LivingEntity entity : entityList) {
            if (isTier4) {
                List<MobEffectInstance> effecList = PlayerHelper.getEffectList(entity, PotionInit.BUFF);
                effecList.forEach(p -> entity.m_21195_(p.m_19544_()));
                this.addPotion(entity, PotionInit.flame, time, 0);
            }
            boolean hasGlow = entity.m_21023_(MobEffects.f_19619_);
            this.addPotion(entity, MobEffects.f_19619_, time, 1);
            this.attackDamage(entity, dame, false);
            if (!hasGlow) continue;
            this.addAttack(entity, dame, addAttack);
        }
    }

    @Override
    protected void spawnParticleShort(ServerLevel sever, BlockPos pos) {
        float x = (float)pos.m_123341_() + this.getRandFloat(0.25f);
        float y = (float)pos.m_123342_() + this.getRandFloat(0.25f);
        float z = (float)pos.m_123343_() + this.getRandFloat(0.25f);
        for (int i = 0; i < 3; ++i) {
            sever.m_8767_((ParticleOptions)ParticleInit.MAGICLIGHT, (double)x, (double)y, (double)z, 4, 0.0, 0.0, 0.0, (double)0.15f);
        }
    }

    @Override
    public int getMinParticleTick() {
        return 3;
    }

    @Override
    protected void spawnParticle() {
        Random rand = this.rand;
        Vec3 vec = this.m_20184_();
        float addX = (float)(-vec.f_82479_) / 20.0f;
        float addY = (float)(-vec.f_82480_) / 20.0f;
        float addZ = (float)(-vec.f_82481_) / 20.0f;
        for (int i = 0; i < 4; ++i) {
            float x = addX + this.getRandFloat(0.075f);
            float y = addY + this.getRandFloat(0.075f);
            float z = addZ + this.getRandFloat(0.075f);
            float f1 = (float)(this.m_20185_() - 0.5 + (double)rand.nextFloat() + vec.f_82479_ * (double)i / 4.0);
            float f2 = (float)(this.m_20186_() - 0.5 + (double)rand.nextFloat() + vec.f_82480_ * (double)i / 4.0);
            float f3 = (float)(this.m_20189_() - 0.5 + (double)rand.nextFloat() + vec.f_82481_ * (double)i / 4.0);
            this.addParticle((ParticleOptions)ParticleInit.MAGICLIGHT, f1, f2, f3, x, y, z);
        }
    }

    public float getDamageRate() {
        return switch (this.getData()) {
            case 0 -> 1.0f;
            case 1 -> 1.5f;
            case 3 -> 3.5f;
            default -> 2.0f;
        };
    }

    @Override
    public SMElement getElement() {
        return SMElement.SHINE;
    }
}

