/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class LigningBulletShot
extends AbstractMagicShot {
    private static final EntityDataAccessor<Integer> TARGET = LigningBulletShot.setEntityData(ISMMob.INT);

    public LigningBulletShot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public LigningBulletShot(double x, double y, double z, Level world) {
        this(EntityInit.ligningBullet, world);
        this.m_6034_(x, y, z);
    }

    public LigningBulletShot(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(info);
    }

    public LigningBulletShot(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
        this.setRange(5.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.define(TARGET, -1);
    }

    @Override
    public void m_8119_() {
        Entity target = this.getTarget();
        if (target != null && !target.m_6084_()) {
            target = null;
            this.setTarget(null);
        }
        if (target != null) {
            Vec3 vec = this.m_20184_();
            double mX = vec.m_7096_();
            double mY = vec.m_7098_();
            double mZ = vec.m_7094_();
            Vec3 arrowVec = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            Vec3 lookVec = new Vec3(target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_()).m_82546_(arrowVec);
            Vec3 arrowMotion = new Vec3(mX, mY, mZ);
            double theta = this.wrap180Radian(this.angleBetween(arrowMotion, lookVec));
            theta = this.clampAbs(theta, 1.5707963267948966);
            Vec3 crossVec = arrowMotion.m_82537_(lookVec).m_82541_();
            Vec3 adjustedVec = this.transform(crossVec, theta, arrowMotion);
            this.m_6686_(adjustedVec.f_82479_, adjustedVec.f_82480_, adjustedVec.f_82481_, 1.0f, 0.0f);
            this.m_20256_(this.m_20184_().m_82490_(0.625));
        }
        super.m_8119_();
    }

    @Override
    protected void spawnParticle() {
        this.addParticle((ParticleOptions)ParticleInit.MAGICLIGHT, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
    }

    @Nullable
    private Entity getTarget() {
        return this.m_9236_().m_6815_(this.get(TARGET).intValue());
    }

    public void setTarget(Entity entity) {
        this.set(TARGET, entity == null ? -1 : entity.m_19879_());
    }

    @Override
    public SMElement getElement() {
        return SMElement.LIGHTNING;
    }
}

