/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.iitem.IMagicItem;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ItemInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.util.RenderUtil;
import sweetmagic.util.SMUtil;

public class MagicSquareMagic
extends AbstractMagicShot {
    private RenderUtil.RenderColor color = null;
    private List<LivingEntity> mobList = new ArrayList<LivingEntity>();
    private List<LivingEntity> enemyList = new ArrayList<LivingEntity>();
    private List<Item> rainMagicList = Arrays.asList(ItemInit.magic_rainfield, ItemInit.magic_rainfield2, ItemInit.magic_rainfield3, ItemInit.magic_rainfield4);

    public MagicSquareMagic(EntityType<? extends MagicSquareMagic> entityType, Level world) {
        super(entityType, world);
    }

    public MagicSquareMagic(double x, double y, double z, Level world) {
        this((EntityType<? extends MagicSquareMagic>)EntityInit.magicSquare, world);
        this.m_6034_(x, y, z);
    }

    public MagicSquareMagic(Level world, LivingEntity entity, WandInfo info) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(info);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(new Vec3(0.0, 0.0, 0.0));
        this.tickSpawnParticle();
        this.tickEffect();
    }

    @Override
    protected void tickDespawn() {
        if (this.getLifeTime() >= this.getMaxLifeTime()) {
            this.actionEffect(true);
        }
        super.tickDespawn();
    }

    public void tickSpawnParticle() {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        SimpleParticleType par = null;
        int data = this.getData();
        switch (data) {
            case 0: {
                par = ParticleInit.GRAVITY_FIELD;
                break;
            }
            case 1: {
                par = ParticleInit.WIND_FIELD;
                break;
            }
            case 2: {
                par = ParticleInit.RAIN_FIELD;
                break;
            }
            case 3: {
                par = ParticleInit.DIVINE;
                break;
            }
            case 4: {
                par = ParticleInit.REFLASH;
            }
        }
        this.spawnParticle(server, (ParticleOptions)par, data, (int)this.getRange());
    }

    public void spawnParticle(ServerLevel server, ParticleOptions par, int data, int scale) {
        double range = (double)(scale * scale) / 3.0;
        double posY = data == 2 ? this.m_20186_() + 4.0 : this.m_20186_();
        float addY = 0.0f;
        for (int addX = -scale; addX <= scale; ++addX) {
            for (int addZ = -scale; addZ <= scale; ++addZ) {
                int posZ;
                int posX;
                if (this.rand.nextFloat() >= 0.0125f || this.m_20275_(posX = (int)(this.m_20185_() + (double)addX), posY, posZ = (int)(this.m_20189_() + (double)addZ)) > range) continue;
                if (data == 2) {
                    addY = -0.45f - this.rand.nextFloat() * 0.3f;
                }
                float x = (float)posX - 0.5f + this.rand.nextFloat() * 0.5f;
                float y = (float)posY + 0.25f;
                float z = (float)posZ - 0.5f + this.rand.nextFloat() * 0.5f;
                float ax = this.getRandFloat(this.rand) * 0.075f;
                float ay = this.rand.nextFloat() * 0.1f + 0.05f + addY;
                float az = this.getRandFloat(this.rand) * 0.075f;
                server.m_8767_(par, (double)x, (double)y, (double)z, 0, (double)ax, (double)ay, (double)az, 1.0);
            }
        }
    }

    public void tickEffect() {
        if (this.f_19797_ % 10 != 0) {
            return;
        }
        this.actionEffect(false);
    }

    public void actionEffect(boolean isFinish) {
        double range = this.getRange() / 2.0 * 1.1;
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, (T e) -> e.m_6084_() && (double)this.m_20270_((Entity)e) <= range, range);
        if (entityList.isEmpty()) {
            return;
        }
        int data = this.getData();
        int tier = this.getTier();
        for (LivingEntity entity : entityList) {
            boolean isEnmy = entity instanceof Enemy;
            switch (data) {
                case 0: {
                    this.gravityField(entity, isEnmy, isFinish, data, tier);
                    break;
                }
                case 1: {
                    this.windField(entity, isEnmy, isFinish, data, tier);
                    break;
                }
                case 2: {
                    this.rainField(entity, isEnmy, isFinish, data, tier);
                    break;
                }
                case 3: {
                    this.futureVisionField(entity, isEnmy, isFinish, data, tier);
                    break;
                }
                case 4: {
                    this.reflashField(entity, isEnmy, isFinish, data, tier);
                }
            }
        }
    }

    public void gravityField(LivingEntity entity, boolean isEnemy, boolean isFinish, int data, int tier) {
        int addLevel;
        if (isFinish && isEnemy) {
            int addLevel2 = this.getHourGlass() ? 1 : 0;
            this.addPotion(entity, PotionInit.gravity, 1200 + tier * 600, addLevel2);
            float dame = 3.0f + (float)this.getWandLevel();
            this.attackDamage(entity, dame, false);
            return;
        }
        if (this.f_19797_ % 20 != 0) {
            return;
        }
        int n = addLevel = this.getHourGlass() ? 1 : 0;
        if (isEnemy && !this.enemyList.contains(entity)) {
            this.enemyList.add(entity);
            this.addPotion(entity, PotionInit.gravity, 1200 + tier * 600, tier - 1 + addLevel);
            if (tier >= 2) {
                this.addPotion(entity, MobEffects.f_19597_, 1200 + tier * 600, tier - 1 + addLevel);
            }
            if (tier >= 3) {
                this.addPotion(entity, PotionInit.debuff_extension, 1200 + tier * 600, tier - 1 + addLevel);
            }
        }
        if (!isEnemy && !this.mobList.contains(entity)) {
            this.addPotion(entity, PotionInit.damage_cut, 1200 + tier * 600, tier - 1 + addLevel);
            this.mobList.add(entity);
        }
    }

    public void windField(LivingEntity entity, boolean isEnemy, boolean isFinish, int data, int tier) {
        if (isFinish && isEnemy) {
            int addLevel = this.getHourGlass() ? 1 : 0;
            this.addPotion(entity, PotionInit.bleeding, 1200 + tier * 600, addLevel);
            float dame = 3.0f + (float)this.getWandLevel();
            this.attackDamage(entity, dame, false);
            return;
        }
        if (this.f_19797_ % 20 != 0) {
            return;
        }
        if (!isEnemy && !this.mobList.contains(entity)) {
            int addLevel = this.getHourGlass() ? 1 : 0;
            this.addPotion(entity, PotionInit.attack_disable, 221, tier - 1 + addLevel);
            this.mobList.add(entity);
        }
        if (!isEnemy) {
            entity.m_5634_(1.0f);
        }
    }

    public void rainField(LivingEntity entity, boolean isEnemy, boolean isFinish, int data, int tier) {
        int addLevel;
        if (isFinish && entity instanceof Player) {
            Player player = (Player)entity;
            Predicate<ItemStack> flag = s -> !this.rainMagicList.contains(s.m_41720_());
            List<ItemStack> magicList = IWand.getMagicList(IWand.getWandList(player), flag);
            float value = 12.5f * (float)tier * 0.01f;
            float bossValue = 6.25f * (float)tier * 0.01f;
            for (ItemStack stack : magicList) {
                IMagicItem magic = new MagicInfo(stack).getMagicItem();
                int recast = magic.getRecastTime(stack);
                if (recast <= 0) continue;
                float healValue = magic.isUniqueMagic() ? bossValue : value;
                magic.setRecastTime(stack, Math.max(0, (int)((float)recast - (float)magic.getMaxRecastTime() * healValue)));
            }
            return;
        }
        if (this.f_19797_ % 20 != 0) {
            return;
        }
        int n = addLevel = this.getHourGlass() ? 1 : 0;
        if (isEnemy && !this.enemyList.contains(entity)) {
            this.addPotion(entity, PotionInit.magic_damage_receive, 1200 + tier * 600, tier - 1 + addLevel);
            this.enemyList.add(entity);
        } else if (!isEnemy && !this.mobList.contains(entity)) {
            this.addPotion(entity, PotionInit.magic_damage_cause, 1200 + tier * 600, tier - 1 + addLevel);
            this.mobList.add(entity);
        }
    }

    public void futureVisionField(LivingEntity entity, boolean isEnemy, boolean isFinish, int data, int tier) {
        if (isFinish && isEnemy && entity instanceof Mob) {
            Mob mob = (Mob)entity;
            SMUtil.tameAIDonmov(mob, 20 * tier);
            return;
        }
        if (this.f_19797_ % 20 != 0) {
            return;
        }
        if (isEnemy) {
            if (this.enemyList.contains(entity) || !(entity instanceof Mob)) {
                return;
            }
            Mob mob = (Mob)entity;
            int rate = entity instanceof Warden ? 3 : 1;
            SMUtil.tameAIDonmov(mob, (40 + (tier - 1) * 30) * rate);
            this.enemyList.add(entity);
        } else {
            if (this.mobList.contains(entity)) {
                return;
            }
            int addLevel = this.getHourGlass() ? 1 : 0;
            this.addPotion(entity, PotionInit.future_vision, 1200 * (1 + addLevel), tier - 1 + addLevel);
            this.mobList.add(entity);
        }
    }

    public void reflashField(LivingEntity entity, boolean isEnemy, boolean isFinish, int data, int tier) {
        if (isFinish && !isEnemy) {
            entity.m_5634_(entity.m_21233_());
            int addLevel = this.getHourGlass() ? 1 : 0;
            this.addPotion(entity, PotionInit.reflash_effect, 2400, tier - 1 + addLevel);
            return;
        }
        if (this.f_19797_ % 20 != 0 || isEnemy) {
            return;
        }
        if (!this.mobList.contains(entity)) {
            this.addPotion(entity, PotionInit.resurrection, 1200 + data * 600, 0);
            this.mobList.add(entity);
        }
        int addLevel = this.getHourGlass() ? 1 : 0;
        this.addPotion(entity, PotionInit.reflash_effect, 600, tier - 1 + addLevel);
        entity.m_5634_(0.5f);
    }

    public float getRandFloat(Random rand) {
        return rand.nextFloat() - rand.nextFloat();
    }

    public RenderUtil.RenderColor getColor(int light) {
        if (this.color == null) {
            switch (this.getData()) {
                case 0: {
                    this.color = new RenderUtil.RenderColor(1.0f, 0.5176471f, 0.19607843f, light, OverlayTexture.f_118083_);
                    break;
                }
                case 1: {
                    this.color = new RenderUtil.RenderColor(0.3137255f, 0.7254902f, 0.23137255f, light, OverlayTexture.f_118083_);
                    break;
                }
                case 2: {
                    this.color = new RenderUtil.RenderColor(0.39607844f, 0.9137255f, 0.8980392f, light, OverlayTexture.f_118083_);
                    break;
                }
                case 3: {
                    this.color = new RenderUtil.RenderColor(1.0f, 1.0f, 0.47058824f, light, OverlayTexture.f_118083_);
                    break;
                }
                case 4: {
                    this.color = new RenderUtil.RenderColor(0.3137255f, 1.0f, 0.9372549f, light, OverlayTexture.f_118083_);
                }
            }
        }
        return this.color;
    }

    @Override
    public SMElement getElement() {
        return SMElement.NON;
    }
}

