/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class TripleTornadoShot
extends AbstractMagicShot {
    public boolean isPlayer = false;

    public TripleTornadoShot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
        this.setMaxLifeTime(80);
    }

    public TripleTornadoShot(double x, double y, double z, Level world) {
        this(EntityInit.tripleTornado, world);
        this.m_6034_(x, y, z);
    }

    public TripleTornadoShot(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_20256_(new Vec3(0.0, 0.0, 0.0));
        this.tickEffect();
    }

    public void tickEffect() {
        SimpleParticleType par;
        Level level;
        BlockPos pos = this.m_20183_();
        double range = this.getRange() / 2.0;
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer, pos, range), range);
        entityList.forEach(e -> {
            if (!(e instanceof Player)) {
                this.addPotion((LivingEntity)e, MobEffects.f_19597_, 60, 4);
            }
        });
        if (this.f_19797_ % 5 == 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel sever = (ServerLevel)level;
            double scaleRate = Math.min(1.0, (double)this.f_19797_ * 0.05);
            double scale = range * scaleRate;
            par = ParticleInit.CYCLE_TORNADO;
            for (double i = scale; i > 1.0; i -= 2.0) {
                this.spawnParticleCycle((ParticleOptions)par, pos, i);
            }
            if (this.f_19797_ % 10 == 0) {
                this.m_5496_(SoundEvents.f_11705_, 0.67f, 1.15f);
            }
        }
        if (this.f_19797_ >= this.getMaxLifeTime()) {
            float damage = this.getDamage();
            attackList = this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer, pos, range), range);
            attackList.forEach(e -> this.attackDamage((LivingEntity)e, e instanceof Enemy ? damage * 2.0f : damage, false));
            Level scale = this.m_9236_();
            if (scale instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)scale;
                Iterable<BlockPos> posList = this.getPosList(pos, range);
                Random rand = this.rand;
                par = ParticleTypes.f_123810_;
                for (BlockPos p : posList) {
                    if (rand.nextFloat() >= 0.075f || !this.checkDistances(pos, p, range * range)) continue;
                    float x = (float)p.m_123341_() + rand.nextFloat() - 0.5f;
                    float y = (float)p.m_123342_() + rand.nextFloat() - 0.5f;
                    float z = (float)p.m_123343_() + rand.nextFloat() - 0.5f;
                    sever.m_8767_((ParticleOptions)par, (double)x, (double)y, (double)z, 0, (double)this.getRandFloat(0.5f), (double)(rand.nextFloat() * 0.5f), (double)this.getRandFloat(0.5f), 1.0);
                }
            }
            this.m_5496_(SoundEvents.f_11892_, 2.0f, 1.0f);
            this.m_146870_();
        } else if (this.f_19797_ > 20 && this.f_19797_ % 10 == 0) {
            float damage = this.getDamage() / 20.0f;
            attackList = this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer, this.m_20183_(), range), range);
            for (LivingEntity entity : attackList) {
                this.addPotion(entity, PotionInit.resistance_blow, 11, 5);
                this.attackDamage(entity, damage, false);
            }
        }
    }

    public Predicate<LivingEntity> getFilter(boolean isPlayer, BlockPos pos, double range) {
        Entity owner = this.m_19749_();
        if (owner != null && owner instanceof Player) {
            return e -> e.m_6084_() && e instanceof Enemy && this.checkDistances(pos, e.m_20183_(), range * range);
        }
        return e -> !e.m_5833_() && e.m_6084_() && (isPlayer ? e instanceof Player || e instanceof AbstractSummonMob : !(e instanceof Player)) && !(e instanceof ISMMob) && this.checkDistances(pos, e.m_20183_(), range * range);
    }

    protected void spawnParticleCycle(ParticleOptions par, BlockPos pos, double range) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        int count = 16;
        Random rand = new Random();
        for (int i = 0; i < count; ++i) {
            this.spawnParticleCycle(server, par, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.5 + rand.nextDouble() * 1.5, (double)pos.m_123343_() + 0.5, Direction.UP, range, (float)i * 16.0f, false);
        }
    }

    protected void spawnParticleCycle(ServerLevel server, ParticleOptions par, double x, double y, double z, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 1;
        server.m_8767_(par, x, y, z, 0, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * 6.0f) - (double)(this.f_19797_ * 5), 1.0);
    }

    @Override
    public SMElement getElement() {
        return SMElement.CYCLON;
    }
}

