/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.List;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractMagicShot;
import sweetmagic.util.PlayerHelper;

public class TwiLightShot
extends AbstractMagicShot {
    public TwiLightShot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public TwiLightShot(double x, double y, double z, Level world) {
        this(EntityInit.twiLightShot, world);
        this.m_6034_(x, y, z);
    }

    public TwiLightShot(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    protected void entityHit(LivingEntity target) {
        List<MobEffectInstance> effecList = PlayerHelper.getEffectList(target, PotionInit.BUFF);
        for (MobEffectInstance ins : effecList) {
            MobEffect effect = ins.m_19544_();
            int time = ins.m_19564_();
            int level = ins.m_19557_();
            target.m_21195_(effect);
            this.addPotion(target, effect, time / 2, level);
        }
    }

    @Override
    protected void spawnParticle() {
        Random rand = this.rand;
        Vec3 vec = this.m_20184_();
        float addX = (float)(-vec.f_82479_) / 20.0f;
        float addY = (float)(-vec.f_82480_) / 20.0f;
        float addZ = (float)(-vec.f_82481_) / 20.0f;
        for (int i = 0; i < 4; ++i) {
            float x = addX + this.getRandFloat(0.075f);
            float y = addY + this.getRandFloat(0.075f);
            float z = addZ + this.getRandFloat(0.075f);
            float f1 = (float)(this.m_20185_() - 0.5 + (double)rand.nextFloat() + vec.f_82479_ * (double)i / 4.0);
            float f2 = (float)(this.m_20186_() - 0.5 + (double)rand.nextFloat() + vec.f_82480_ * (double)i / 4.0);
            float f3 = (float)(this.m_20189_() - 0.5 + (double)rand.nextFloat() + vec.f_82481_ * (double)i / 4.0);
            this.addParticle((ParticleOptions)ParticleInit.TWILIGHTLIGHT, f1, f2, f3, x, y, z);
        }
    }

    @Override
    public SMElement getElement() {
        return SMElement.TIME;
    }
}

