/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.entity.projectile;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.ientity.ISMMob;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.EntityInit;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.entity.projectile.AbstractBossMagic;
import sweetmagic.init.entity.projectile.AbstractMagicShot;

public class WindStormShot
extends AbstractMagicShot {
    public boolean isPlayer = false;
    private List<LivingEntity> targetList = new ArrayList<LivingEntity>();

    public WindStormShot(EntityType<? extends AbstractMagicShot> entityType, Level world) {
        super(entityType, world);
    }

    public WindStormShot(double x, double y, double z, Level world) {
        this(EntityInit.windBlast, world);
        this.m_6034_(x, y, z);
    }

    public WindStormShot(Level world, LivingEntity entity, AbstractBossMagic magic, WandInfo info) {
        this(magic.m_20185_(), magic.m_20188_() - (double)0.1f, magic.m_20189_(), world);
        this.m_5602_((Entity)entity);
        this.setWandInfo(info);
        this.setRange(6.0);
    }

    public WindStormShot(LivingEntity entity) {
        this(entity.m_20185_(), entity.m_20188_() - (double)0.1f, entity.m_20189_(), entity.m_9236_());
        this.m_5602_((Entity)entity);
        this.stack = ItemStack.f_41583_;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.rangeAttack(this.m_20183_(), this.getDamage(), this.getRange());
    }

    public void rangeAttack(BlockPos pos, float dame, double range) {
        int data = this.getData();
        if (data == 1) {
            dame *= 1.25f;
            range *= 1.25;
        }
        int addLevel = 1;
        int time = 600;
        List<LivingEntity> entityList = this.getEntityList(LivingEntity.class, this.getFilter(this.isPlayer, pos, range), range);
        for (LivingEntity target : entityList) {
            int level;
            this.attackDamage(target, dame, false);
            if (data != 1) continue;
            int n = level = target.m_21023_(PotionInit.bleeding) ? target.m_21124_(PotionInit.bleeding).m_19564_() + addLevel : addLevel - 1;
            if (level > 0) {
                target.m_21195_(PotionInit.bleeding);
            }
            this.addPotion(target, PotionInit.bleeding, time, Math.max(0, level));
        }
    }

    @Override
    protected void spawnParticle() {
        Vec3 vec = this.m_20184_();
        SimpleParticleType par = ParticleTypes.f_123796_;
        for (int i = 0; i < 8; ++i) {
            for (int k = -4; k < 8; ++k) {
                float x = (float)(vec.f_82479_ / 10.0) * this.getRandFloat(1.5f);
                float y = (float)(vec.f_82480_ / 10.0) + 0.5f * this.getRandFloat(0.5f);
                float z = (float)(vec.f_82481_ / 10.0) * this.getRandFloat(1.5f);
                this.addParticle((ParticleOptions)par, this.m_20185_() + (double)this.getRandFloat(1.0f), this.m_20186_() + 0.5 + (double)k + (double)this.getRandFloat(0.5f), this.m_20189_() + (double)this.getRandFloat(1.0f), x, y, z);
            }
        }
    }

    public Predicate<LivingEntity> getFilter(boolean isPlayer, BlockPos pos, double range) {
        return e -> !e.m_5833_() && e.m_6084_() && (isPlayer ? e instanceof Player : !(e instanceof Player)) && !(e instanceof ISMMob) && this.checkDistances(pos, e.m_20183_(), range * range) && !this.targetList.contains(e);
    }

    @Override
    public boolean checkDistances(BlockPos basePos, BlockPos pos, double range) {
        double z;
        double x = basePos.m_123341_() - pos.m_123341_();
        return x * x + (z = (double)(basePos.m_123343_() - pos.m_123343_())) * z <= range;
    }

    @Override
    public AABB getAABB(double range) {
        return this.getAABB(range, range * 8.0, range);
    }

    protected void spawnParticleCycle(BlockPos pos, double range) {
        Level level = this.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        SimpleParticleType par = ParticleInit.CYCLE_TORNADO;
        for (int i = 0; i < 16; ++i) {
            this.spawnParticleCycle(server, (ParticleOptions)par, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() - 0.5 + this.rand.nextDouble() * 1.5, (double)pos.m_123343_() + 0.5, Direction.UP, range, (float)i * 16.0f, false);
        }
    }

    protected void spawnParticleCycle(ServerLevel server, ParticleOptions par, double x, double y, double z, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 1;
        server.m_8767_(par, x, y, z, 0, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * 6.0f) - (double)(this.f_19797_ * 5), 1.0);
    }

    @Override
    public SMElement getElement() {
        return SMElement.CYCLON;
    }
}

