/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.emagic.SMMagicType;
import sweetmagic.api.iblock.ISMCrop;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.SoundInit;
import sweetmagic.init.TagInit;
import sweetmagic.init.entity.projectile.ElectricMagicShot;
import sweetmagic.init.item.magic.BaseMagicItem;
import sweetmagic.init.item.sm.SMItem;

public class ChargeMagic
extends BaseMagicItem {
    public final int data;

    public ChargeMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data) {
        super(name, SMMagicType.CHARGE, ele, tier, coolTime, useMF, false);
        this.data = data;
    }

    public ChargeMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data, String iconName) {
        super(name, SMMagicType.CHARGE, ele, tier, coolTime, useMF, false, iconName);
        this.data = data;
    }

    @Override
    public List<MutableComponent> magicToolTip(List<MutableComponent> toolTip) {
        switch (this.data) {
            case 0: 
            case 1: {
                toolTip.add(this.getText("magic_lightningbolt", new Object[]{this.format((int)this.getBaseRange()), this.getMaxThunder()}));
                toolTip.add(this.getText("magic_thunder_common", new Object[]{this.format((float)Math.sqrt(this.getBaseRange())), this.getMaxTarget()}));
                break;
            }
            case 6: 
            case 8: {
                toolTip.add(this.getText("magic_lightningbolt", new Object[]{this.format((int)this.getBaseRange()), this.getMaxThunder()}));
                toolTip.add(this.getText("magic_thunder_common", new Object[]{this.format((float)Math.sqrt(this.getBaseRange())), this.getMaxTarget()}));
                toolTip.add(this.getText("magic_thunderrain_vulnerable"));
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 9: {
                toolTip.add(this.getText("magic_growth_effect", new Object[]{switch (this.getTier()) {
                    case 2 -> 7;
                    case 3 -> 15;
                    case 4 -> 25;
                    default -> 2;
                }}));
                break;
            }
            default: {
                toolTip.add(this.getText(this.name));
            }
        }
        return toolTip;
    }

    @Override
    public boolean onItemAction(Level world, Player player, WandInfo wInfo, MagicInfo mInfo) {
        ItemStack stack = wInfo.getStack();
        return switch (this.data) {
            case 1 -> this.elecAction(world, player, stack, wInfo);
            case 2 -> this.glowRangeAction(world, player, stack, wInfo);
            case 3 -> this.glowRangeAction(world, player, stack, wInfo);
            case 6 -> this.elecAction(world, player, stack, wInfo);
            case 7 -> this.glowRangeAction(world, player, stack, wInfo);
            case 8 -> this.elecAction(world, player, stack, wInfo);
            case 9 -> this.glowRangeAction(world, player, stack, wInfo);
            default -> this.elecAction(world, player, stack, wInfo);
        };
    }

    public boolean elecAction(Level world, Player player, ItemStack stack, WandInfo info) {
        List<LivingEntity> targetList;
        if (world.m_5776_()) {
            return true;
        }
        int data = this.getThunderData();
        double baseRange = this.getBaseRange();
        int maxThunder = this.getMaxThunder();
        int maxTarget = this.getMaxTarget();
        double range = baseRange * (double)(1.0f + (float)this.getExtensionRingCount(player) * 0.25f);
        float addDameRate = 1.0f;
        int bloodCount = this.getBloodSuckingRing(player);
        if (bloodCount > 0 && player.m_21223_() > (float)(1 + bloodCount)) {
            addDameRate += (float)bloodCount * 0.2f;
            if (!player.m_7500_()) {
                player.m_21153_(Math.max(1.0f, player.m_21223_() - (float)bloodCount));
            }
        }
        if ((targetList = this.getEntityList(LivingEntity.class, (Entity)player, e -> this.canTargetEffect((LivingEntity)e, (LivingEntity)player), range)).isEmpty()) {
            return false;
        }
        range = Math.sqrt(range);
        float powerRate = 0.0f;
        switch (data) {
            case 1: {
                powerRate = 3.0f;
                break;
            }
            case 2: {
                powerRate = 6.0f;
                break;
            }
            case 3: {
                powerRate = 9.0f;
            }
        }
        float power = this.getPower(info) + powerRate;
        for (int i = 0; i < Math.min(maxThunder, targetList.size()); ++i) {
            LivingEntity entity = targetList.get(i);
            ElectricMagicShot magic = new ElectricMagicShot(world, (LivingEntity)player, info);
            magic.setAddDamage(magic.getAddDamage());
            magic.setRange(range);
            magic.setMaxCount(maxTarget);
            magic.setData(data);
            magic.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 0.0f, 0.0f);
            magic.m_6034_(entity.m_20185_(), entity.m_20186_() + 2.0, entity.m_20189_());
            magic.setAddDamage((magic.getAddDamage() + power) * addDameRate);
            magic.m_20256_(new Vec3(0.0, -0.5, 0.0));
            world.m_7967_((Entity)magic);
        }
        this.playSound(world, (LivingEntity)player, SoundEvents.f_11705_, 0.5f, 0.67f);
        return true;
    }

    public boolean glowRangeAction(Level world, Player player, ItemStack stack, WandInfo info) {
        boolean isGlow = false;
        int range = 0;
        switch (this.data) {
            case 2: {
                range = 2;
                break;
            }
            case 3: {
                range = 7;
                break;
            }
            case 7: {
                range = 15;
                break;
            }
            case 9: {
                range = 25;
            }
        }
        if (!(world instanceof ServerLevel)) {
            return true;
        }
        ServerLevel server = (ServerLevel)world;
        RandomSource rand = server.m_213780_();
        range = (int)((float)range * (1.0f + (float)this.getExtensionRingCount(player) * 0.25f));
        Iterable posList = this.getRangePos(player.m_20183_(), range);
        for (BlockPos pos : posList) {
            BlockState newState;
            int i;
            Block block;
            BlockState state = world.m_8055_(pos);
            if (state.m_60795_() || !((block = state.m_60734_()) instanceof BonemealableBlock)) continue;
            BonemealableBlock crop = (BonemealableBlock)block;
            if (state.m_204336_(BlockTags.f_144274_)) continue;
            boolean isBone = false;
            boolean isSMCrop = block instanceof ISMCrop;
            for (i = 0; i < 8 && (newState = world.m_8055_(pos)).m_60734_() instanceof BonemealableBlock && (crop.m_7370_((LevelReader)world, pos, newState, true) || isSMCrop); ++i) {
                crop.m_214148_(server, rand, pos, newState);
                isBone = true;
                isGlow = true;
            }
            if (!isBone) continue;
            for (i = 0; i < 8; ++i) {
                double x = (double)pos.m_123341_() + rand.m_188500_() - 0.0;
                double y = (double)pos.m_123342_() + rand.m_188500_() * 0.4 + 0.2;
                double z = (double)pos.m_123343_() + rand.m_188500_() - 0.0;
                server.m_8767_((ParticleOptions)ParticleTypes.f_123748_, x, y, z, 5, 0.0, 0.0, 0.0, 0.25);
            }
        }
        if (isGlow) {
            this.playSound(world, (LivingEntity)player, SoundInit.GROW, 0.1f, 1.0f);
        }
        return true;
    }

    public int sortEntity(Entity mob, Entity entity1, Entity entity2) {
        double distance2;
        if (entity1 == null || entity2 == null) {
            return 0;
        }
        boolean isBoss1 = entity1.m_6095_().m_204039_(TagInit.BOSS);
        boolean isBoss2 = entity2.m_6095_().m_204039_(TagInit.BOSS);
        if (isBoss1 && isBoss2) {
            return 0;
        }
        if (isBoss1) {
            return -1;
        }
        if (isBoss2) {
            return 1;
        }
        double distance1 = mob.m_20280_(entity1);
        if (distance1 > (distance2 = mob.m_20280_(entity2))) {
            return 1;
        }
        if (distance1 < distance2) {
            return -1;
        }
        return 0;
    }

    public int getThunderData() {
        return switch (this.data) {
            case 1 -> 1;
            case 6 -> 2;
            case 8 -> 3;
            default -> 0;
        };
    }

    public double getBaseRange() {
        return switch (this.getThunderData()) {
            case 1 -> 16.0;
            case 2 -> 24.0;
            case 3 -> 32.0;
            default -> 9.0;
        };
    }

    public int getMaxThunder() {
        return switch (this.getThunderData()) {
            case 1 -> 7;
            case 2 -> 10;
            case 3 -> 15;
            default -> 5;
        };
    }

    public int getMaxTarget() {
        return switch (this.getThunderData()) {
            case 1 -> 5;
            case 2 -> 9;
            case 3 -> 12;
            default -> 3;
        };
    }

    @Override
    protected void spawnParticleCycle(ServerLevel server, ParticleOptions par, double x, double y, double z, Direction face, double range, double angle, boolean isRevese) {
        int way = isRevese ? -1 : 1;
        server.m_8767_(par, x, y, z, 0, (double)(face.m_122411_() * way), range, angle + (double)((float)(way * 1) * SMItem.SPEED), 1.0);
    }
}

