/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.emagic.SMMagicType;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.ItemInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.projectile.AbstractBossMagic;
import sweetmagic.init.entity.projectile.CherryRainMagic;
import sweetmagic.init.entity.projectile.FrostLaserMagic;
import sweetmagic.init.entity.projectile.HolyBusterMagic;
import sweetmagic.init.entity.projectile.IgnisBlastMagic;
import sweetmagic.init.entity.projectile.InfinitWandMagic;
import sweetmagic.init.entity.projectile.WindStormMagic;
import sweetmagic.init.item.magic.BaseMagicItem;
import sweetmagic.util.PlayerHelper;

public class SummonBossMagic
extends BaseMagicItem {
    public final int data;

    public SummonBossMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data) {
        super(name, SMMagicType.SUMMON, ele, tier, coolTime, useMF, false);
        this.data = data;
    }

    public SummonBossMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data, String iconName) {
        super(name, SMMagicType.SUMMON, ele, tier, coolTime, useMF, false, iconName);
        this.data = data;
    }

    @Override
    public List<MutableComponent> magicToolTip(List<MutableComponent> toolTip) {
        if (this.data <= 4) {
            toolTip.add(this.getText(this.name));
        } else {
            switch (this.data) {
                case 5: {
                    toolTip.add(this.getText(this.name));
                    toolTip.add(this.getText(this.name + "_buff"));
                    break;
                }
                case 6: {
                    toolTip.add(this.getText("magic_frostlaser"));
                    toolTip.add(this.getText(this.name));
                    toolTip.add(this.getText(this.name + "_buff"));
                    break;
                }
                case 7: {
                    toolTip.add(this.getText("magic_holybuster"));
                    toolTip.add(this.getText(this.name));
                    toolTip.add(this.getText(this.name + "_buff"));
                    break;
                }
                case 8: {
                    toolTip.add(this.getText("magic_ignisblast"));
                    toolTip.add(this.getText(this.name));
                    toolTip.add(this.getText(this.name + "_buff"));
                    break;
                }
                case 9: {
                    toolTip.add(this.getText("magic_windstorm"));
                    toolTip.add(this.getText(this.name));
                    toolTip.add(this.getText(this.name + "_buff"));
                    break;
                }
                case 10: {
                    toolTip.add(this.getText("magic_cherryrain"));
                    toolTip.add(this.getText(this.name));
                    toolTip.add(this.getText(this.name + "_buff"));
                }
            }
        }
        return toolTip;
    }

    @Override
    public boolean onItemAction(Level world, Player player, WandInfo wandInfo, MagicInfo info) {
        this.bossMagicAction(world, player, wandInfo);
        this.playSound(world, player.m_20183_(), SoundInit.HORAMAGIC, 0.1f, 1.0f);
        return true;
    }

    public boolean bossMagicAction(Level world, Player player, WandInfo info) {
        Item item;
        Vec3 src = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_()).m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 look = player.m_20252_(1.0f);
        Vec3 dest = src.m_82520_(look.f_82479_ * 3.0, player.m_20186_(), look.f_82481_ * 3.0);
        BlockPos pos = new BlockPos((int)dest.f_82479_, (int)player.m_20186_() + 1, (int)dest.f_82481_);
        AbstractBossMagic entity = this.getShot(world, player, info);
        entity.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.0f, 0.0f);
        entity.m_6686_(0.0, 0.0, 0.0, 1.35f, 0.0f);
        entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        entity.setHitDead(false);
        entity.setNotDamage(true);
        entity.setData(this.getTier() >= 5 ? 1 : 0);
        entity.setRotData(-player.m_146908_());
        entity.acceEffect(info);
        int summonTime = this.getSummonTime();
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        if (!leg.m_41619_() && (item = leg.m_41720_()) instanceof IPorch) {
            IPorch porch = (IPorch)item;
            float addRate = 0.0f;
            int summonCount = porch.acceCount(leg, ItemInit.summon_book, 5);
            if (summonCount > 0) {
                addRate = (float)summonCount * 0.2f;
            }
            if (porch.hasAcce(leg, ItemInit.twilight_hourglass)) {
                summonTime = (int)((float)summonTime * 1.25f);
                addRate += 0.25f;
            }
            summonTime = (int)((float)summonTime * (1.0f + addRate));
        }
        entity.setMaxLifeTime(summonTime);
        if (this.data >= 5) {
            entity.setData(1);
            this.addBuff(player, summonTime);
        }
        if (!world.m_5776_()) {
            world.m_7967_((Entity)entity);
        }
        return true;
    }

    public AbstractBossMagic getShot(Level world, Player player, WandInfo info) {
        return switch (this.data) {
            case 1 -> new HolyBusterMagic(world, (LivingEntity)player, info);
            case 2 -> new IgnisBlastMagic(world, (LivingEntity)player, info);
            case 3 -> new WindStormMagic(world, (LivingEntity)player, info);
            case 4 -> new CherryRainMagic(world, (LivingEntity)player, info);
            case 5 -> new InfinitWandMagic(world, (LivingEntity)player, info);
            case 6 -> new FrostLaserMagic(world, (LivingEntity)player, info);
            case 7 -> new HolyBusterMagic(world, (LivingEntity)player, info);
            case 8 -> new IgnisBlastMagic(world, (LivingEntity)player, info);
            case 9 -> new WindStormMagic(world, (LivingEntity)player, info);
            case 10 -> new CherryRainMagic(world, (LivingEntity)player, info);
            default -> new FrostLaserMagic(world, (LivingEntity)player, info);
        };
    }

    public void addBuff(Player player, int time) {
        PlayerHelper.setPotion((LivingEntity)player, this.getBuf(), 0, time);
    }

    public MobEffect getBuf() {
        return switch (this.data) {
            case 6 -> PotionInit.queen_bless;
            case 7 -> PotionInit.holy_bless;
            case 8 -> PotionInit.knight_bless;
            case 9 -> PotionInit.witch_bless;
            case 10 -> PotionInit.arlaune_bless;
            default -> PotionInit.sandryon_bless;
        };
    }

    @Override
    public boolean isUniqueMagic() {
        return true;
    }

    @Override
    public boolean isEqualMagic(ItemStack stack, MagicInfo info) {
        return stack.m_150930_(info.getItem()) || this.data >= 6 && stack.m_150930_(this.getUniqueItem());
    }

    public Item getUniqueItem() {
        return switch (this.data) {
            case 7 -> ItemInit.magic_holybuster;
            case 8 -> ItemInit.magic_ignisblast;
            case 9 -> ItemInit.magic_windstorm;
            case 10 -> ItemInit.magic_cherryrain;
            default -> ItemInit.magic_frostlaser;
        };
    }

    @Override
    public int getSummonTime() {
        switch (this.data) {
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return 500;
            }
        }
        return 400;
    }

    @Override
    public void addTip(ItemStack stack, List<Component> toolTip) {
        if (this.data > 4) {
            return;
        }
        toolTip.add((Component)this.getText("summon_boss_get").m_130940_(RED));
    }
}

