/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.item.magic;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.api.emagic.SMElement;
import sweetmagic.api.emagic.SMMagicType;
import sweetmagic.api.iitem.IPorch;
import sweetmagic.api.iitem.IWand;
import sweetmagic.api.iitem.info.MagicInfo;
import sweetmagic.api.iitem.info.WandInfo;
import sweetmagic.init.ItemInit;
import sweetmagic.init.PotionInit;
import sweetmagic.init.SoundInit;
import sweetmagic.init.entity.animal.AbstractSummonMob;
import sweetmagic.init.entity.animal.StellaWizard;
import sweetmagic.init.entity.animal.WitchAllay;
import sweetmagic.init.entity.animal.WitchCat;
import sweetmagic.init.entity.animal.WitchFox;
import sweetmagic.init.entity.animal.WitchGolem;
import sweetmagic.init.entity.animal.WitchIfrit;
import sweetmagic.init.entity.animal.WitchMaster;
import sweetmagic.init.entity.animal.WitchWindine;
import sweetmagic.init.entity.animal.WitchWolf;
import sweetmagic.init.item.magic.BaseMagicItem;

public class SummonMagic
extends BaseMagicItem {
    public final int data;

    public SummonMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data) {
        super(name, SMMagicType.SUMMON, ele, tier, coolTime, useMF, false);
        this.data = data;
    }

    public SummonMagic(String name, SMElement ele, int tier, int coolTime, int useMF, int data, String iconName) {
        super(name, SMMagicType.SUMMON, ele, tier, coolTime, useMF, false, iconName);
        this.data = data;
    }

    public SummonMagic(String name, SMElement ele, SMElement subEle, int tier, int coolTime, int useMF, int data) {
        super(name, SMMagicType.SUMMON, ele, subEle, tier, coolTime, useMF, false, name);
        this.data = data;
    }

    @Override
    public List<MutableComponent> magicToolTip(List<MutableComponent> toolTip) {
        toolTip.add(this.getText(this.name));
        switch (this.data) {
            case 6: {
                toolTip.add(this.getText(this.name + "1"));
                toolTip.add(this.getText(this.name + "2"));
                toolTip.add(this.getText(this.name + "3"));
            }
        }
        toolTip.add(this.getText("summon_status"));
        toolTip.add(this.getText("summon_keep"));
        return toolTip;
    }

    @Override
    public boolean onItemAction(Level world, Player player, WandInfo wandInfo, MagicInfo magicInfo) {
        this.summonAction(world, player, wandInfo);
        this.playSound(world, player.m_20183_(), SoundInit.HORAMAGIC, 0.1f, 1.0f);
        return true;
    }

    public boolean summonAction(Level world, Player player, WandInfo info) {
        Vec3 src = new Vec3(player.m_20185_(), player.m_20186_(), player.m_20189_()).m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 look = player.m_20252_(1.0f);
        Vec3 dest = src.m_82520_(look.f_82479_ * 3.0, player.m_20186_(), look.f_82481_ * 3.0);
        BlockPos pos = new BlockPos((int)dest.f_82479_, (int)player.m_20186_() + 1, (int)dest.f_82481_);
        AbstractSummonMob entity = this.getMob(world, player, info);
        entity.m_6034_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        entity.m_21828_(player);
        entity.tamedState(info);
        if (this.data == 7) {
            entity.setRange(7.5f);
        } else if (this.data == 0) {
            Predicate<ItemStack> flag = s -> s.m_41720_() instanceof SummonMagic;
            List<ItemStack> magicList = IWand.getMagicList(IWand.getWandList(player), flag);
            ArrayList magicItemList = new ArrayList();
            magicList.forEach(s -> magicItemList.add(s.m_41720_()));
            if (magicItemList.contains(ItemInit.magic_summon_allay)) {
                entity.setAlay(true);
            }
            if (magicItemList.contains(ItemInit.magic_summon_golem)) {
                entity.setGolem(true);
                entity.m_21051_(Attributes.f_22276_).m_22100_((double)(entity.m_21233_() * 1.25f));
            }
            if (magicItemList.contains(ItemInit.magic_summon_fox)) {
                entity.setFox(true);
            }
        }
        int summonTime = 2400;
        ItemStack leg = player.m_6844_(EquipmentSlot.LEGS);
        IPorch porch = IPorch.getPorch(leg);
        if (porch != null) {
            int ribbonCount;
            int extensionCount;
            float addRate = 0.0f;
            int summonCount = porch.acceCount(leg, ItemInit.summon_book, 5);
            if (summonCount > 0) {
                addRate = (float)summonCount * 0.2f;
            }
            if (porch.hasAcce(leg, ItemInit.twilight_hourglass)) {
                summonTime = (int)((float)summonTime * 1.25f);
                addRate += 0.25f;
            }
            if ((extensionCount = porch.acceCount(leg, ItemInit.extension_ring, 8)) > 0) {
                entity.setRange(entity.getRange() + (float)extensionCount * 0.5f);
            }
            if ((ribbonCount = porch.acceCount(leg, ItemInit.wizard_ribbon, 5)) > 0) {
                entity.setAttribute(Attributes.f_22276_, 1.0f + (float)ribbonCount * 0.05f);
                entity.m_21153_(entity.m_21233_());
                entity.setHealthArmor(entity.m_21233_() * (float)ribbonCount * 0.1f);
            }
            summonTime = (int)((float)summonTime * (1.0f + addRate));
        }
        summonTime = (int)((float)summonTime * (1.0f + Math.min(5.0f, (float)info.getLevel() * 0.2f)));
        entity.setMaxLifeTime(summonTime);
        this.addPotion((LivingEntity)entity, PotionInit.magic_array, 0, 100);
        if (!world.m_5776_()) {
            world.m_7967_((Entity)entity);
        }
        return true;
    }

    public AbstractSummonMob getMob(Level world, Player player, WandInfo info) {
        return switch (this.data) {
            case 1 -> new WitchAllay(world);
            case 2 -> new WitchGolem(world);
            case 3 -> new WitchMaster(world);
            case 4 -> new WitchWindine(world);
            case 5 -> new WitchIfrit(world);
            case 6 -> new WitchFox(world);
            case 7 -> new WitchCat(world);
            case 8 -> new StellaWizard(world);
            default -> new WitchWolf(world);
        };
    }

    @Override
    public boolean isUniqueMagic() {
        return this.data == 8;
    }

    @Override
    public int getSummonTime() {
        return 2400;
    }

    @Override
    public void addTip(ItemStack stack, List<Component> toolTip) {
        if (this.data != 8) {
            return;
        }
        toolTip.add((Component)this.getText("summon_boss_get").m_130940_(RED));
    }
}

