/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.potion;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import sweetmagic.init.ParticleInit;
import sweetmagic.init.PotionInit;
import sweetmagic.util.PlayerHelper;
import sweetmagic.util.SMDamage;

public class SMEffect
extends MobEffect {
    private int tickTime = 0;
    private final boolean isActive;
    public static final UUID MODIFIER_UUID = UUID.fromString("CE9DBC2A-EE3F-43F5-9DF7-F7F1EE4915A9");
    public static final UUID SPEED_UUID = UUID.fromString("CE9DBC2A-EE3F-43F5-9DF7-F7F1EE1222A9");

    public SMEffect(String name, int data, MobEffectCategory buff, boolean isActive) {
        super(buff, 0);
        this.isActive = isActive;
        PotionInit.potionMap.put(this, name);
    }

    public SMEffect(String name, int data, MobEffectCategory buff) {
        super(buff, 0);
        boolean bl = this.isActive = data == 7;
        if (data == 3) {
            this.m_19472_(Attributes.f_22279_, MODIFIER_UUID.toString(), -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL);
        } else if (data == 7) {
            this.m_19472_(Attributes.f_22279_, SPEED_UUID.toString(), -0.25, AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        PotionInit.potionMap.put(this, name);
    }

    public void m_6742_(LivingEntity entity, int level) {
        Player player;
        ++this.tickTime;
        if (this == PotionInit.reflash_effect) {
            this.actionReflash(entity);
        } else if (this == PotionInit.deadly_poison) {
            if (entity.m_21223_() > 1.0f) {
                this.magicDamage(entity, 1.0f);
            }
        } else if (this == PotionInit.bleeding) {
            if (entity.m_21223_() > 0.5f) {
                entity.m_21153_(entity.m_21223_() - 0.5f);
                this.magicDamage(entity, 1.0E-4f);
            }
        } else if (this == PotionInit.regeneration) {
            if (entity.m_21223_() < entity.m_21233_()) {
                entity.m_5634_(1.0f);
                Level level2 = entity.m_9236_();
                if (level2 instanceof ServerLevel) {
                    ServerLevel sever = (ServerLevel)level2;
                    RandomSource rand = sever.m_213780_();
                    double x = entity.f_19854_;
                    double y = entity.f_19855_ + 1.0;
                    double z = entity.f_19856_;
                    for (int i = 0; i < 8; ++i) {
                        double xS = rand.m_188583_() * 0.02;
                        double yS = rand.m_188583_() * 0.02;
                        double zS = rand.m_188583_() * 0.02;
                        sever.m_8767_((ParticleOptions)ParticleTypes.f_123748_, this.getRandPos(x, rand, 0.5), this.getRandPos(y, rand, 1.0), this.getRandPos(z, rand, 0.5), 0, xS, yS, zS, 1.0);
                    }
                }
            }
        } else if (this == PotionInit.attack_disable) {
            if (entity.m_21223_() < entity.m_21233_()) {
                entity.m_5634_(0.25f);
            }
        } else if (this == PotionInit.belial_flame) {
            this.magicDamage(entity, 1.0f * (float)(entity.m_21124_(PotionInit.belial_flame).m_19564_() + 1));
            Level rand = entity.m_9236_();
            if (rand instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)rand;
                rand = sever.m_213780_();
                double x = entity.f_19854_;
                double y = entity.f_19855_ + 1.0;
                double z = entity.f_19856_;
                for (int i = 0; i < 8; ++i) {
                    double xS = rand.m_188583_() * 0.02;
                    double yS = rand.m_188583_() * 0.02;
                    double zS = rand.m_188583_() * 0.02;
                    sever.m_8767_((ParticleOptions)ParticleInit.BELIAL_FLAME, this.getRandPos(x, (RandomSource)rand, 0.5), this.getRandPos(y, (RandomSource)rand, 1.0), this.getRandPos(z, (RandomSource)rand, 0.5), 0, xS, yS, zS, 1.0);
                }
            }
        } else if (this == PotionInit.flame) {
            this.magicDamage(entity, 0.75f + (float)(level - 1) * 0.15f);
            Level rand = entity.m_9236_();
            if (rand instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)rand;
                rand = sever.m_213780_();
                double x = entity.f_19854_;
                double y = entity.f_19855_ + 1.0;
                double z = entity.f_19856_;
                for (int i = 0; i < 8; ++i) {
                    double xS = rand.m_188583_() * 0.02;
                    double yS = rand.m_188583_() * 0.02;
                    double zS = rand.m_188583_() * 0.02;
                    sever.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.getRandPos(x, (RandomSource)rand, 0.5), this.getRandPos(y, (RandomSource)rand, 1.0), this.getRandPos(z, (RandomSource)rand, 0.5), 0, xS, yS, zS, 1.0);
                }
            }
        } else if (this == PotionInit.frost && level > 0) {
            this.magicDamage(entity, 1.0f + (float)(level - 1) * 0.05f);
        } else if (this == PotionInit.gravity) {
            Vec3 vec = entity.m_20184_();
            double x = vec.f_82479_;
            double y = vec.f_82480_;
            double z = vec.f_82481_;
            if (!entity.m_20096_()) {
                y -= (double)(level + 2) * 0.0275;
            }
            if (level >= 1) {
                x *= Math.max(1.0 - (double)level * 0.15, 0.0);
                z *= Math.max(1.0 - (double)level * 0.15, 0.0);
            }
            entity.m_20256_(new Vec3(x, y, z));
        } else if (this == PotionInit.bubble) {
            Level i;
            Vec3 vec = entity.m_20184_();
            double vX = vec.f_82479_ * 0.67;
            double vY = 0.033;
            double vZ = vec.f_82481_ * 0.67;
            entity.m_20256_(new Vec3(vX, vY, vZ));
            if (level >= 1 && this.tickTime % 20 == 0) {
                this.magicDamage(entity, 1.0f + (float)level * 0.5f);
            }
            if ((i = entity.m_9236_()) instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)i;
                Random rand = new Random();
                float x = (float)entity.m_20185_() - 0.25f + rand.nextFloat() * 0.5f;
                float y = (float)entity.m_20186_() + 0.25f + rand.nextFloat() * 0.5f;
                float z = (float)entity.m_20189_() - 0.15f + rand.nextFloat() * 0.5f;
                sever.m_8767_((ParticleOptions)ParticleInit.BUBBLE, (double)x, (double)y, (double)z, 1, 0.0, 0.0, 0.0, (double)0.03f);
            }
        } else if (this == PotionInit.darkness_fog) {
            Level vX = entity.m_9236_();
            if (vX instanceof ServerLevel) {
                ServerLevel sever = (ServerLevel)vX;
                RandomSource rand = sever.m_213780_();
                double x = entity.f_19854_;
                double y = entity.f_19855_ + 1.0;
                double z = entity.f_19856_;
                double xS = rand.m_188500_() * 0.075;
                double yS = 0.05 + rand.m_188500_() * 0.1;
                double zS = rand.m_188500_() * 0.075;
                sever.m_8767_((ParticleOptions)ParticleInit.DARK, this.getRandPos(x, rand, 0.75), this.getRandPos(y, rand, 1.0) + 0.5, this.getRandPos(z, rand, 0.75), 0, xS, yS, zS, 1.0);
            }
        } else if (this == PotionInit.non_destructive && entity instanceof Player && !(player = (Player)entity).m_7500_() && !player.m_5833_() && player.m_150110_().f_35935_) {
            player.m_20256_(player.m_20184_().m_82520_(0.0, -0.16, 0.0));
        }
        if (this.tickTime > 20) {
            this.tickTime = 0;
        }
    }

    public void actionReflash(LivingEntity entity) {
        List<MobEffectInstance> effecList = PlayerHelper.getEffectList(entity, PotionInit.DEBUFF);
        effecList.forEach(p -> entity.m_21195_(p.m_19544_()));
    }

    public boolean m_6584_(int time, int level) {
        if (this == PotionInit.deadly_poison || this == PotionInit.flame || this == PotionInit.bleeding || this == PotionInit.regeneration || this == PotionInit.attack_disable) {
            int j = 25 >> level;
            return j > 0 ? time % j == 0 : true;
        }
        if (this == PotionInit.frost && time >= 1) {
            int j = 40 >> level;
            return j > 0 ? time % j == 0 : true;
        }
        if (this == PotionInit.belial_flame) {
            return time % 20 == 0;
        }
        return this.isActive;
    }

    public double getRandPos(double pos, RandomSource rand, double scale) {
        return pos + (rand.m_188500_() - rand.m_188500_()) * scale;
    }

    public void magicDamage(LivingEntity entity, float dame) {
        entity.m_6469_(SMDamage.getDebuffDamage(entity.m_9236_()), dame);
        entity.f_19802_ = 0;
    }
}

