/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMagiaAccelerator;
import sweetmagic.init.tile.sm.TileSMMagic;
import sweetmagic.util.RenderUtil;

public class RenderMagiaAccelerator<T extends TileMagiaAccelerator>
extends RenderAbstractTile<T> {
    public RenderMagiaAccelerator(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        if (!((TileMagiaAccelerator)tile).isRangeView) {
            return;
        }
        Level world = tile.m_58904_();
        double posX = tile.m_58899_().m_123341_();
        double posY = tile.m_58899_().m_123342_();
        double posZ = tile.m_58899_().m_123343_();
        Iterable<BlockPos> posList = ((TileAbstractSM)tile).getRangePosUnder(tile.m_58899_(), ((TileMagiaAccelerator)tile).range);
        for (BlockPos pos : posList) {
            TileSMMagic magic;
            BlockEntity blockEntity = ((TileAbstractSM)tile).getTile(pos);
            if (!(blockEntity instanceof TileSMMagic) || !(magic = (TileSMMagic)blockEntity).getReceive() || magic instanceof TileMagiaAccelerator) continue;
            VoxelShape voxel = world.m_8055_(pos).m_60812_((BlockGetter)world, pos);
            VertexConsumer con = info.buf().m_6299_(RenderType.m_173247_());
            this.drawShape(info.pose(), con, voxel, -posX + (double)pos.m_123341_(), -posY + (double)pos.m_123342_() + 0.01, -posZ + (double)pos.m_123343_());
        }
    }

    private void drawShape(PoseStack pose, VertexConsumer con, VoxelShape voxel, double x, double y, double z) {
        Matrix4f mat4 = pose.m_85850_().m_252922_();
        Matrix3f mat3 = pose.m_85850_().m_252943_();
        voxel.m_83224_((x1, y1, z1, x2, y2, z2) -> {
            con.m_252986_(mat4, (float)(x1 + x), (float)(y1 + y), (float)(z1 + z)).m_85950_(1.0f, 0.14901961f, 0.19215687f, 1.0f).m_252939_(mat3, 5.0f, 5.0f, 5.0f).m_5752_();
            con.m_252986_(mat4, (float)(x2 + x), (float)(y2 + y), (float)(z2 + z)).m_85950_(1.0f, 0.14901961f, 0.19215687f, 1.0f).m_252939_(mat3, 5.0f, 5.0f, 5.0f).m_5752_();
        });
    }
}

