/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Objects;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.joml.Quaternionf;
import sweetmagic.SweetMagicCore;
import sweetmagic.init.BlockInit;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TileMagiaCrystalLight;
import sweetmagic.util.RenderUtil;

public class RenderMagiaCrystalLight<T extends TileMagiaCrystalLight>
extends RenderAbstractTile<T> {
    private static final Block SQUARE_BLOCK_L = BlockInit.magic_square_l_blank;
    private static final Block SQUARE_BLOCK_S = BlockInit.magic_square_s_blank;
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private static final ResourceLocation CRYSTAL = SweetMagicCore.getSRC("textures/entity/magiaflux_core.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)CRYSTAL);
    private final ModelPart cube;

    public RenderMagiaCrystalLight(BlockEntityRendererProvider.Context con) {
        super(con);
        ModelPart model = con.m_173582_(ModelLayers.f_171145_);
        this.cube = model.m_171324_("cube");
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        this.renderCrystal(tile, parTick, info);
        this.renderSquare(tile, parTick, info);
    }

    public void renderCrystal(T tile, float parTick, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        float f1 = ((float)gameTime + parTick) * 1.25f;
        VertexConsumer vert = info.buf().m_6299_(RENDER_TYPE).m_85950_(0.0f, 0.0f, 0.0f, 1.0f);
        pose.m_85837_(0.5, 1.25, 0.5);
        pose.m_85841_(1.3f, 1.3f, 1.35f);
        pose.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        pose.m_252781_(Axis.f_252529_.m_252977_(f1));
        pose.m_252781_(Axis.f_252436_.m_252977_(f1));
        pose.m_252781_(Axis.f_252403_.m_252977_(f1));
        this.cube.m_104301_(pose, vert, info.light(), info.overlay());
        pose.m_85849_();
    }

    public void renderSquare(T tile, float parTick, RenderUtil.RenderInfo info) {
        int gameTime = ((TileAbstractSM)tile).getClientTime();
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, Math.sin(((float)gameTime + parTick) / 15.0f) * 0.02 + 0.35, 0.5);
        pose.m_85841_(2.0f, 2.0f, 2.0f);
        float f = -((float)gameTime + parTick) / 20.0f;
        Objects.requireNonNull(this);
        float angle = f * 57.295776f;
        pose.m_252781_(Axis.f_252436_.m_252977_(angle));
        pose.m_85837_(-0.5, 0.2, -0.5);
        RenderUtil.RenderColor color = RenderUtil.RenderColor.create(76.0f, 165.0f, 255.0f, info);
        RenderUtil.renderBlock(info, color, SQUARE_BLOCK_L);
        pose.m_85837_(0.125, -0.15, 0.125);
        pose.m_85841_(0.75f, 0.75f, 0.75f);
        RenderUtil.renderBlock(info, color, SQUARE_BLOCK_S);
        pose.m_85849_();
    }
}

