/*
 * Decompiled with CFR 0.152.
 */
package sweetmagic.init.render.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import sweetmagic.init.block.sm.Plate;
import sweetmagic.init.render.block.RenderAbstractTile;
import sweetmagic.init.tile.sm.TileAbstractSM;
import sweetmagic.init.tile.sm.TilePlate;
import sweetmagic.util.RenderUtil;

public class RenderPlate<T extends TilePlate>
extends RenderAbstractTile<T> {
    public RenderPlate(BlockEntityRendererProvider.Context con) {
        super(con);
    }

    @Override
    public void render(T tile, float parTick, RenderUtil.RenderInfo info) {
        ItemStack stack;
        int data = ((TilePlate)tile).getData();
        PoseStack pose = info.pose();
        if (data == 0) {
            pose.m_85836_();
            RenderUtil.renderBlock(tile.m_58904_(), tile.m_58899_(), tile.m_58900_(), this.bRender, pose, info.buf(), info.overlay());
            pose.m_85849_();
        }
        if ((stack = ((TilePlate)tile).getInputItem(0)).m_41619_() && data != 3) {
            return;
        }
        switch (data) {
            case 0: {
                this.renderPlateBlock(tile, stack, info);
                break;
            }
            case 1: {
                this.renderTrayBlock(tile, stack, info);
                break;
            }
            case 2: {
                this.renderBasketBlock(tile, stack, info);
                break;
            }
            case 3: {
                this.renderShowCase(tile, info);
                break;
            }
            case 4: {
                this.renderDigTrayBlock(tile, stack, info);
            }
        }
    }

    public void renderPlateBlock(T tile, ItemStack stack, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_85837_(0.5, 0.1, 0.5);
        pose.m_252781_(Axis.f_252436_.m_252977_(((TileAbstractSM)tile).getRot()));
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.m_40614_();
            if (block instanceof Plate) {
                Plate plate = (Plate)block;
                this.renderPlate(tile, plate, stack, info);
            } else {
                this.renderBlock(stack, info);
            }
        } else {
            this.renderItem(stack, info);
        }
        pose.m_85849_();
    }

    public void renderTrayBlock(T tile, ItemStack stack, RenderUtil.RenderInfo info) {
        boolean isBlock = stack.m_41720_() instanceof BlockItem;
        double addY = isBlock ? -0.05 : 0.0;
        double addZ = isBlock ? 0.275 : 0.0;
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                RenderUtil.renderItem(info, tile, stack, 1.825 - (double)x * 1.0, 0.775 + addY, 0.85 + (double)z * 0.75 + addZ);
            }
        }
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_252781_(Axis.f_252436_.m_252977_(((TileAbstractSM)tile).getRot()));
        this.rotPosFix(pose, ((TileAbstractSM)tile).getFace());
        pose.m_85837_(0.5, 0.74, 0.955);
        pose.m_85841_(-0.01f, -0.01f, 0.01f);
        int nameSize = this.font.m_92895_(stack.m_41786_().getString());
        float f3 = (float)(-nameSize) / 2.0f;
        pose.m_85841_((float)nameSize < 45.0f ? 1.0f : 45.0f / (float)nameSize, 1.0f, 1.0f);
        int j = (int)(Minecraft.m_91087_().f_91066_.m_92141_(0.25f) * 255.0f) << 24;
        this.font.m_272077_(stack.m_41786_(), f3, 0.5f, 0, false, pose.m_85850_().m_252922_(), info.buf(), Font.DisplayMode.NORMAL, j, info.light());
        pose.m_85849_();
    }

    public void renderBasketBlock(T tile, ItemStack stack, RenderUtil.RenderInfo info) {
        boolean isBlock = stack.m_41720_() instanceof BlockItem;
        double addY = isBlock ? -0.05 : 0.0;
        double addZ = isBlock ? 0.125 : 0.0;
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                RenderUtil.renderItem(info, tile, stack, 1.825 - (double)x * 1.0, 0.525 + addY, 1.075 + (double)z * 0.75 + addZ);
            }
        }
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_252781_(Axis.f_252436_.m_252977_(((TileAbstractSM)tile).getRot()));
        this.rotPosFix(pose, ((TileAbstractSM)tile).getFace());
        pose.m_85837_(0.5, 0.145, 0.0445);
        pose.m_85841_(-0.01f, -0.01f, 0.01f);
        int nameSize = this.font.m_92895_(stack.m_41786_().getString());
        float f3 = (float)(-nameSize) / 2.0f;
        pose.m_85841_((float)nameSize < 45.0f ? 1.0f : 45.0f / (float)nameSize, 1.0f, 1.0f);
        int j = (int)(Minecraft.m_91087_().f_91066_.m_92141_(0.25f) * 255.0f) << 24;
        this.font.m_272077_(stack.m_41786_(), f3 + 0.75f, 0.5f, 0xFFFFFF, false, pose.m_85850_().m_252922_(), info.buf(), Font.DisplayMode.NORMAL, j, info.light());
        pose.m_85849_();
    }

    public void renderShowCase(T tile, RenderUtil.RenderInfo info) {
        for (int i = 0; i < ((TilePlate)tile).getInvSize(); ++i) {
            ItemStack stack = ((TilePlate)tile).getInputItem(i);
            if (stack.m_41619_()) continue;
            boolean isBlock = stack.m_41720_() instanceof BlockItem;
            double addY = isBlock ? 0.15 : 0.0;
            for (int x = 0; x < 2; ++x) {
                for (int z = 0; z < 2; ++z) {
                    double pX = isBlock ? 1.675 - (double)x * 0.675 : 1.8 - (double)x;
                    RenderUtil.renderItem(info, tile, stack, pX, 1.75 - (double)i * 1.15 + addY, 1.25 + (double)z * 0.75);
                }
            }
        }
    }

    public void renderPlate(T tile, Plate plate, ItemStack stack, RenderUtil.RenderInfo info) {
        ModelBlockRenderer.m_111000_();
        PoseStack pose = info.pose();
        pose.m_85837_(-0.5, -0.025, -0.5);
        int value = Math.min(stack.m_41613_(), 12);
        for (int i = 0; i < value; ++i) {
            RenderUtil.renderBlock(tile.m_58904_(), tile.m_58899_(), plate.m_49966_(), this.bRender, pose, info.buf(), info.overlay());
            pose.m_85837_(0.0, 0.075, 0.0);
        }
        ModelBlockRenderer.m_111077_();
    }

    public void renderDigTrayBlock(T tile, ItemStack stack, RenderUtil.RenderInfo info) {
        boolean isBlock = stack.m_41720_() instanceof BlockItem;
        double addY = isBlock ? -0.05 : 0.0;
        double addZ = isBlock ? 0.125 : 0.0;
        for (int x = 0; x < 2; ++x) {
            for (int z = 0; z < 2; ++z) {
                RenderUtil.renderItem(info, tile, stack, 1.825 - (double)x * 1.0, 0.8675 + addY + (double)z * 0.45, 1.075 + (double)z * 0.75 + addZ);
            }
        }
        PoseStack pose = info.pose();
        pose.m_85836_();
        pose.m_252781_(Axis.f_252436_.m_252977_(((TileAbstractSM)tile).getRot()));
        this.rotPosFix(pose, ((TileAbstractSM)tile).getFace());
        pose.m_85837_(0.5, 0.145, 0.0445);
        pose.m_85841_(-0.01f, -0.01f, 0.01f);
        int nameSize = this.font.m_92895_(stack.m_41786_().getString());
        float f3 = (float)(-nameSize) / 2.0f;
        pose.m_85841_((float)nameSize < 45.0f ? 1.0f : 45.0f / (float)nameSize, 1.0f, 1.0f);
        int j = (int)(Minecraft.m_91087_().f_91066_.m_92141_(0.25f) * 255.0f) << 24;
        this.font.m_272077_(stack.m_41786_(), f3, 0.75f, 0xFFFFFF, false, pose.m_85850_().m_252922_(), info.buf(), Font.DisplayMode.NORMAL, j, info.light());
        pose.m_85849_();
    }

    public void renderItem(ItemStack stack, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85841_(0.675f, 0.675f, 0.675f);
        pose.m_252880_(0.0f, 0.25f, 0.0f);
        info.itemRenderNo(stack);
    }

    public void renderBlock(ItemStack stack, RenderUtil.RenderInfo info) {
        PoseStack pose = info.pose();
        pose.m_85837_(0.0, 0.0, 0.0);
        pose.m_85841_(0.75f, 0.75f, 0.75f);
        pose.m_252781_(Axis.f_252495_.m_252977_(-90.0f));
        info.itemRenderNo(stack);
    }

    public void rotPosFix(PoseStack pose, Direction face) {
        switch (face) {
            case SOUTH: {
                pose.m_85837_(-1.0, 0.0, -1.0);
                break;
            }
            case WEST: {
                pose.m_85837_(-1.0, 0.0, 0.0);
                break;
            }
            case EAST: {
                pose.m_85837_(0.0, 0.0, -1.0);
            }
        }
    }

    @Override
    public int m_142163_() {
        return 24;
    }
}

